/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Vector;
import util.AbstractDataModel;
import util.DataModelEvent;
import util.TableCellIndex;
import util.UnsignedByte;
import util.UserVisibleException;

public abstract class AbstractMainMemory
extends AbstractDataModel {
    public Port getPort(MMU mmu) {
        return new Port(mmu);
    }

    Port getPort() {
        return this.getPort(new MMU());
    }

    protected abstract UnsignedByte[] get(int var1, int var2) throws InvalidAddressException;

    protected abstract void set(int var1, UnsignedByte[] var2) throws InvalidAddressException;

    protected abstract boolean isAccessAligned(int var1, int var2);

    public abstract int bytesToInteger(UnsignedByte var1, UnsignedByte var2, UnsignedByte var3, UnsignedByte var4);

    public abstract UnsignedByte[] integerToBytes(int var1);

    public abstract int length();

    public final UnsignedByte[] read(int address, int length) throws InvalidAddressException {
        if (this.isAccessAligned(address, length)) {
            return this.readUnaligned(address, length);
        }
        throw new InvalidAddressException();
    }

    public final void write(int address, UnsignedByte[] value) throws InvalidAddressException {
        if (!this.isAccessAligned(address, value.length)) {
            throw new InvalidAddressException();
        }
        this.writeUnaligned(address, value);
    }

    public final UnsignedByte[] readUnaligned(int address, int length) throws InvalidAddressException {
        UnsignedByte[] value = this.get(address, length);
        Vector<TableCellIndex> cells = new Vector<TableCellIndex>();
        for (int i = 0; i < length; ++i) {
            cells.add(new TableCellIndex(address + i, 1));
        }
        this.tellObservers(new DataModelEvent(DataModelEvent.Type.READ, cells));
        return value;
    }

    public final void writeUnaligned(int address, UnsignedByte[] value) throws InvalidAddressException {
        this.set(address, value);
        Vector<TableCellIndex> cells = new Vector<TableCellIndex>();
        for (int i = 0; i < value.length; ++i) {
            cells.add(new TableCellIndex(address + i, 1));
        }
        this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE, cells));
    }

    public int readInteger(int address) throws InvalidAddressException {
        if (this.isAccessAligned(address, 4)) {
            return this.readIntegerUnaligned(address);
        }
        throw new InvalidAddressException();
    }

    public void writeInteger(int address, int value) throws InvalidAddressException {
        if (!this.isAccessAligned(address, 4)) {
            throw new InvalidAddressException();
        }
        this.writeIntegerUnaligned(address, value);
    }

    public int readIntegerUnaligned(int address) throws InvalidAddressException {
        UnsignedByte[] b = this.readUnaligned(address, 4);
        return this.bytesToInteger(b[0], b[1], b[2], b[3]);
    }

    public void writeIntegerUnaligned(int address, int value) throws InvalidAddressException {
        this.writeUnaligned(address, this.integerToBytes(value));
    }

    public boolean valueEquals(AbstractMainMemory anotherMemory) {
        try {
            return Arrays.equals(this.get(0, this.length()), anotherMemory.get(0, anotherMemory.length()));
        }
        catch (InvalidAddressException e) {
            return false;
        }
    }

    public static AbstractMainMemory newInstance(AbstractMainMemory aMem) {
        Class<?> memClass = aMem.getClass();
        try {
            Constructor<?> memCtor = memClass.getConstructor(Integer.TYPE);
            return (AbstractMainMemory)memCtor.newInstance(aMem.length());
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        if (columnIndex == 1) {
            return Byte.class;
        }
        throw new AssertionError();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Address";
        }
        if (columnIndex == 1) {
            return "Value";
        }
        throw new AssertionError();
    }

    public int getRowCount() {
        return this.length();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return new Integer(rowIndex);
        }
        if (columnIndex == 1) {
            try {
                return new Byte((byte)this.get(rowIndex, 1)[0].value());
            }
            catch (InvalidAddressException e) {
                throw new IndexOutOfBoundsException();
            }
        }
        throw new AssertionError();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        if (columnIndex == 1) {
            return true;
        }
        throw new AssertionError();
    }

    public void setValueAt(Object[] aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            Vector<TableCellIndex> writtenCells = new Vector<TableCellIndex>();
            try {
                Byte[] b = (Byte[])aValue;
                for (int i = 0; i < b.length; ++i) {
                    this.set(rowIndex + i, new UnsignedByte[]{new UnsignedByte(b[i])});
                    writtenCells.add(new TableCellIndex(rowIndex + i, columnIndex));
                }
            }
            catch (InvalidAddressException e) {
                throw new IndexOutOfBoundsException();
            }
            finally {
                this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE, writtenCells));
            }
        } else {
            throw new AssertionError();
        }
    }

    public void setValueAtByUser(Object[] aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            Vector<TableCellIndex> writtenCells = new Vector<TableCellIndex>();
            try {
                Byte[] b = (Byte[])aValue;
                for (int i = 0; i < b.length; ++i) {
                    this.set(rowIndex + i, new UnsignedByte[]{new UnsignedByte(b[i])});
                    writtenCells.add(new TableCellIndex(rowIndex + i, columnIndex));
                }
            }
            catch (InvalidAddressException e) {
                throw new IndexOutOfBoundsException();
            }
            finally {
                this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, writtenCells));
            }
        } else {
            throw new AssertionError();
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAt(new Byte[]{(Byte)aValue}, rowIndex, columnIndex);
    }

    public void setValueAtByUser(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAtByUser(new Byte[]{(Byte)aValue}, rowIndex, columnIndex);
    }

    public static class InvalidAddressException
    extends UserVisibleException {
        static final String MESSAGE = "Invalid address issued";

        public InvalidAddressException() {
            super(MESSAGE);
        }

        public InvalidAddressException(int aPC) {
            super(MESSAGE, aPC);
        }
    }

    public class Port {
        MMU mmu;

        public Port(MMU mmu) {
            this.mmu = mmu;
        }

        public UnsignedByte[] read(int address, int length) throws InvalidAddressException {
            return AbstractMainMemory.this.read(this.mmu.translate(address), length);
        }

        public UnsignedByte[] readUnaliged(int address, int length) throws InvalidAddressException {
            return AbstractMainMemory.this.readUnaligned(this.mmu.translate(address), length);
        }

        public int readInteger(int address) throws InvalidAddressException {
            return AbstractMainMemory.this.readInteger(this.mmu.translate(address));
        }

        public int readIntegerUnaligned(int address) throws InvalidAddressException {
            return AbstractMainMemory.this.readIntegerUnaligned(this.mmu.translate(address));
        }

        public void write(int address, UnsignedByte[] value) throws InvalidAddressException {
            AbstractMainMemory.this.write(this.mmu.translate(address), value);
        }

        public void writeUnaligned(int address, UnsignedByte[] value) throws InvalidAddressException {
            AbstractMainMemory.this.writeUnaligned(this.mmu.translate(address), value);
        }

        public void writeInteger(int address, int value) throws InvalidAddressException {
            AbstractMainMemory.this.writeInteger(this.mmu.translate(address), value);
        }

        public void writeIntegerUnaligned(int address, int value) throws InvalidAddressException {
            AbstractMainMemory.this.writeIntegerUnaligned(this.mmu.translate(address), value);
        }
    }

    public static class MMU {
        public int translate(int address) throws InvalidAddressException {
            return address;
        }
    }
}

