/*
 * Decompiled with CFR 0.152.
 */
package isa;

import isa.Instruction;
import isa.Memory;
import isa.MemoryCell;
import isa.Region;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import util.BitString;
import util.DataModelEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionRegion
extends Region {
    private Map<InstructionMemoryValue, Instruction> trash = new HashMap<InstructionMemoryValue, Instruction>();

    public InstructionRegion(Memory aMemory) {
        super(aMemory, Region.Type.INSTRUCTIONS);
    }

    @Override
    protected void replace(Vector<MemoryCell> oldCells, Vector<MemoryCell> newCells) {
        super.replace(oldCells, newCells);
        if (oldCells != null) {
            for (MemoryCell cell : oldCells) {
                this.trash.put(new InstructionMemoryValue(cell), (Instruction)cell);
            }
        }
    }

    @Override
    MemoryCell newPlaceholderCell(int address) {
        return Instruction.valueOfPlaceholder(this.memory, address, "", "");
    }

    @Override
    void memorySyncChangedCellLength(MemoryCell cell, int oldLength) {
        this.rebuild(cell.getAddress() + cell.length(), cell.getAddress() + oldLength);
    }

    void rebuild(int newAdr, int oldAdr) {
        Vector<MemoryCell> graftIn = new Vector<MemoryCell>();
        Vector<MemoryCell> graftOut = new Vector<MemoryCell>();
        String label = "";
        String comment = "";
        int endAdr = this.getAddress() + this.byteLength() - 1;
        while (newAdr != oldAdr) {
            Instruction oldIns;
            while (newAdr > oldAdr && oldAdr <= endAdr && (oldIns = (Instruction)this.map.get(oldAdr)) != null) {
                if (label.equals("")) {
                    label = oldIns.getLabel();
                }
                if (comment.equals("")) {
                    comment = oldIns.getComment();
                }
                graftOut.add(oldIns);
                oldAdr += oldIns.length();
            }
            if (newAdr > endAdr) break;
            while (newAdr < oldAdr) {
                Instruction delIns;
                Instruction newIns = Instruction.valueOfMemory(this.memory, newAdr, label, comment);
                if (newIns == null) {
                    newIns = Instruction.valueOfPlaceholder(this.memory, newAdr, label, comment);
                }
                if ((delIns = this.trash.get(new InstructionMemoryValue(newIns))) != null) {
                    if (!delIns.getLabel().equals("")) {
                        newIns.setLabel(delIns.getLabel());
                    }
                    if (!delIns.getComment().equals("")) {
                        newIns.setComment(delIns.getComment());
                    }
                }
                newAdr += newIns.length();
                graftIn.add(newIns);
            }
        }
        this.replace(graftOut, graftIn);
        if (graftIn.size() > graftOut.size()) {
            this.tellObservers(new DataModelEvent(DataModelEvent.Type.ROWS_INSERTED, this.rows.size() - (graftIn.size() - graftOut.size()), this.rows.size() - 1));
        } else if (graftIn.size() < graftOut.size()) {
            this.tellObservers(new DataModelEvent(DataModelEvent.Type.ROWS_DELETED, this.rows.size(), this.rows.size() + (graftOut.size() - graftIn.size() - 1)));
        }
        this.fireByteLengthChanged();
    }

    @Override
    boolean isMemoryValueColumn(int columnIndex) {
        return columnIndex == 0 || columnIndex == 1 || columnIndex == 3;
    }

    @Override
    public int getAsmColumn() {
        return 3;
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        if (columnIndex == 2) {
            return Region.LabelString.class;
        }
        if (columnIndex == 3) {
            return Region.AssemblyString.class;
        }
        if (columnIndex == 4) {
            return String.class;
        }
        throw new AssertionError();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Addr";
        }
        if (columnIndex == 1) {
            return "Mac";
        }
        if (columnIndex == 2) {
            return "Label";
        }
        if (columnIndex == 3) {
            return "Asm";
        }
        if (columnIndex == 4) {
            return "Comment";
        }
        throw new AssertionError();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MemoryCell cell = (MemoryCell)this.rows.get(rowIndex);
        if (cell == null) {
            return null;
        }
        if (columnIndex == 0) {
            return cell.getAddress();
        }
        if (columnIndex == 1) {
            return cell.toMac();
        }
        if (columnIndex == 2) {
            return new Region.LabelString(this, cell.getAddress(), cell.getLabel());
        }
        if (columnIndex == 3) {
            return new Region.AssemblyString(this, cell.getAddress(), cell.getLabel(), cell.toAsm(), cell.getComment());
        }
        if (columnIndex == 4) {
            return cell.getComment();
        }
        throw new AssertionError();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        if (columnIndex == 1) {
            return false;
        }
        if (columnIndex == 2) {
            return true;
        }
        if (columnIndex == 3) {
            return true;
        }
        if (columnIndex == 4) {
            return true;
        }
        throw new AssertionError();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.getRowCount()) {
            MemoryCell cell = (MemoryCell)this.rows.get(rowIndex);
            assert (cell != null);
            if (columnIndex == 2) {
                String newValue = ((Region.LabelString)aValue).toString().trim();
                if (!newValue.equals(cell.getLabel())) {
                    this.memory.addUndo(new Region.UndoChange(this, String.format("Label Change at 0x%x\n", cell.getAddress()), rowIndex, 2, Region.UndoChangeType.LABEL));
                    this.memory.setChanged(true);
                    cell.setLabel(newValue);
                    this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, rowIndex, columnIndex));
                }
            } else if (columnIndex == 3) {
                Region.AssemblyString asm = (Region.AssemblyString)aValue;
                if (asm.hasChanged()) {
                    this.memory.addUndo(new Region.UndoChange(this, String.format("Instruction Change at 0x%x\n", cell.getAddress()), rowIndex, 3, Region.UndoChangeType.VALUE));
                    this.memory.loadAssemblyLine(cell.getAddress(), cell.getLabel(), asm.toString(), cell.getComment());
                    this.memory.setChanged(true);
                }
            } else if (columnIndex == 4) {
                String newValue = ((String)aValue).trim();
                if (!newValue.equals(cell.getComment())) {
                    this.memory.addUndo(new Region.UndoChange(this, String.format("Comment Change at 0x%x\n", cell.getAddress()), rowIndex, 4, Region.UndoChangeType.COMMENT));
                    cell.setComment(newValue);
                    this.memory.setChanged(true);
                    this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, rowIndex, columnIndex));
                }
            } else {
                throw new AssertionError();
            }
        }
    }

    class InstructionMemoryValue {
        private int address;
        private BitString value;

        public InstructionMemoryValue(MemoryCell cell) {
            this.address = cell.getAddress();
            this.value = cell.getValue();
        }

        public boolean equals(Object o) {
            if (o instanceof InstructionMemoryValue) {
                InstructionMemoryValue imv = (InstructionMemoryValue)o;
                return this.address == imv.address && this.value == imv.value;
            }
            return false;
        }

        public int hashCode() {
            return this.address + this.value.hashCode();
        }
    }
}

