/*
 * Decompiled with CFR 0.152.
 */
package arch.sm213.machine;

import machine.AbstractCPU;
import machine.AbstractMainMemory;
import machine.Register;
import machine.RegisterSet;
import util.HalfByteNumber;
import util.SixByteNumber;

public abstract class AbstractSM213CPU
extends AbstractCPU {
    protected RegisterSet ps;
    private Register ptbrReg = null;
    protected Register.Port ptbr = null;
    protected Register.Port pc;
    protected Register.Port instruction;
    protected Register.Port insOpCode;
    protected Register.Port insOp0;
    protected Register.Port insOp1;
    protected Register.Port insOp2;
    protected Register.Port insOpImm;
    protected Register.Port insOpExt;
    private Register curInst;
    protected AbstractMainMemory.Port physMem = this.mem;

    public AbstractSM213CPU(String name, AbstractMainMemory memory) {
        super(name, memory);
        for (int r = 0; r < 8; ++r) {
            this.is.regFile.addSigned(String.format("r%d", r), true);
        }
        this.ps = new RegisterSet("");
        this.is.processorState.add(this.ps);
        this.pc = this.ps.addUnsigned("PC", Integer.class, true).getPort();
        this.instruction = this.ps.addUnsigned("Instruction", SixByteNumber.class).getPort();
        this.insOpCode = this.ps.addUnsigned("Ins Op Code", HalfByteNumber.class).getPort();
        this.insOp0 = this.ps.addUnsigned("Ins Op 0", HalfByteNumber.class).getPort();
        this.insOp1 = this.ps.addUnsigned("Ins Op 1", HalfByteNumber.class).getPort();
        this.insOp2 = this.ps.addUnsigned("Ins Op 2", HalfByteNumber.class).getPort();
        this.insOpImm = this.ps.addSigned("Ins Op Imm", Byte.class).getPort();
        this.insOpExt = this.ps.addSigned("Ins Op Ext", Integer.class).getPort();
        this.curInst = this.ps.add("CurrentInstructionAddress", Integer.class, true, false, false, -1L);
    }

    public void enableVirtualMemory() {
        this.ptbrReg = this.ps.addUnsigned("PTBR", Integer.class, true);
        this.ptbr = this.ptbrReg.getPort();
        this.mem = this.is.memImp.getPort(new VirtualMemoryMMU());
    }

    public int translateAddress(int va) throws AbstractMainMemory.InvalidAddressException {
        return va;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cycle() throws AbstractCPU.InvalidInstructionException, AbstractCPU.MachineHaltException, AbstractMainMemory.InvalidAddressException {
        try {
            try {
                this.curInst.set(this.pc.get());
                this.fetch();
            }
            finally {
                if (this.ptbr != null) {
                    this.ptbr.set(this.ptbr.get());
                }
                this.tickClock();
            }
            try {
                this.execute();
            }
            finally {
                if (this.ptbr != null) {
                    this.ptbr.set(this.ptbr.get());
                }
                this.tickClock();
            }
        }
        catch (RegisterSet.InvalidRegisterNumberException ire) {
            throw new AbstractCPU.InvalidInstructionException(this);
        }
    }

    public void setPC(int aPC) {
        int p = 0;
        if (this.ptbr != null) {
            p = this.ptbr.get();
        }
        this.ps.tickClock(Register.ClockTransition.BUBBLE);
        if (this.ptbr != null) {
            this.ptbr.set(p);
            this.ptbrReg.tickClock(Register.ClockTransition.NORMAL);
        }
        super.setPC(aPC);
    }

    protected abstract void fetch() throws AbstractMainMemory.InvalidAddressException;

    protected abstract void execute() throws AbstractCPU.InvalidInstructionException, AbstractCPU.MachineHaltException, RegisterSet.InvalidRegisterNumberException, AbstractMainMemory.InvalidAddressException;

    private void tickClock() {
        this.is.regFile.tickClock(Register.ClockTransition.NORMAL);
        if (this.ptbr != null) {
            this.ptbr.set(this.ptbr.get());
        }
        this.ps.tickClock(Register.ClockTransition.NORMAL);
    }

    class VirtualMemoryMMU
    extends AbstractMainMemory.MMU {
        VirtualMemoryMMU() {
        }

        public int translate(int address) throws AbstractMainMemory.InvalidAddressException {
            return AbstractSM213CPU.this.translateAddress(address);
        }
    }
}

