/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import util.AbstractDataModel;
import util.DataModel;
import util.DataModelEvent;
import util.TableCellIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickModel
extends AbstractDataModel
implements Observer {
    DataModel base;
    List<DataModel> pickers;
    List<Integer> pickerRowIndices;
    List<Integer> pickerColumnIndices;

    public PickModel(DataModel aBase, List<DataModel> aPickers, List<Integer> aPickerRowIndices, List<Integer> aPickerColumnIndices) {
        this.base = aBase;
        this.pickers = aPickers;
        this.pickerRowIndices = aPickerRowIndices;
        this.pickerColumnIndices = aPickerColumnIndices;
        this.base.addObserver(this);
        for (DataModel picker : this.pickers) {
            picker.addObserver(this);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        DataModelEvent event = (DataModelEvent)arg;
        if (event.getType() == DataModelEvent.Type.WRITE || event.getType() == DataModelEvent.Type.WRITE_BY_USER) {
            if (o == this.base) {
                int baseRow = event.getRowIndex();
                for (int row = 0; row < this.pickers.size(); ++row) {
                    if (((Integer)this.pickers.get(row).getValueAt(this.pickerRowIndices.get(row), this.pickerColumnIndices.get(row))).intValue() != event.getRowIndex()) continue;
                    Vector<TableCellIndex> pickCells = new Vector<TableCellIndex>();
                    for (TableCellIndex baseCell : event.getCells()) {
                        pickCells.add(new TableCellIndex(row, baseCell.columnIndex));
                    }
                    this.tellObservers(new DataModelEvent(event.getType(), pickCells));
                }
            } else {
                int row = this.pickers.indexOf(o);
                assert (row != -1);
                Vector<TableCellIndex> cells = new Vector<TableCellIndex>();
                for (int col = 0; col < this.base.getColumnCount(); ++col) {
                    cells.add(new TableCellIndex(row, col));
                }
                this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, cells));
            }
        }
    }

    @Override
    public Class getColumnClass(int col) {
        return this.base.getColumnClass(col);
    }

    @Override
    public int getColumnCount() {
        return this.base.getColumnCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.base.getColumnName(col);
    }

    @Override
    public int getRowCount() {
        return this.pickers.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.base.getValueAt((Integer)this.pickers.get(row).getValueAt(this.pickerRowIndices.get(row), this.pickerColumnIndices.get(row)), col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.base.isCellEditable((Integer)this.pickers.get(row).getValueAt(this.pickerRowIndices.get(row), this.pickerColumnIndices.get(row)), col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.base.setValueAt(value, (int)((Integer)this.pickers.get(row).getValueAt(this.pickerRowIndices.get(row), this.pickerColumnIndices.get(row))), col);
    }
}

