/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import ui.gui.MessageBoard;
import ui.gui.UI;
import ui.gui.View;
import ui.gui.ViewFormat;
import ui.gui.ViewModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewPane
extends JPanel
implements View.SizeChangedListener {
    final View view;
    private final int extraHeight;
    private final int extraWidth;
    private final boolean isWidthVariable;

    public ViewPane(String title, ViewModel model, MessageBoard messageBoard, List<ViewFormat> formats) {
        super(new BorderLayout());
        JLabel tl = new JLabel(title, 0);
        tl.setFont(UI.TITLE_FONT);
        this.add((Component)tl, "North");
        JPanel bd = new JPanel(new BorderLayout());
        bd.setBorder(new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new LineBorder(UI.PANE_BORDER_COLOR, 1)));
        this.view = new View(model, messageBoard, formats);
        this.view.addSizeChangedListener(this);
        this.view.setBackground(UI.BACKGROUND_COLOR);
        bd.add((Component)this.view.getTableHeader(), "North");
        bd.add((Component)this.view, "Center");
        this.add((Component)bd, "Center");
        boolean iwv = false;
        for (ViewFormat format : formats) {
            if (!format.isWidthVariable()) continue;
            iwv = true;
            break;
        }
        this.isWidthVariable = iwv;
        this.extraWidth = 3;
        int eh = tl.getPreferredSize().height += 8;
        if (!((String)this.view.getColumnModel().getColumns().nextElement().getHeaderValue()).trim().equals("")) {
            eh += 12;
        }
        this.extraHeight = eh;
        Dimension sz = this.view.getPreferredSize();
        sz.height += this.extraHeight;
        sz.width += this.extraWidth;
        this.setPreferredSize(sz);
        if (this.isWidthVariable) {
            this.setMaximumSize(new Dimension(this.view.getMaximumSize().width, sz.height));
        } else {
            this.setMaximumSize(sz);
        }
    }

    void adjustHighlights(boolean clear) {
        this.view.adjustHighlights(clear);
    }

    void adjustFontSize(int increment) {
        this.view.adjustFontSize(increment);
        this.adjustSize();
    }

    void adjustSize() {
        Dimension sz = this.view.getPreferredSize();
        sz.height += this.extraHeight;
        sz.width += this.extraWidth;
        this.setPreferredSize(sz);
        if (this.isWidthVariable) {
            this.setMaximumSize(new Dimension(this.view.getMaximumSize().width, sz.height));
        } else {
            this.setMaximumSize(sz);
        }
    }

    @Override
    public void sizeChanged() {
        this.adjustSize();
    }

    public void setWidth(int width) {
    }
}

