/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import isa.Memory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.GlyphVector;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import ui.gui.View;

class Animator {
    private static final boolean AGGRESSIVE_GC_TO_SMOOTH_ANIMATION = true;
    private static final Color READ_TARGET_COLOR = new Color(120, 120, 240, 125);
    private static final Color WRITE_TARGET_COLOR = new Color(240, 120, 120, 125);
    private static final Color CPU_COLOR = new Color(40, 40, 40, 210);
    private static final Color CPU_LABEL_COLOR = new Color(255, 255, 255, 200);
    private static final Point CPU_BLOCK_START = new Point(4, -1);
    private static final int CPU_BLOCK_WIDTH = 116;
    private static final int CPU_BLOCK_HEIGHT = 21;
    private static final int CPU_BLOCK_SPACER = 4;
    private static final int CPU_BLOCK_ARCWIDTH = 12;
    private static final int CPU_BLOCK_ARCHEIGHT = 12;
    private static final Color ADDRESS_BLOCK_COLOR = new Color(100, 240, 100, 75);
    private static final Color CONTROL_FLOW_COLOR = new Color(100, 240, 100, 245);
    private static final int CONTROL_FLOW_FROM_OFFSET = 6;
    private static final int CONTROL_FLOW_TO_OFFSET = 7;
    private static final int CONTROL_FLOW_LINE_WIDTH = 7;
    private static final int CONTROL_FLOW_LINE_STAGGER = 11;
    private static final int ARROW_WIDTH = 9;
    private static final int ARROW_HEIGHT = 21;
    private static final int SCENE_PAUSE = 16;
    private JFrame frame;
    private Memory memory;
    private Component cpu;
    private Point cpuPos = new Point(CPU_BLOCK_START);
    private int duration;
    private Font font;
    private JComponent[] paintFirst;
    private BlockList cpuBlocks = new BlockList();
    private boolean isEnabled = false;
    private boolean isStopped = false;
    private boolean isPaused = false;
    private Scene activeScene = null;
    private Overlay clearScene = new Overlay();
    private HashMap<Integer, View> rowRenderedView = new HashMap();
    private HashMap<JComponent, Position> cfPosition = new HashMap();
    private HashMap<JComponent, Position> cfStartPosition = new HashMap();

    Animator(JFrame aFrame, Memory aMemory, Component aCpu, int aDuration, Font aFont, JComponent ... aPaintFirst) {
        this.frame = aFrame;
        this.memory = aMemory;
        this.cpu = aCpu;
        this.duration = aDuration;
        this.font = aFont;
        this.paintFirst = aPaintFirst;
    }

    private int stageSteps(Stage s) {
        return (int)((double)this.duration * s.durationWeight + 0.5) / 16;
    }

    private Rectangle convertRectangle(Component source, Rectangle rectangle) {
        return SwingUtilities.convertRectangle(source, rectangle, this.frame.getGlassPane());
    }

    private Point convertPoint(Component source, Point point) {
        return SwingUtilities.convertPoint(source, point, this.frame.getGlassPane());
    }

    private static Point clipPointToRect(Rectangle rect, Point point) {
        int x = Math.min(rect.x + rect.width - 1, Math.max(rect.x, point.x));
        int y = Math.min(rect.y + rect.height - 1, Math.max(rect.y, point.y));
        return new Point(x, y);
    }

    void setControlFlowStart(JComponent context) {
        if (this.isEnabled && !this.isStopped && this.duration > 0 && this.activeScene == null && !this.cfStartPosition.containsKey(context)) {
            this.cfStartPosition.put(context, this.cfPosition.get(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderControlFlow() {
        Animator animator = this;
        synchronized (animator) {
            assert (this.activeScene == null);
            try {
                if (!this.cfStartPosition.isEmpty()) {
                    this.activeScene = new ControlFlowWorker();
                    this.activeScene.render();
                    this.cfStartPosition.clear();
                }
            }
            finally {
                this.activeScene = null;
            }
        }
    }

    void recordControlFlow(JComponent context, View view, int row) {
        this.cfPosition.put(context, new Position(view, row));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderDataFlow(Target target, Type type, View view, int labelCol, int row, int col, int count) {
        assert (target != Target.INSTRUCTIONS);
        if (this.isEnabled && !this.isStopped && this.duration > 0 && this.activeScene == null) {
            Animator animator = this;
            synchronized (animator) {
                assert (this.activeScene == null);
                try {
                    this.activeScene = new DataFlowWorker(target, type, view, labelCol, row, col, count);
                    this.activeScene.render();
                }
                finally {
                    this.activeScene = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void clear() {
        this.renderControlFlow();
        if (!this.cpuBlocks.isEmpty() || !this.clearScene.isEmpty()) {
            assert (this.activeScene == null);
            try {
                this.activeScene = new ClearWorker();
                this.activeScene.render();
            }
            finally {
                this.activeScene = null;
            }
        }
    }

    void setDuration(int aDuration) {
        this.duration = aDuration;
    }

    int getDuration() {
        return this.duration;
    }

    void setEnabled(boolean anIsEnabled) {
        this.isEnabled = anIsEnabled;
        if (this.isEnabled) {
            this.isStopped = false;
            this.isPaused = false;
        } else {
            this.stop();
        }
    }

    boolean isEnabled() {
        return this.isEnabled;
    }

    void stop() {
        this.isStopped = true;
        if (this.activeScene != null) {
            this.activeScene.stop();
        }
        this.cpuBlocks.clear();
        this.clearScene.clear();
        this.rowRenderedView.clear();
        this.cfStartPosition.clear();
    }

    void pause() {
        this.isPaused = true;
        if (this.activeScene != null) {
            this.activeScene.pause();
        }
    }

    void resume() {
        this.isPaused = false;
        this.isStopped = false;
        if (this.activeScene != null) {
            this.activeScene.resume();
        }
    }

    boolean isPaused() {
        return this.isPaused;
    }

    private class ClearWorker
    extends SceneWorker {
        private ClearWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(Animator.this.stageSteps(Stage.HOLD) * 16);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Overlay o = new Overlay();
            this.setClip(o);
            BlockList blockList = Animator.this.cpuBlocks;
            synchronized (blockList) {
                for (Block b : Animator.this.cpuBlocks) {
                    Sequence s = new Sequence();
                    s.add(new FadeOut(b, Animator.this.stageSteps(Stage.FADE_OUT)));
                    s.add(new Clear(b));
                    o.add(s);
                }
            }
            o.add(Animator.this.clearScene);
        }

        public void render() {
            super.render();
            Animator.this.clearScene.clear();
            Animator.this.cpuBlocks.clear();
            Animator.this.cpuPos = new Point(CPU_BLOCK_START);
            Animator.this.rowRenderedView.clear();
            Animator.this.cfStartPosition.clear();
        }

        public void stop() {
            this.resume();
            super.stop();
        }
    }

    private class DataFlowWorker
    extends SceneWorker {
        private final Target target;
        private final Type type;
        private final View view;
        private final int labelCol;
        private final int row;
        private final int col;
        private final int count;

        DataFlowWorker(Target aTarget, Type aType, View aView, int aLabelCol, int aRow, int aCol, int aCount) {
            this.target = aTarget;
            this.type = aType;
            this.view = aView;
            this.labelCol = aLabelCol;
            this.row = aRow;
            this.col = aCol;
            this.count = aCount;
        }

        public void run() {
            Rectangle visibleRect = this.view.getVisibleRect();
            if (visibleRect.contains(this.view.getCellRect(this.row, this.col, false))) {
                switch (this.target) {
                    case MEMORY: 
                    case REGISTER: {
                        String name;
                        int value;
                        int address;
                        int i;
                        boolean skip = false;
                        if (this.target == Target.MEMORY) {
                            View renderedView = (View)Animator.this.rowRenderedView.get(this.row);
                            if (renderedView == null) {
                                Animator.this.rowRenderedView.put(this.row, this.view);
                            } else if (renderedView != null) {
                                skip = true;
                            }
                        }
                        if (skip) break;
                        Rectangle vRect = this.view.getCellRect(this.row, this.col, false);
                        Rectangle aRect = null;
                        for (i = 1; i < this.count; ++i) {
                            vRect = vRect.union(this.view.getCellRect(this.row, this.col + i, true));
                        }
                        vRect = Animator.this.convertRectangle(this.view, vRect);
                        switch (this.target) {
                            case REGISTER: {
                                address = this.row;
                                value = (Integer)this.view.getModel().getValueAt(this.row, this.col);
                                name = String.format("%s: 0x%x", (String)this.view.getModel().getValueAt(this.row, this.labelCol), value);
                                break;
                            }
                            case MEMORY: {
                                address = (Integer)this.view.getModel().getValueAt(this.row, this.labelCol);
                                value = 0;
                                for (i = 0; i < this.count; ++i) {
                                    value = value << 8 | (Byte)this.view.getModel().getValueAt(this.row, this.col + i);
                                }
                                value = Animator.this.memory.normalizeEndianness(value, this.count);
                                name = String.format("mem: 0x%x", value);
                                aRect = Animator.this.convertRectangle(this.view, this.view.getCellRect(this.row, this.labelCol, false));
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        this.setClip(new DataFlowScene(this.target, this.type, address, aRect, value, vRect, name));
                    }
                }
            }
        }
    }

    private class ControlFlowWorker
    extends SceneWorker {
        private ControlFlowWorker() {
        }

        public void run() {
            Overlay ol = new Overlay(){

                public void render() {
                    for (JComponent c : Animator.this.paintFirst) {
                        Container parent = c.getParent();
                        if (!(parent instanceof JComponent)) continue;
                        JComponent jParent = (JComponent)parent;
                        jParent.paintImmediately(c.getBounds());
                    }
                    super.render();
                }
            };
            for (JComponent context : Animator.this.cfStartPosition.keySet()) {
                Position from = (Position)Animator.this.cfStartPosition.get(context);
                Position to = (Position)Animator.this.cfPosition.get(context);
                if (from == null || to == null) continue;
                ol.add(new ControlFlowScene(context, from, to));
            }
            this.setClip(ol);
        }
    }

    private class ControlFlowScene
    extends Sequence {
        static final int COLUMN = 1;

        ControlFlowScene(JComponent context, Position from, Position to) {
            Rectangle fromRec = from.view.getCellRect(from.row, 1, false);
            Rectangle toRec = to.view.getCellRect(to.row, 1, false);
            Point fromPoint = Animator.this.convertPoint(from.view, new Point(fromRec.x + 6, fromRec.y + 7 - 3));
            Point toPoint = Animator.this.convertPoint(to.view, new Point(toRec.x + 6, toRec.y + 7 - 3));
            Rectangle drawArea = Animator.this.convertRectangle(context, context.getVisibleRect());
            if (Math.abs(fromPoint.y - toPoint.y) >= 7) {
                StaggeredPath path = new StaggeredPath(fromPoint, toPoint, 7, 11, true, CONTROL_FLOW_COLOR, Animator.this.stageSteps(Stage.CONTROL_FLOW_LINE), Animator.this.stageSteps(Stage.FADE_OUT), drawArea);
                this.add(path);
                Animator.this.clearScene.add(path.getClearClip());
            }
        }
    }

    private class DataFlowScene
    extends Sequence {
        Block tvb;
        Block tab;
        Block cvb;
        Block cab;

        DataFlowScene(Target target, Type type, int address, Rectangle aRect, int value, Rectangle vRect, String label) {
            Color tc;
            this.tvb = null;
            this.tab = null;
            this.cvb = null;
            this.cab = null;
            switch (type) {
                case TARGET_TO_CPU: {
                    tc = READ_TARGET_COLOR;
                    break;
                }
                case CPU_TO_TARGET: {
                    tc = WRITE_TARGET_COLOR;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.tvb = new Block(vRect, tc);
            switch (target) {
                case MEMORY: {
                    this.tab = new Block(aRect, ADDRESS_BLOCK_COLOR);
                    break;
                }
                default: {
                    this.tab = null;
                }
            }
            switch (target) {
                case MEMORY: {
                    this.cab = Animator.this.cpuBlocks.findLast(address);
                    if (this.cab != null) break;
                    this.cab = this.newCpuBlock(String.format("0x%x", address), address);
                    break;
                }
                default: {
                    this.cab = null;
                }
            }
            switch (type) {
                case CPU_TO_TARGET: {
                    this.cvb = Animator.this.cpuBlocks.findLast(value);
                    if (this.cvb != null) break;
                    this.cvb = this.newCpuBlock(String.format("0x%x", value), value);
                    break;
                }
                case TARGET_TO_CPU: {
                    this.cvb = this.newCpuBlock(label, value);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            switch (type) {
                case TARGET_TO_CPU: {
                    this.createMoveClip(type, this.tvb, this.cab, this.cvb, this.tab);
                    break;
                }
                case CPU_TO_TARGET: {
                    this.createMoveClip(type, this.cvb, this.cab, this.tvb, this.tab);
                }
            }
        }

        private Block newCpuBlock(String label, int value) {
            Point cp = Animator.this.convertPoint(Animator.this.cpu, Animator.this.cpuPos);
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(cp.x, cp.y, 116.0, 21.0, 12.0, 12.0);
            ((Animator)Animator.this).cpuPos.x += 120;
            Block block = new Block(rect, CPU_COLOR, label, CPU_LABEL_COLOR, value);
            Animator.this.cpuBlocks.add(block);
            return block;
        }

        private void createMoveClip(Type type, Block fv, Block fa, Block tv, Block ta) {
            Sequence s;
            Overlay fadeIn = new Overlay();
            if (type == Type.CPU_TO_TARGET && fv.visible == null) {
                fadeIn.add(new FadeIn(fv, Animator.this.stageSteps(Stage.FADE_IN)));
            }
            if (fa != null && fa.visible == null) {
                fadeIn.add(new FadeIn(fa, Animator.this.stageSteps(Stage.FADE_IN)));
            }
            if (fadeIn.size() > 0) {
                this.add(fadeIn);
            }
            Transmute moveV = new Transmute(fv, tv, Animator.this.stageSteps(Stage.ACTION));
            if (fa == null && ta == null) {
                this.add(moveV);
            } else {
                Transmute moveA = new Transmute(fa != null ? fa : fv, ta != null ? ta : tv, Animator.this.stageSteps(Stage.ACTION));
                switch (type) {
                    case TARGET_TO_CPU: {
                        s = new Sequence();
                        s.add(moveA);
                        s.add(moveV);
                        this.add(s);
                        break;
                    }
                    case CPU_TO_TARGET: {
                        Overlay o = new Overlay();
                        o.add(moveA);
                        o.add(moveV);
                        this.add(o);
                    }
                }
            }
            Overlay fadeOut = new Overlay();
            if (!Animator.this.cpuBlocks.contains(tv)) {
                s = new Sequence();
                s.add(new FadeOut(tv, Animator.this.stageSteps(Stage.FADE_OUT)));
                s.add(new Clear(tv));
                fadeOut.add(s);
            }
            if (ta != null && !Animator.this.cpuBlocks.contains(ta)) {
                s = new Sequence();
                s.add(new FadeOut(ta, Animator.this.stageSteps(Stage.FADE_OUT)));
                s.add(new Clear(ta));
                fadeOut.add(s);
            }
            this.add(fadeOut);
        }

        public void render() {
            for (JComponent c : Animator.this.paintFirst) {
                Container parent = c.getParent();
                if (!(parent instanceof JComponent)) continue;
                JComponent jParent = (JComponent)parent;
                jParent.paintImmediately(c.getBounds());
            }
            super.render();
        }

        public void stop() {
            super.stop();
            this.tvb.clear();
            if (this.tab != null) {
                this.tab.clear();
            }
        }
    }

    private class ALabel
    extends AShape {
        private final StringGradient label;
        private final Font font;
        private final ColorGradient labelColor;
        private GlyphVector glyphVector;
        private Rectangle2D glyphBounds;

        ALabel(AComponent aComponent, ShapeGradient aShape, ColorGradient aColor, StringGradient aLabel, ColorGradient aLabelColor, Font aFont) {
            super(aComponent, aShape, aColor, aLabelColor.getSteps());
            this.glyphVector = null;
            this.glyphBounds = null;
            this.label = aLabel;
            this.labelColor = aLabelColor;
            this.font = aFont;
        }

        void setStep(int step) {
            this.label.setStep(step);
            this.labelColor.setStep(step);
            super.setStep(step);
        }

        public void paintComponent(Graphics2D g) {
            super.paintComponent(g);
            g.setColor(this.labelColor.colorValue());
            g.setFont(this.font);
            if (this.glyphVector == null || this.label.isValueChanged()) {
                this.glyphVector = this.font.createGlyphVector(g.getFontRenderContext(), this.label.stringValue());
                this.glyphBounds = this.glyphVector.getVisualBounds();
            }
            g.drawGlyphVector(this.glyphVector, (int)Math.round(this.shape.getX() + this.shape.getWidth() / 2.0 - this.glyphBounds.getWidth() / 2.0 - this.glyphBounds.getX()), (int)Math.round(this.shape.getY() + this.shape.getHeight() / 2.0 - this.glyphBounds.getHeight() / 2.0 - this.glyphBounds.getY()));
        }
    }

    private class AShape
    extends Clip
    implements APainter {
        private AComponent component;
        final ShapeGradient shape;
        private final ColorGradient color;
        private final int steps;
        private int curStep;
        private final Rectangle2D.Double bounds;

        AShape(AComponent aComponent, ShapeGradient aShape, ColorGradient aColor, int minSteps) {
            this.curStep = 0;
            this.bounds = new Rectangle2D.Double();
            this.component = aComponent;
            this.shape = aShape;
            this.color = aColor;
            this.steps = Math.max(minSteps, Math.max(this.shape.getSteps(), this.color.getSteps()));
        }

        AShape(AComponent aComponent, ShapeGradient aShape, ColorGradient aColor) {
            this(aComponent, aShape, aColor, 0);
        }

        void setStep(int step) {
            this.shape.setStep(this.curStep);
            this.color.setStep(this.curStep);
            if (this.component != null) {
                if (step == 0) {
                    this.component.setPainter(this);
                }
                this.component.paintImmediately(this.shape.getBoundsList());
            }
        }

        AComponent getComponent() {
            return this.component;
        }

        public void clear() {
            super.clear();
            if (this.component != null) {
                this.component.setPainter(null);
                this.component.paintImmediately(this.shape.getBounds());
                this.component = null;
            }
        }

        public void stop() {
            super.stop();
            this.clear();
        }

        public void paintComponent(Graphics2D g) {
            g.translate(-this.component.getX(), -this.component.getY());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.color.colorValue());
            g.clip(this.shape.getBounds2D(this.bounds));
            g.fill(this.shape);
        }

        boolean renderNextFrame() {
            if (this.curStep <= this.steps) {
                this.setStep(this.curStep);
                ++this.curStep;
            }
            return this.curStep <= this.steps;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AComponent {
        private JComponent canvas;
        private APainter painter = null;
        private final Rectangle clipRect;
        private final Rectangle clip = new Rectangle();

        AComponent(final int layerOffset, Shape drawingArea) {
            this.clipRect = drawingArea != null ? drawingArea.getBounds() : null;
            this.canvas = new JComponent(){
                {
                    Animator.this.frame.getLayeredPane().add((Component)this, new Integer(JLayeredPane.MODAL_LAYER + layerOffset));
                }

                public void paintComponent(Graphics g) {
                    if (AComponent.this.painter != null) {
                        Graphics2D g2d = (Graphics2D)g;
                        if (AComponent.this.clipRect != null) {
                            AComponent.this.clip.setBounds(((AComponent)AComponent.this).clipRect.x - AComponent.this.canvas.getX(), ((AComponent)AComponent.this).clipRect.y - AComponent.this.canvas.getY(), ((AComponent)AComponent.this).clipRect.width, ((AComponent)AComponent.this).clipRect.height);
                            g2d.clip(AComponent.this.clip);
                        }
                        AComponent.this.painter.paintComponent(g2d);
                    }
                }
            };
        }

        AComponent(int layerOffset) {
            this(layerOffset, null);
        }

        AComponent() {
            this(0, null);
        }

        AComponent(Shape drawingArea) {
            this(0, drawingArea);
        }

        void setPainter(APainter aPainter) {
            this.painter = aPainter;
        }

        void paintImmediately(Rectangle r) {
            if (this.canvas != null) {
                this.canvas.setBounds(r);
                this.canvas.paintImmediately(r.x - this.canvas.getX(), r.y - this.canvas.getY(), r.width, r.height);
            }
        }

        void paintImmediately(List<Rectangle2D> bounds) {
            int tlx = Integer.MAX_VALUE;
            int tly = Integer.MAX_VALUE;
            int brx = Integer.MIN_VALUE;
            int bry = Integer.MIN_VALUE;
            for (Rectangle2D r : bounds) {
                int rtlx = (int)Math.round(r.getX());
                int rtly = (int)Math.round(r.getY());
                int rbrx = rtlx + (int)Math.round(r.getWidth());
                int rbry = rtly + (int)Math.round(r.getHeight());
                tlx = Math.min(tlx, rtlx);
                tly = Math.min(tly, rtly);
                brx = Math.max(brx, rbrx);
                bry = Math.max(bry, rbry);
            }
            this.canvas.setBounds(tlx, tly, brx - tlx, bry - tly);
            for (Rectangle2D r : bounds) {
                this.canvas.paintImmediately((int)Math.round(r.getX()) - this.canvas.getX(), (int)Math.round(r.getY()) - this.canvas.getY(), (int)Math.round(r.getWidth()), (int)Math.round(r.getHeight()));
            }
        }

        int getX() {
            return this.canvas.getX();
        }

        int getY() {
            return this.canvas.getY();
        }

        void clear(Rectangle2D bounds) {
            this.clear();
            Animator.this.frame.getLayeredPane().paintImmediately((int)Math.round(bounds.getX()), (int)Math.round(bounds.getY()), (int)Math.round(bounds.getWidth()), (int)Math.round(bounds.getHeight()));
        }

        void clear() {
            if (this.canvas != null) {
                Animator.this.frame.getLayeredPane().remove(this.canvas);
                this.canvas = null;
            }
        }
    }

    private static interface APainter {
        public void paintComponent(Graphics2D var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RoundRectangleGradient
    extends RoundRectangle2D.Double
    implements ShapeGradient {
        private final RoundRectangle2D.Double from;
        private final RoundRectangle2D.Double to;
        private final RoundRectangle2D.Double delta;
        private final int steps;
        private int curStep = 0;
        private final Rectangle2D unionBounds = new Rectangle2D.Double();
        private final Rectangle2D prevBounds;
        private final Rectangle2D curBounds;
        private final ArrayList<Rectangle2D> boundsDeltaList1 = new ArrayList();
        private final ArrayList<Rectangle2D> boundsDeltaList2 = new ArrayList();

        RoundRectangleGradient(RoundRectangle2D.Double aFrom, RoundRectangle2D.Double aTo, int aSteps) {
            super(aFrom.x, aFrom.y, aFrom.width, aFrom.height, aFrom.arcwidth, aFrom.archeight);
            assert (aSteps > 0);
            this.steps = aSteps;
            this.from = aFrom;
            this.to = aTo;
            this.delta = new RoundRectangle2D.Double((this.to.x - this.from.x) / (double)this.steps, (this.to.y - this.from.y) / (double)this.steps, (this.to.width - this.from.width) / (double)this.steps, (this.to.height - this.from.height) / (double)this.steps, (this.to.arcwidth - this.from.arcwidth) / (double)this.steps, (this.to.archeight - this.from.archeight) / (double)this.steps);
            this.prevBounds = this.getBounds2D();
            this.curBounds = this.getBounds2D();
            this.boundsDeltaList1.add(this.unionBounds);
            this.boundsDeltaList2.add(this.prevBounds);
            this.boundsDeltaList2.add(this.curBounds);
        }

        RoundRectangleGradient(RoundRectangle2D.Double to) {
            this(to, to, 1);
        }

        @Override
        public int getSteps() {
            return this.steps;
        }

        @Override
        public void setStep(int step) {
            if (step > this.steps) {
                step = this.steps;
            }
            if (step == this.steps) {
                this.setRoundRect(this.to.x, this.to.y, this.to.width, this.to.height, this.to.arcwidth, this.to.archeight);
            } else if (step != this.curStep) {
                this.setRoundRect(this.from.x + this.delta.x * (double)step, this.from.y + this.delta.y * (double)step, this.from.width + this.delta.width * (double)step, this.from.height + this.delta.height * (double)step, this.from.arcwidth + this.delta.arcwidth * (double)step, this.from.archeight + this.delta.archeight * (double)step);
            }
            this.curStep = step;
            this.prevBounds.setRect(this.curBounds);
            this.curBounds.setRect(this.x - 1.0, this.y - 1.0, this.width + 2.0, this.height + 2.0);
        }

        @Override
        public List<Rectangle2D> getBoundsList() {
            if (this.curBounds.intersects(this.prevBounds)) {
                this.unionBounds.setRect(this.prevBounds);
                this.unionBounds.add(this.curBounds);
                return this.boundsDeltaList1;
            }
            return this.boundsDeltaList2;
        }

        @Override
        public ShapeGradient createFinal() {
            return new RoundRectangleGradient(this.to);
        }

        @Override
        public Rectangle2D.Double getBounds2D(Rectangle2D.Double rect) {
            rect.x = this.x;
            rect.y = this.y;
            rect.width = this.width;
            rect.height = this.height;
            return rect;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RectangleGradient
    extends Rectangle2D.Double
    implements ShapeGradient {
        private final Rectangle2D.Double from;
        private final Rectangle2D.Double to;
        private final Rectangle2D.Double delta;
        private final int steps;
        private int curStep = 0;
        private final Rectangle2D unionBounds = new Rectangle2D.Double();
        private final Rectangle2D prevBounds;
        private final Rectangle2D curBounds;
        private final ArrayList<Rectangle2D> boundsDeltaList1 = new ArrayList();
        private final ArrayList<Rectangle2D> boundsDeltaList2 = new ArrayList();

        RectangleGradient(Rectangle2D.Double aFrom, Rectangle2D.Double aTo, int aSteps) {
            super(aFrom.x, aFrom.y, aFrom.width, aFrom.height);
            assert (aSteps > 0);
            this.steps = aSteps;
            this.from = aFrom;
            this.to = aTo;
            this.delta = new Rectangle2D.Double((this.to.x - this.from.x) / (double)this.steps, (this.to.y - this.from.y) / (double)this.steps, (this.to.width - this.from.width) / (double)this.steps, (this.to.height - this.from.height) / (double)this.steps);
            this.prevBounds = this.getBounds2D();
            this.curBounds = this.getBounds2D();
            this.boundsDeltaList1.add(this.unionBounds);
            this.boundsDeltaList2.add(this.prevBounds);
            this.boundsDeltaList2.add(this.curBounds);
        }

        RectangleGradient(Rectangle2D.Double to) {
            this(to, to, 1);
        }

        static RectangleGradient createStretch(Point2D.Double from, Point2D.Double to, int width, int steps) {
            double enHeight;
            double stHeight;
            double enWidth;
            double stWidth;
            double deltaX = to.x - from.x;
            double deltaY = to.y - from.y;
            assert (deltaX == 0.0 || deltaY == 0.0);
            if (deltaX == 0.0) {
                if (deltaY > 0.0) {
                    to.x = from.x;
                    to.y = from.y;
                }
                stWidth = width;
                enWidth = width;
                stHeight = 0.0;
                enHeight = Math.abs(deltaY);
            } else {
                if (deltaX > 0.0) {
                    to.x = from.x;
                    to.y = from.y;
                }
                stWidth = 0.0;
                enWidth = Math.abs(deltaX);
                stHeight = width;
                enHeight = width;
            }
            Rectangle2D.Double st = new Rectangle2D.Double(from.x, from.y, stWidth, stHeight);
            Rectangle2D.Double en = new Rectangle2D.Double(to.x, to.y, enWidth, enHeight);
            return new RectangleGradient(st, en, steps);
        }

        @Override
        public int getSteps() {
            return this.steps;
        }

        @Override
        public void setStep(int step) {
            if (step > this.steps) {
                step = this.steps;
            }
            if (step == this.steps) {
                this.setRect(this.to.x, this.to.y, this.to.width, this.to.height);
            } else if (step != this.curStep) {
                this.setRect(this.from.x + this.delta.x * (double)step, this.from.y + this.delta.y * (double)step, this.from.width + this.delta.width * (double)step, this.from.height + this.delta.height * (double)step);
            }
            this.curStep = step;
            this.prevBounds.setRect(this.curBounds);
            this.curBounds.setRect(this.x - 1.0, this.y - 1.0, this.width + 2.0, this.height + 2.0);
        }

        @Override
        public List<Rectangle2D> getBoundsList() {
            if (this.curBounds.intersects(this.prevBounds)) {
                this.unionBounds.setRect(this.prevBounds);
                this.unionBounds.add(this.curBounds);
                return this.boundsDeltaList1;
            }
            return this.boundsDeltaList2;
        }

        @Override
        public ShapeGradient createFinal() {
            return new RectangleGradient(this.to);
        }

        @Override
        public Rectangle2D.Double getBounds2D(Rectangle2D.Double rect) {
            rect.x = this.x;
            rect.y = this.y;
            rect.width = this.width;
            rect.height = this.height;
            return rect;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PolygonGradient
    extends Polygon
    implements ShapeGradient {
        private final Polygon from;
        private final Polygon to;
        private final Point2D.Double[] delta;
        private final int steps;
        private final Rectangle2D.Double bounds = new Rectangle2D.Double();
        private final List<Rectangle2D> boundsList = new ArrayList<Rectangle2D>();

        PolygonGradient(Polygon aFrom, Polygon aTo, int aSteps) {
            super(aFrom.xpoints, aFrom.ypoints, aFrom.npoints);
            this.boundsList.add(this.bounds);
            this.from = aFrom;
            this.to = aTo;
            this.steps = aSteps;
            assert (this.from.npoints == this.to.npoints);
            this.delta = new Point2D.Double[this.npoints];
            for (int i = 0; i < this.npoints; ++i) {
                this.delta[i] = new Point2D.Double(((double)this.to.xpoints[i] - (double)this.from.xpoints[i]) / (double)this.steps, ((double)this.to.ypoints[i] - (double)this.from.ypoints[i]) / (double)this.steps);
            }
            this.resetBounds();
        }

        PolygonGradient(Polygon p) {
            this(p, p, 1);
        }

        private void resetBounds() {
            Rectangle2D b = this.getBounds2D();
            this.bounds.setRect(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        }

        @Override
        public int getSteps() {
            return this.steps;
        }

        @Override
        public void setStep(int step) {
            if (step > this.steps) {
                step = this.steps;
            }
            this.reset();
            for (int i = 0; i < this.from.npoints; ++i) {
                this.addPoint((int)Math.round((double)this.from.xpoints[i] + this.delta[i].x * (double)step), (int)Math.round((double)this.from.ypoints[i] + this.delta[i].y * (double)step));
            }
            this.resetBounds();
        }

        @Override
        public List<Rectangle2D> getBoundsList() {
            return this.boundsList;
        }

        @Override
        public ShapeGradient createFinal() {
            return new PolygonGradient(this.to);
        }

        @Override
        public Rectangle2D.Double getBounds2D(Rectangle2D.Double rect) {
            return this.bounds;
        }

        @Override
        public double getX() {
            return this.bounds.x;
        }

        @Override
        public double getY() {
            return this.bounds.y;
        }

        @Override
        public double getWidth() {
            return this.bounds.width;
        }

        @Override
        public double getHeight() {
            return this.bounds.height;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArcGradient
    extends Arc2D.Double
    implements ShapeGradient {
        private double extentDelta;
        private final int type;
        private final int steps;
        private int curStep = 0;
        private final Rectangle2D boundsDelta;
        private final ArrayList<Rectangle2D> boundsDeltaList = new ArrayList();

        ArcGradient(double x, double y, double w, double h, double start, double extent, int aType, int aSteps) {
            super(x, y, w, h, start, extent, aType);
            assert (aSteps > 0);
            this.type = aType;
            this.steps = aSteps;
            this.extentDelta = extent / (double)this.steps;
            this.boundsDelta = this.getBounds2D();
            this.boundsDeltaList.add(this.boundsDelta);
            this.setAngleExtent(0.0);
        }

        ArcGradient(double x, double y, double w, double h, double start, double extent, int type) {
            this(x, y, w, h, start, extent, type, 1);
        }

        @Override
        public int getSteps() {
            return this.steps;
        }

        @Override
        public void setStep(int step) {
            if (step > this.steps) {
                step = this.steps;
            }
            if (step == this.curStep + 1) {
                this.setAngleExtent(this.getAngleExtent() + this.extentDelta);
            } else if (step != this.curStep) {
                this.setAngleExtent(this.extentDelta * (double)step);
            }
            this.curStep = step;
        }

        @Override
        public List<Rectangle2D> getBoundsList() {
            return this.boundsDeltaList;
        }

        @Override
        public ShapeGradient createFinal() {
            return new ArcGradient(this.x, this.y, this.width, this.height, this.start, this.extentDelta * (double)this.steps, this.type);
        }

        @Override
        public Rectangle2D.Double getBounds2D(Rectangle2D.Double rect) {
            rect.x = this.x;
            rect.y = this.y;
            rect.width = this.width;
            rect.height = this.height;
            return rect;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ShapeGradient
    extends Shape {
        public List<Rectangle2D> getBoundsList();

        public double getX();

        public double getY();

        public double getWidth();

        public double getHeight();

        public void setStep(int var1);

        public int getSteps();

        public ShapeGradient createFinal();

        public Rectangle2D.Double getBounds2D(Rectangle2D.Double var1);
    }

    private static class StringGradient {
        private final String from;
        private final String to;
        private final int steps;
        private int curStep = 0;

        StringGradient(String aFrom, String aTo, int aSteps) {
            this.from = aFrom;
            this.to = aTo;
            this.steps = aSteps;
        }

        void setStep(int step) {
            if (step > this.steps) {
                step = this.steps;
            }
            this.curStep = step;
        }

        int getSteps() {
            return this.steps;
        }

        String stringValue() {
            if (this.curStep < this.steps >> 2) {
                return this.from != null ? this.from : (this.to != null ? this.to : "");
            }
            return this.to != null ? this.to : (this.from != null ? this.from : "");
        }

        boolean isValueChanged() {
            return this.curStep == this.steps >> 2;
        }
    }

    private static class ColorGradient {
        private final Color from;
        private final double deltaRed;
        private final double deltaGreen;
        private final double deltaBlue;
        private final double deltaAlpha;
        private final int steps;
        private double red;
        private double green;
        private double blue;
        private double alpha;
        private Color color;
        private int curStep = 0;

        ColorGradient(Color aFrom, Color to, int aSteps) {
            assert (aSteps > 0);
            this.steps = aSteps;
            this.from = aFrom;
            this.red = this.from.getRed();
            this.green = this.from.getGreen();
            this.blue = this.from.getBlue();
            this.alpha = this.from.getAlpha();
            this.deltaRed = ((double)to.getRed() - this.red) / (double)this.steps;
            this.deltaGreen = ((double)to.getGreen() - this.green) / (double)this.steps;
            this.deltaBlue = ((double)to.getBlue() - this.blue) / (double)this.steps;
            this.deltaAlpha = ((double)to.getAlpha() - this.alpha) / (double)this.steps;
        }

        ColorGradient(Color aColor) {
            this(aColor, aColor, 1);
        }

        void setStep(int step) {
            if (step > this.steps) {
                step = this.steps;
            }
            if (step == this.curStep + 1) {
                this.red += this.deltaRed;
                this.green += this.deltaGreen;
                this.blue += this.deltaBlue;
                this.alpha += this.deltaAlpha;
            } else if (step != this.curStep) {
                this.red = (double)this.from.getRed() + this.deltaRed * (double)step;
                this.green = (double)this.from.getGreen() + this.deltaGreen * (double)step;
                this.blue = (double)this.from.getBlue() + this.deltaBlue * (double)step;
                this.alpha = (double)this.from.getAlpha() + this.deltaAlpha * (double)step;
            }
            this.curStep = step;
            this.color = new Color((int)(this.red + 0.5), (int)(this.green + 0.5), (int)(this.blue + 0.5), (int)(this.alpha + 0.5));
        }

        int getSteps() {
            return this.steps;
        }

        Color colorValue() {
            return this.color;
        }
    }

    private class DrawingClip
    extends AShape {
        ShapeGradient clearShape;
        ColorGradient clearColor;

        DrawingClip(ShapeGradient aShape, ColorGradient aColor, ColorGradient aClearColor, Shape drawingArea) {
            super(new AComponent(-1, drawingArea), aShape, aColor);
            this.clearShape = this.shape.createFinal();
            this.clearColor = aClearColor;
        }

        DrawingClip(ShapeGradient aShape, ColorGradient aColor, ColorGradient aClearColor) {
            this(aShape, aColor, aClearColor, null);
        }

        public Clip getClearClip() {
            return new AShape(this.getComponent(), this.clearShape, this.clearColor){

                public void clear() {
                    super.clear();
                    DrawingClip.this.clear();
                }

                public void setStep(int step) {
                    super.setStep(step);
                    if (step == DrawingClip.this.clearColor.getSteps()) {
                        this.clear();
                    }
                }
            };
        }

        public void clear() {
            AComponent component = this.getComponent();
            super.clear();
            if (component != null) {
                component.clear();
            }
        }
    }

    private class StaggeredPath
    extends Sequence {
        StaggeredPath(Point from, Point to, int width, int stagger, boolean isArrow, Color color, int steps, int clearSteps, Shape drawingArea) {
            Point c0 = new Point(to.x - stagger, from.y);
            Point c1 = new Point(c0.x - width, c0.y + (to.y > from.y ? width : 0));
            Point c2 = new Point(c1.x, to.y + (to.y < from.y ? width : 0));
            Point c3 = new Point(c2.x + width, to.y);
            Rectangle a0 = new Rectangle(c1.x, c1.y - width, width * 2, width * 2);
            Rectangle a1 = new Rectangle(c2.x, c2.y - width, width * 2, width * 2);
            int dist = Math.abs(to.y - from.y);
            int length = stagger * 2 + width * 2 + dist;
            this.add(new Line(from, c0, width, color, Math.max(1, steps * stagger / length), clearSteps, drawingArea));
            this.add(new Arc(a0, to.y < from.y ? 270 : 90, to.y < from.y ? -90 : 90, color, Math.max(1, steps * width / length), clearSteps, drawingArea));
            this.add(new Line(c1, c2, width, color, Math.max(1, steps * dist / length), clearSteps, drawingArea));
            this.add(new Arc(a1, 180, to.y < from.y ? -90 : 90, color, Math.max(1, steps * width / length), clearSteps, drawingArea));
            if (isArrow) {
                Point c4 = new Point(to.x - 9, to.y);
                this.add(new Line(c3, c4, width, color, Math.max(1, steps * (stagger - 9) / length), clearSteps, drawingArea));
                int h0 = width / 2;
                int h1 = (21 - width) / 2;
                int y0 = c4.y - h1;
                int y1 = to.y + h0;
                int y2 = c4.y + width + h1;
                Polygon p0 = new Polygon(new int[]{c4.x, c4.x, c4.x, c4.x}, new int[]{y0, y0, y2, y2}, 4);
                Polygon p1 = new Polygon(new int[]{c4.x, to.x, to.x, c4.x}, new int[]{y0, y1, y1, y2}, 4);
                this.add(new Arrow(p0, p1, color, Math.max(1, steps * 9 / length), clearSteps, drawingArea));
            } else {
                this.add(new Line(c3, to, width, color, Math.max(1, steps * stagger / length), clearSteps, drawingArea));
            }
        }
    }

    private class Arc
    extends DrawingClip {
        Arc(Rectangle startRect, int startAngle, int arcAngle, Color color, int steps, int clearSteps, Shape drawingArea) {
            super(new ArcGradient(startRect.x, startRect.y, startRect.width, startRect.height, startAngle, arcAngle, 2, steps), new ColorGradient(color), new ColorGradient(color, new Color(color.getRed(), color.getGreen(), color.getBlue(), 0), clearSteps), drawingArea);
        }

        Arc(Rectangle startRect, int startAngle, int arcAngle, Color color, int steps, int clearSteps) {
            this(startRect, startAngle, arcAngle, color, steps, clearSteps, null);
        }
    }

    private class Line
    extends DrawingClip {
        Line(Point from, Point to, int width, Color color, int steps, int clearSteps, Shape drawingArea) {
            super(RectangleGradient.createStretch(new Point2D.Double(from.x, from.y), new Point2D.Double(to.x, to.y), width, steps), new ColorGradient(color), new ColorGradient(color, new Color(color.getRed(), color.getGreen(), color.getBlue(), 0), clearSteps), drawingArea);
        }

        Line(Point from, Point to, int width, Color color, int steps, int clearSteps) {
            this(from, to, width, color, steps, clearSteps, null);
        }
    }

    private class Arrow
    extends DrawingClip {
        Arrow(Polygon from, Polygon to, Color color, int steps, int clearSteps, Shape drawingArea) {
            super(new PolygonGradient(from, to, steps), new ColorGradient(color), new ColorGradient(color, new Color(color.getRed(), color.getGreen(), color.getBlue(), 0), clearSteps), drawingArea);
        }

        Arrow(Polygon from, Polygon to, Color color, int steps, int clearSteps) {
            this(from, to, color, steps, clearSteps, null);
        }
    }

    private class Clear
    extends Clip {
        Block block;

        Clear(Block aBlock) {
            this.block = aBlock;
        }

        boolean renderNextFrame() {
            this.block.clear();
            return false;
        }
    }

    private class Transmute
    extends ALabel {
        Transmute(Block from, Block to, int steps) {
            super(to.visible != null ? to.visible : new AComponent(), new RoundRectangleGradient(from.rect, to.rect, steps), new ColorGradient(from.color, to.color, steps), new StringGradient(from.label, to.label, steps), new ColorGradient(from.labelColor, to.labelColor, steps), Animator.this.font);
            to.visible = this.getComponent();
        }
    }

    private class FadeOut
    extends Transmute {
        FadeOut(Block block, int steps) {
            super(block, new Block(block, new Color(block.color.getRed(), block.color.getGreen(), block.color.getBlue(), 0), new Color(block.labelColor.getRed(), block.labelColor.getGreen(), block.labelColor.getBlue(), 0)), steps);
        }
    }

    private class FadeIn
    extends Transmute {
        FadeIn(Block block, int steps) {
            super(new Block(block, new Color(block.color.getRed(), block.color.getGreen(), block.color.getBlue(), 0), new Color(block.labelColor.getRed(), block.labelColor.getGreen(), block.labelColor.getBlue(), 0)), block, steps);
        }
    }

    private class Block {
        private final RoundRectangle2D.Double rect;
        private final Color color;
        private final String label;
        private final Color labelColor;
        private final int value;
        private AComponent visible = null;

        Block(RoundRectangle2D.Double aRect, Color aColor, String aLabel, Color aLabelColor, int aValue) {
            this.rect = aRect;
            this.color = aColor;
            this.label = aLabel;
            this.labelColor = aLabelColor;
            this.value = aValue;
        }

        Block(Rectangle aRect, Color aColor, String aLabel, Color aLabelColor, int aValue) {
            this(new RoundRectangle2D.Double(aRect.x, aRect.y, aRect.width, aRect.height, 12.0, 12.0), aColor, aLabel, aLabelColor, aValue);
        }

        Block(Rectangle aRect, Color aColor) {
            this(new RoundRectangle2D.Double(aRect.x, aRect.y, aRect.width, aRect.height, 12.0, 12.0), aColor, null, new Color(0, 0, 0, 0), 0);
        }

        Block(Block aBlock, Color aColor, Color aLabelColor) {
            this(aBlock.rect, aColor != null ? aColor : aBlock.color, aBlock.label, aLabelColor != null ? aLabelColor : aBlock.labelColor, aBlock.value);
            this.visible = aBlock.visible;
        }

        void clear() {
            if (this.visible != null) {
                this.visible.clear(this.rect.getBounds2D());
                this.visible = null;
            }
        }
    }

    private class Overlay
    extends Composite {
        private Overlay() {
        }

        synchronized boolean renderNextFrame() {
            boolean isMoreToRender = false;
            for (Clip clip : this.clips) {
                isMoreToRender |= clip.renderNextFrame();
            }
            return isMoreToRender;
        }
    }

    private class Sequence
    extends Composite {
        int nextClip;

        private Sequence() {
            this.nextClip = 0;
        }

        synchronized boolean renderNextFrame() {
            if (this.nextClip < this.clips.size() && !((Clip)this.clips.get(this.nextClip)).renderNextFrame()) {
                ++this.nextClip;
            }
            return this.nextClip < this.clips.size();
        }
    }

    private abstract class Composite
    extends Clip {
        ArrayList<Clip> clips;

        private Composite() {
            this.clips = new ArrayList();
        }

        synchronized void add(Clip aClip) {
            this.clips.add(aClip);
        }

        synchronized void remove(Clip aClip) {
            this.clips.remove(aClip);
        }

        synchronized int size() {
            return this.clips.size();
        }

        synchronized boolean isEmpty() {
            return this.clips.isEmpty();
        }

        public synchronized void clear() {
            super.clear();
            for (Clip clip : this.clips) {
                clip.clear();
            }
            this.clips.clear();
        }

        public synchronized void stop() {
            super.stop();
            for (Clip clip : this.clips) {
                clip.stop();
            }
        }

        public synchronized void pause() {
            super.pause();
            for (Clip clip : this.clips) {
                clip.pause();
            }
        }

        public synchronized void resume() {
            super.resume();
            for (Clip clip : this.clips) {
                clip.resume();
            }
        }

        public synchronized Clip getClearClip() {
            Overlay clearClips = new Overlay();
            if (super.getClearClip() != null) {
                clearClips.add(super.getClearClip());
            }
            for (Clip clip : this.clips) {
                Clip clearClip = clip.getClearClip();
                if (clearClip == null) continue;
                clearClips.add(clearClip);
            }
            return clearClips.size() > 0 ? clearClips : null;
        }
    }

    private abstract class Clip
    implements Scene {
        private Timer timer = null;
        private boolean isMoreToRender;
        private boolean isStopped = false;
        private boolean isPaused = false;

        private Clip() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render() {
            if (EventQueue.isDispatchThread()) {
                while (this.renderNextFrame()) {
                    try {
                        Thread.sleep(16L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                Clip clip = this;
                synchronized (clip) {
                    try {
                        if (!this.isStopped) {
                            this.isMoreToRender = true;
                            do {
                                System.gc();
                                this.timer = new Timer(16, new ActionListener(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void actionPerformed(ActionEvent e) {
                                        if (Clip.this.isPaused) {
                                            ((Timer)e.getSource()).stop();
                                        } else {
                                            Clip.this.isMoreToRender = Clip.this.renderNextFrame();
                                            if (!Clip.this.isMoreToRender) {
                                                ((Timer)e.getSource()).stop();
                                                Clip clip = Clip.this;
                                                synchronized (clip) {
                                                    Clip.this.notifyAll();
                                                }
                                            }
                                        }
                                    }
                                });
                                this.timer.start();
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (this.isMoreToRender && !this.isStopped);
                        }
                    }
                    finally {
                        this.timer = null;
                        this.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Clip clip = this;
            synchronized (clip) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                this.isStopped = true;
                this.isPaused = false;
                this.notifyAll();
                while (this.timer != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause() {
            Clip clip = this;
            synchronized (clip) {
                this.isPaused = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            Clip clip = this;
            synchronized (clip) {
                this.isPaused = false;
                this.notifyAll();
            }
        }

        public void clear() {
        }

        public Clip getClearClip() {
            return null;
        }

        abstract boolean renderNextFrame();
    }

    private abstract class SceneWorker
    implements Runnable,
    Scene {
        private Clip clip = null;

        private SceneWorker() {
        }

        public void render() {
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                try {
                    EventQueue.invokeAndWait(this);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof RuntimeException) {
                        throw (RuntimeException)e.getTargetException();
                    }
                    throw new AssertionError((Object)e.getTargetException());
                }
            }
            if (this.clip != null) {
                if (Animator.this.isPaused && !Animator.this.isStopped) {
                    this.clip.pause();
                }
                this.clip.render();
            }
        }

        void setClip(Clip aClip) {
            this.clip = aClip;
        }

        public void stop() {
            if (this.clip != null) {
                this.clip.stop();
            }
        }

        public void pause() {
            if (this.clip != null) {
                this.clip.pause();
            }
        }

        public void resume() {
            if (this.clip != null) {
                this.clip.resume();
            }
        }
    }

    private static interface Scene {
        public void render();

        public void stop();

        public void pause();

        public void resume();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stage {
        FADE_IN(0.2),
        ACTION(0.5),
        HOLD(0.1),
        FADE_OUT(0.3),
        CONTROL_FLOW_LINE(0.4);

        final double durationWeight;

        private Stage(double aDurationWeight) {
            this.durationWeight = aDurationWeight;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BlockList
    extends ArrayList<Block> {
        private BlockList() {
        }

        synchronized Block findLast(int value) {
            for (int i = this.size() - 1; i >= 0; --i) {
                Block block = (Block)this.get(i);
                if (block.value != value) continue;
                return block;
            }
            return null;
        }

        @Override
        public synchronized void clear() {
            for (Block b : this) {
                b.clear();
            }
            super.clear();
        }

        @Override
        public synchronized boolean add(Block b) {
            return super.add(b);
        }

        @Override
        public synchronized boolean contains(Object o) {
            return super.contains(o);
        }

        @Override
        public synchronized boolean isEmpty() {
            return super.isEmpty();
        }
    }

    private class Position {
        public final View view;
        public final Integer row;

        public Position(View aView, Integer aRow) {
            this.view = aView;
            this.row = aRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        CPU_TO_TARGET,
        TARGET_TO_CPU,
        CONTROL_FLOW;


        static Type valueOf(View.AccessListener.Type t) {
            switch (t) {
                case READ: {
                    return TARGET_TO_CPU;
                }
                case WRITE: {
                    return CPU_TO_TARGET;
                }
                case CURSOR_SET: {
                    return CONTROL_FLOW;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Target {
        REGISTER,
        MEMORY,
        INSTRUCTIONS;

    }
}

