/*
 * Decompiled with CFR 0.152.
 */
package ui;

import isa.AbstractISA;
import isa.Memory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import machine.AbstractCPU;
import machine.AbstractMainMemory;
import ui.Machine;
import util.DataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUI {
    protected static final String APPLICATION_NAME = "Simple Machine";
    protected static final String MANIFSET_VERSION = AbstractUI.class.getPackage().getImplementationVersion();
    protected static final String APPLICATION_VERSION = String.format("Version %s", MANIFSET_VERSION != null ? MANIFSET_VERSION : "not specified");
    protected static final String[] APPLICATION_COPYRIGHT = new String[]{"University of British Columbia", "Copyright \u00a9 2010, 2011 Mike Feeley.", "All rights reserved."};
    protected static final String APPLICATION_USAGE = "SimpleMachine -i [gui|cli] -a <arch> -v [student|solution]";
    protected static final String APPLICATION_ENV_PREFIX = "SIMPLE_MACHINE_";
    protected static final int MAIN_MEMORY_SIZE = 0x100000;
    protected static final String SOLUTION_VARIANT = "solution";
    private static Env<AppEnv> env = new Env<AppEnv>(AppEnv.class);
    protected static List<String> usageList = new ArrayList<String>();
    protected static List<Env> envList = new ArrayList<Env>();
    protected Machine machine;
    protected String applicationFullName;
    private static HashMap<String, Config> configs;

    static void showUsage() {
        System.out.print("Usage: ");
        for (String s : usageList) {
            System.out.printf("%s\n", s);
        }
    }

    static void showEnv() {
        System.out.print("Environment Variables:\n");
        for (Env e : envList) {
            for (String s : e.getNames()) {
                System.out.printf("\t%s\n", s);
            }
        }
    }

    protected static List<String> getArgList(List<String> args, String argSwitch, boolean isRequired, boolean isSwitchValueRequired, boolean isSwitchValueListAllowed, String valueIfSwitchMissing) throws ArgException {
        for (int i = 0; i < args.size(); ++i) {
            if (!args.get(i).equals(argSwitch)) continue;
            args.remove(i);
            ArrayList<String> al = new ArrayList<String>();
            while (args.size() > i && !args.get(i).startsWith("-")) {
                al.add(args.remove(i).toLowerCase());
                if (isSwitchValueListAllowed) continue;
            }
            if (al.size() == 0) {
                if (isSwitchValueRequired) {
                    throw new ArgException(String.format("Missing argument value for %s", argSwitch));
                }
                if (valueIfSwitchMissing != null) {
                    al.add(valueIfSwitchMissing.toLowerCase());
                } else {
                    al.add("");
                }
            }
            return al;
        }
        if (!isRequired || valueIfSwitchMissing != null) {
            if (valueIfSwitchMissing != null) {
                return Arrays.asList(valueIfSwitchMissing.toLowerCase());
            }
            return new ArrayList<String>();
        }
        throw new ArgException(String.format("Missing argument %s", argSwitch));
    }

    protected static String getArg(ArrayList<String> args, String argSwitch, boolean isRequired, boolean isSwitchValueRequired, String valueIfSwitchMissing) throws ArgException {
        List<String> argList = AbstractUI.getArgList(args, argSwitch, isRequired, isSwitchValueRequired, false, valueIfSwitchMissing);
        assert (argList.size() <= 1);
        if (argList.size() > 0) {
            return argList.get(0);
        }
        return null;
    }

    protected static Integer getArgInt(ArrayList<String> args, String argSwitch, boolean isRequired, boolean isSwitchValueRequired, String valueIfSwitchMissing) throws ArgException {
        String arg = AbstractUI.getArg(args, argSwitch, isRequired, isSwitchValueRequired, valueIfSwitchMissing);
        if (arg != null) {
            try {
                int radix;
                if (arg.substring(0, 2).toLowerCase().equals("0x")) {
                    arg = arg.substring(2, arg.length());
                    radix = 16;
                } else {
                    radix = 10;
                }
                return new Integer(Integer.parseInt(arg, radix));
            }
            catch (NumberFormatException e) {
                throw new ArgException("Command argument must be a number.");
            }
        }
        return null;
    }

    public static void main(String[] argsArray) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(argsArray));
        String errMessage = "";
        AbstractUI ui = null;
        try {
            String uiName = AbstractUI.getArg(args, "-i", true, true, env.valueOf(AppEnv.UI, "gui"));
            try {
                errMessage = String.format("UI %s not supported.", uiName);
                Class<?> uiClass = Class.forName("ui.".concat(uiName).concat(".UI"));
                Constructor<?> uiCtor = uiClass.getConstructor(ArrayList.class);
                ui = (AbstractUI)uiCtor.newInstance(args);
                ui.run();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ArgException(errMessage);
            }
            catch (NoSuchMethodException nsme) {
                throw new ArgException(errMessage);
            }
            catch (InstantiationException e) {
                throw new ArgException(errMessage);
            }
            catch (IllegalAccessException e) {
                throw new ArgException(errMessage);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (Throwable e) {
            if (e instanceof ArgException) {
                System.out.printf("%s\n", e.getMessage());
                AbstractUI.showUsage();
                AbstractUI.showEnv();
            }
            throw new AssertionError((Object)e);
        }
    }

    public AbstractUI(ArrayList<String> args) throws ArgException {
        usageList.add(APPLICATION_USAGE);
        envList.add(env);
        String archName = AbstractUI.getArg(args, "-a", true, true, env.valueOf(AppEnv.ARCHITECTURE));
        String variantName = AbstractUI.getArg(args, "-v", true, true, env.valueOf(AppEnv.VARIANT, "student"));
        String uiOptions = AbstractUI.getArg(args, "-o", true, true, env.valueOf(AppEnv.UI_OPTIONS, ""));
        this.machine = Config.newMachine(archName, variantName);
        this.applicationFullName = String.format("%s (%s)", APPLICATION_NAME, this.machine.getName());
    }

    public abstract void run();

    static {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", APPLICATION_NAME);
        configs = new HashMap();
        new Config("SM213-VM", "arch.sm213.isa.ISA", "arch.sm213.machine.solution.MainMemory", "arch.sm213.machine.solution.VirtualMemoryCPU", "arch.sm213.machine.<variant>.MainMemory", "arch.sm213.machine.<variant>.VirtualMemoryCPU", "[showMac][animation]");
        new Config("SM213", "arch.sm213.isa.ISA", "arch.sm213.machine.solution.MainMemory", "arch.sm213.machine.solution.CPU", "arch.sm213.machine.<variant>.MainMemory", "arch.sm213.machine.<variant>.CPU", "[showMac][animation]");
        new Config("Y86-Seq", "arch.y86.isa.ISA", "arch.y86.machine.MainMemory", "arch.y86.machine.seq.solution.CPU", "arch.y86.machine.MainMemory", "arch.y86.machine.seq.<variant>.CPU", "[twoProcStateCols][showDataAddr][animation]");
        new Config("Y86-Pipe-Minus", "arch.y86.isa.ISA", "arch.y86.machine.MainMemory", "arch.y86.machine.pipeminus.solution.CPU", "arch.y86.machine.MainMemory", "arch.y86.machine.pipeminus.<variant>.CPU", "[twoProcStateCols][smallCurInsDpy][showDataAddr]");
        new Config("Y86-Pipe", "arch.y86.isa.ISA", "arch.y86.machine.MainMemory", "arch.y86.machine.pipe.solution.CPU", "arch.y86.machine.MainMemory", "arch.y86.machine.pipe.<variant>.CPU", "[twoProcStateCols][smallCurInsDpy][showDataAddr]");
        new Config("Y86-Benchmark", "arch.y86.isa.ISA", "arch.y86.machine.MainMemory", "arch.y86.machine.benchmark.solution.CPU", "arch.y86.machine.MainMemory", "arch.y86.machine.benchmark.solution.CPU", "[twoProcStateCols][showDataAddr]");
    }

    protected static class ArgException
    extends Exception {
        public ArgException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Env<E extends Enum<E>> {
        private Class<E> enumClass;
        private static String prefix = "SIMPLE_MACHINE_";

        private static String nameOf(String var) {
            return prefix.concat(var);
        }

        private static String valueOf(String var) {
            return System.getenv(Env.nameOf(var));
        }

        public Env(Class<E> anEnumClass) {
            this.enumClass = anEnumClass;
        }

        public final String nameOf(E var) {
            return Env.nameOf(((Enum)var).toString());
        }

        public final String valueOf(E var) {
            return Env.valueOf(((Enum)var).toString());
        }

        public final String valueOf(E var, String ifNullValue) {
            String value = this.valueOf(var);
            return value != null ? value.toLowerCase() : (ifNullValue != null ? ifNullValue.toLowerCase() : null);
        }

        public final List<String> getNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (Enum var : EnumSet.allOf(this.enumClass)) {
                names.add(this.nameOf(var));
            }
            return names;
        }
    }

    protected static class Config {
        String name;
        String isa;
        String mem;
        String cpu;
        String memVar;
        String cpuVar;
        String uiOptions;

        private Config(String aName, String anIsa, String aMem, String aCpu, String aMemVar, String aCpuVar, String aUiOptions) {
            this.name = aName;
            this.isa = anIsa;
            this.mem = aMem;
            this.cpu = aCpu;
            this.memVar = aMemVar;
            this.cpuVar = aCpuVar;
            this.uiOptions = aUiOptions;
            configs.put(this.name.toLowerCase(), this);
        }

        private AbstractISA newISA(String variant) throws ConfigException {
            String errMsg = "ISA definition";
            try {
                return (AbstractISA)Class.forName(this.isa).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (InstantiationException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (IllegalAccessException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (InvocationTargetException e) {
                throw new ConfigException(variant, errMsg);
            }
        }

        private AbstractMainMemory newMainMemory(String variant, int byteCapacity) throws ConfigException {
            String errMsg = "main-memory implementation";
            try {
                String c = variant.equals(AbstractUI.SOLUTION_VARIANT) ? this.mem : this.memVar.replaceAll("<variant>", variant);
                return (AbstractMainMemory)Class.forName(c).getConstructor(Integer.TYPE).newInstance(byteCapacity);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (InstantiationException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (IllegalAccessException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (InvocationTargetException e) {
                throw new ConfigException(variant, errMsg);
            }
        }

        private AbstractCPU newCPU(String variant, AbstractMainMemory mainMemory) throws ConfigException {
            String errMsg = "cpu implementation";
            try {
                String fullname = this.name;
                if (!variant.isEmpty()) {
                    String vc = variant.substring(0, 1).toUpperCase().concat(variant.substring(1, variant.length()));
                    fullname = fullname.concat("-".concat(vc));
                }
                String c = variant.equals(AbstractUI.SOLUTION_VARIANT) ? this.cpu : this.cpuVar.replaceAll("<variant>", variant);
                return (AbstractCPU)Class.forName(c).getConstructor(String.class, AbstractMainMemory.class).newInstance(fullname, mainMemory);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (InstantiationException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (IllegalAccessException e) {
                throw new ConfigException(variant, errMsg);
            }
            catch (InvocationTargetException e) {
                throw (RuntimeException)e.getTargetException();
            }
        }

        public static Machine newMachine(String archName, String variantName) throws ArgException {
            Config config = (Config)configs.get(archName);
            if (config == null) {
                throw new ArgException(String.format("Unknown architecture %s\n", archName));
            }
            AbstractISA isa = config.newISA(variantName);
            AbstractMainMemory mainMemory = config.newMainMemory(variantName, 0x100000);
            AbstractCPU cpu = config.newCPU(variantName, mainMemory);
            Memory memory = new Memory(isa, (DataModel)mainMemory, cpu.getPC());
            return new Machine(cpu, memory, config.uiOptions);
        }

        private class ConfigException
        extends ArgException {
            ConfigException(String variant, String message) {
                super(String.format("Missing %s for %s-%s", message, Config.this.name, variant));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AppEnv {
        ARCHITECTURE,
        VARIANT,
        UI,
        UI_OPTIONS;

    }
}

