/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import machine.Register;
import util.AbstractDataModel;
import util.DataModelEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterSet
extends AbstractDataModel
implements Observer {
    private String name;
    private Vector<Register> registers = new Vector();
    private HashMap<String, Register> registerMap = new HashMap();

    public RegisterSet(String aName) {
        this.name = aName;
    }

    public boolean valueEquals(RegisterSet anotherRegisterSet) {
        boolean isEqualSoFar;
        boolean bl = isEqualSoFar = this.registers.size() == anotherRegisterSet.registers.size();
        if (isEqualSoFar) {
            for (int i = 0; isEqualSoFar && i < this.registers.size(); isEqualSoFar &= this.registers.get(i).valueEquals(anotherRegisterSet.registers.get(i)), ++i) {
            }
        }
        return isEqualSoFar;
    }

    public Ports getPorts() {
        return new Ports();
    }

    public Register add(String regName, Class regClass, boolean isUnsigned, boolean isUserEditable, boolean isVisible, long bubbleValue) {
        Register reg = new Register(regName, regClass, isUnsigned, isUserEditable, bubbleValue);
        if (isVisible) {
            this.registers.add(reg);
        }
        this.registerMap.put(regName, reg);
        reg.addObserver(this);
        return reg;
    }

    public Register addUnsigned(String regName, Class regClass, long bubbleValue) {
        return this.add(regName, regClass, true, false, true, bubbleValue);
    }

    public Register addUnsigned(String regName, Class regClass, boolean isUserEditable) {
        return this.add(regName, regClass, true, isUserEditable, true, 0L);
    }

    public Register addUnsigned(String regName, Class regClass) {
        return this.add(regName, regClass, true, false, true, 0L);
    }

    public Register addSigned(String regName, Class regClass) {
        return this.add(regName, regClass, false, false, true, 0L);
    }

    public Register addUnsigned(String regName, boolean isUserEditable) {
        return this.add(regName, Integer.class, true, isUserEditable, true, 0L);
    }

    public Register addSigned(String regName, boolean isUserEditable) {
        return this.add(regName, Integer.class, false, isUserEditable, true, 0L);
    }

    public Register addUnsigned(String regName) {
        return this.add(regName, Integer.class, true, false, true, 0L);
    }

    public Register addSigned(String regName) {
        return this.add(regName, Integer.class, false, false, true, 0L);
    }

    public Register getRegister(String aName) {
        return this.registerMap.get(aName);
    }

    public List<Register> getAll() {
        return this.registers;
    }

    public String getName() {
        return this.name;
    }

    private int getValue(int regIndex) throws InvalidRegisterNumberException {
        try {
            return this.registers.get(regIndex).get();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidRegisterNumberException();
        }
    }

    private void setValue(int regIndex, long value) throws InvalidRegisterNumberException {
        try {
            this.registers.get(regIndex).set(value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidRegisterNumberException();
        }
    }

    public int getValue(String regName) throws InvalidRegisterNameError {
        try {
            return this.registerMap.get(regName).get();
        }
        catch (NullPointerException e) {
            throw new InvalidRegisterNameError();
        }
    }

    public int getInputValue(String regName) throws InvalidRegisterNameError, Register.TimingException {
        try {
            return this.registerMap.get(regName).getInput();
        }
        catch (NullPointerException e) {
            throw new InvalidRegisterNameError();
        }
    }

    public int getInputValue(int regIndex) throws InvalidRegisterNumberException, Register.TimingException {
        try {
            return this.registers.get(regIndex).getInput();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidRegisterNumberException();
        }
    }

    public void setValue(String regName, long value) throws InvalidRegisterNameError {
        try {
            this.registerMap.get(regName).set(value);
        }
        catch (NullPointerException e) {
            throw new InvalidRegisterNameError();
        }
    }

    public void tickClock(Register.ClockTransition transition) {
        for (Register r : this.registerMap.values()) {
            r.tickClock(transition);
        }
    }

    @Override
    public void update(Observable o, Object obj) {
        Register reg = (Register)o;
        DataModelEvent event = (DataModelEvent)obj;
        this.tellObservers(new DataModelEvent(event.getType(), this.registers.indexOf(reg), 1));
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return Long.class;
        }
        throw new AssertionError();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Reg";
        }
        if (columnIndex == 1) {
            return "Value";
        }
        throw new AssertionError();
    }

    @Override
    public int getRowCount() {
        return this.registers.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.registers.get(rowIndex).getValueAt(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.registers.get(rowIndex).isCellEditable(0, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.registers.get(rowIndex).setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public void setValueAtByUser(Object aValue, int rowIndex, int columnIndex) {
        this.registers.get(rowIndex).setValueAtByUser(aValue, rowIndex, columnIndex);
    }

    public class Ports {
        public int get(int regIndex) throws InvalidRegisterNumberException {
            return RegisterSet.this.getValue(regIndex);
        }

        public void set(int regIndex, long value) throws InvalidRegisterNumberException {
            RegisterSet.this.setValue(regIndex, value);
        }
    }

    public class InvalidRegisterNameError
    extends Error {
    }

    public class InvalidRegisterNumberException
    extends Exception {
    }
}

