/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import util.AbstractDataModel;
import util.DataModelEvent;
import util.HalfByteNumber;
import util.SixByteNumber;
import util.UserVisibleException;

public class Register
extends AbstractDataModel {
    private static HashMap<Class, Integer> classBitLengths = new HashMap();
    private String name;
    private boolean isUserEditable;
    private boolean isUnsigned;
    private long outputValue;
    private long inputValue;
    private boolean inputStable;
    private long bubbleValue;
    private Class<?> valueClass;
    private long signExtend;
    private long valueMask;
    private long signMask;

    public Port getPort() {
        return new Port();
    }

    public NonClockedPort getNonClockedPort() {
        return new NonClockedPort();
    }

    public OutputPort getOutputPort() {
        return new OutputPort();
    }

    public InputPort getInputPort() {
        return new InputPort();
    }

    Register(String aName, Class aValueClass, boolean anIsUnsigned, boolean anIsUserEditable, long aBubbleValue) {
        this.name = aName;
        this.isUserEditable = anIsUserEditable;
        this.isUnsigned = anIsUnsigned;
        this.valueClass = aValueClass;
        this.inputValue = this.bubbleValue = aBubbleValue;
        this.outputValue = this.bubbleValue;
        this.initTwosComplementMasks();
    }

    public boolean valueEquals(Register anotherRegister) {
        return this.outputValue == anotherRegister.outputValue;
    }

    private void initTwosComplementMasks() {
        Integer bitLength = classBitLengths.get(this.valueClass);
        if (bitLength == null) {
            throw new AssertionError();
        }
        if (bitLength != 64) {
            this.signExtend = -1L << bitLength;
            this.valueMask = this.signExtend ^ 0xFFFFFFFFFFFFFFFFL;
            this.signMask = 1 << bitLength - 1;
        } else {
            this.signExtend = 0L;
            this.valueMask = -1L;
            this.signMask = 0L;
        }
    }

    private int signExtend(int value) {
        return (int)((long)value | (((long)value & this.signMask) != 0L ? this.signExtend : 0L));
    }

    private Class getInputValueWrapperClass() {
        if (this.valueClass == HalfByteNumber.class) {
            return Byte.TYPE;
        }
        if (this.valueClass == Byte.class) {
            return Byte.TYPE;
        }
        if (this.valueClass == Short.class) {
            return Short.TYPE;
        }
        if (this.valueClass == Integer.class) {
            return Integer.TYPE;
        }
        return Long.TYPE;
    }

    private Number castNumberToWrapper(long number) {
        if (this.valueClass == HalfByteNumber.class) {
            return new Byte((byte)number);
        }
        if (this.valueClass == Byte.class) {
            return new Byte((byte)number);
        }
        if (this.valueClass == Short.class) {
            return new Short((short)number);
        }
        if (this.valueClass == Integer.class) {
            return new Integer((int)number);
        }
        return new Long(number);
    }

    public String getName() {
        return this.name;
    }

    private synchronized void setSilently(long aValue) {
        this.inputValue = aValue & this.valueMask;
        this.inputStable = true;
        this.notifyAll();
    }

    public void set(long aValue) {
        this.setSilently(aValue);
        this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE, 0, 1));
    }

    public int get() {
        return this.isUnsigned ? this.getUnsigned() : this.signExtend(this.getUnsigned());
    }

    public int getUnsigned() {
        this.tellObservers(new DataModelEvent(DataModelEvent.Type.READ, 0, 1));
        return (int)this.outputValue;
    }

    public synchronized int getInput() throws TimingException {
        return this.isUnsigned ? this.getInputUnsigned() : this.signExtend(this.getInputUnsigned());
    }

    public synchronized int getInputUnsigned() throws TimingException {
        try {
            if (!this.inputStable) {
                this.wait(2000L);
            }
            if (!this.inputStable) {
                throw new InterruptedException();
            }
            this.tellObservers(new DataModelEvent(DataModelEvent.Type.READ, 0, 1));
            return (int)this.inputValue;
        }
        catch (InterruptedException e) {
            throw new TimingException();
        }
    }

    public synchronized void tickClock(ClockTransition transition) {
        switch (transition) {
            case NORMAL: {
                this.outputValue = this.inputValue;
                break;
            }
            case STALL: {
                this.inputValue = this.outputValue;
                break;
            }
            case BUBBLE: {
                this.outputValue = this.bubbleValue;
                this.inputValue = this.bubbleValue;
            }
        }
        this.inputStable = false;
        this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, 0, 1));
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return this.valueClass;
        }
        throw new AssertionError();
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Reg";
        }
        if (columnIndex == 1) {
            return "Value";
        }
        throw new AssertionError();
    }

    public int getRowCount() {
        return 1;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.name;
        }
        if (columnIndex == 1) {
            try {
                Constructor<?> constructor = this.valueClass.getConstructor(this.getInputValueWrapperClass());
                return constructor.newInstance(this.castNumberToWrapper(this.inputValue));
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        throw new AssertionError();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        if (columnIndex == 1) {
            return this.isUserEditable;
        }
        throw new AssertionError();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            if (!(aValue instanceof Number)) {
                throw new ClassCastException();
            }
        } else {
            throw new AssertionError();
        }
        this.setSilently(((Number)aValue).longValue());
        this.tickClock(ClockTransition.NORMAL);
        this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE, 0, 1));
    }

    public void setValueAtByUser(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            if (!(aValue instanceof Number)) {
                throw new ClassCastException();
            }
        } else {
            throw new AssertionError();
        }
        this.setSilently(((Number)aValue).longValue());
        this.tickClock(ClockTransition.NORMAL);
        this.tellObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, 0, 1));
    }

    static {
        classBitLengths.put(HalfByteNumber.class, 4);
        classBitLengths.put(Byte.class, 8);
        classBitLengths.put(Short.class, 16);
        classBitLengths.put(Integer.class, 32);
        classBitLengths.put(SixByteNumber.class, 48);
        classBitLengths.put(Long.class, 64);
    }

    public class InputPort {
        public int getValueProduced() throws TimingException {
            return Register.this.getInput();
        }

        public void set(long aValue) {
            Register.this.set(aValue);
        }
    }

    public class OutputPort {
        public int get() {
            return Register.this.get();
        }
    }

    public class NonClockedPort
    extends Port {
        public int get() {
            if (Register.this.inputStable) {
                try {
                    return Register.this.getInput();
                }
                catch (TimingException te) {
                    throw new AssertionError((Object)te);
                }
            }
            return Register.this.get();
        }

        public int getUnsigned() {
            if (Register.this.inputStable) {
                try {
                    return Register.this.getInputUnsigned();
                }
                catch (TimingException te) {
                    throw new AssertionError((Object)te);
                }
            }
            return Register.this.getUnsigned();
        }

        public void set(long aValue) {
            Register.this.set(aValue);
        }
    }

    public class Port {
        public int get() {
            return Register.this.get();
        }

        public int getUnsigned() {
            return Register.this.getUnsigned();
        }

        public void set(long aValue) {
            Register.this.set(aValue);
        }
    }

    public class TimingException
    extends UserVisibleException {
        static final String MESSAGE = "Timing error on register %s";

        public TimingException() {
            super(String.format(MESSAGE, Register.this.name));
        }

        public TimingException(int aPC) {
            super(String.format(MESSAGE, Register.this.name), aPC);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClockTransition {
        NORMAL,
        STALL,
        BUBBLE;

    }
}

