/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Observable;
import java.util.Vector;
import machine.AbstractMainMemory;
import machine.Register;
import machine.RegisterSet;
import util.DataModel;
import util.UserVisibleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCPU
extends Observable {
    private final String name;
    private boolean isInterrupt;
    public final InternalState is;
    protected RegisterSet.Ports reg;
    protected AbstractMainMemory.Port mem;

    public AbstractCPU(String aName, AbstractMainMemory aMem) {
        this.is = new InternalState(aMem);
        this.name = aName;
        this.mem = this.is.memImp.getPort();
        this.reg = this.is.regFile.getPorts();
    }

    public static AbstractCPU newInstance(AbstractCPU aCPU) {
        AbstractMainMemory newMemory = AbstractMainMemory.newInstance(aCPU.is.memImp);
        Class<?> cpuClass = aCPU.getClass();
        try {
            Constructor<?> cpuCtor = cpuClass.getConstructor(AbstractMainMemory.class);
            return (AbstractCPU)cpuCtor.newInstance(newMemory);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
    }

    public AbstractMainMemory getMainMemory() {
        return this.is.memImp;
    }

    public RegisterSet getRegisterFile() {
        return this.is.regFile;
    }

    public Vector<RegisterSet> getProcessorState() {
        return this.is.processorState;
    }

    public String getName() {
        return this.name;
    }

    public DataModel getPC() {
        return this.is.processorState.get(0).getRegister("PC");
    }

    public void resetMachineToPC(int aPC) {
        Register pc = this.is.processorState.get(0).getRegister("PC");
        pc.set(aPC);
        pc.tickClock(Register.ClockTransition.NORMAL);
    }

    protected abstract void cycle() throws InvalidInstructionException, MachineHaltException, AbstractMainMemory.InvalidAddressException, Register.TimingException, ImplementationException;

    public synchronized void triggerInterrupt() {
        this.isInterrupt = true;
    }

    public boolean isInterrupt() {
        return this.isInterrupt;
    }

    public void start() throws InvalidInstructionException, MachineHaltException, AbstractMainMemory.InvalidAddressException, Register.TimingException, ImplementationException {
        this.isInterrupt = false;
        while (true) {
            this.setChanged();
            this.notifyObservers();
            if (this.isInterrupt) {
                this.isInterrupt = false;
                return;
            }
            this.cycle();
        }
    }

    public class ImplementationException
    extends UserVisibleException {
        static final String MESSAGE = "Implementation error, %s";

        public ImplementationException() {
            super("");
        }

        public ImplementationException(RuntimeException aCause) {
            super(String.format(MESSAGE, aCause.getMessage()), aCause);
        }

        public ImplementationException(RuntimeException aCause, int aPC) {
            super(String.format(MESSAGE, aCause.getMessage()), aPC, aCause);
        }
    }

    public class MachineHaltException
    extends UserVisibleException {
        static final String MESSAGE = "HALT instruction executed";

        public MachineHaltException() {
            super(MESSAGE);
        }

        public MachineHaltException(int aPC) {
            super(MESSAGE, aPC, null);
        }
    }

    public class InvalidInstructionException
    extends UserVisibleException {
        static final String MESSAGE = "Invalid instruction";

        public InvalidInstructionException() {
            super(MESSAGE);
        }

        public InvalidInstructionException(int aPC) {
            super(MESSAGE, aPC);
        }

        public InvalidInstructionException(Exception aCause) {
            super(MESSAGE, aCause);
        }

        public InvalidInstructionException(Exception aCause, int aPC) {
            super(MESSAGE, aPC, aCause);
        }
    }

    public static class InternalState {
        public final AbstractMainMemory memImp;
        public final RegisterSet regFile = new RegisterSet("Register File");
        public final Vector<RegisterSet> processorState = new Vector();
        public static final String PC = "PC";
        public static final String CURRENT_INSTRUCTION_ADDRESS = "CurrentInstructionAddress";

        InternalState(AbstractMainMemory aMemImp) {
            this.memImp = aMemImp;
        }
    }
}

