/*
 * Decompiled with CFR 0.152.
 */
package isa;

import isa.AbstractAssembler;
import isa.AbstractISA;
import isa.DataRegion;
import isa.Datum;
import isa.Instruction;
import isa.InstructionRegion;
import isa.MemoryCell;
import isa.Region;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import util.AbstractDataModel;
import util.BitStream;
import util.BitString;
import util.DataModel;
import util.DataModelEvent;
import util.MapModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Memory
extends AbstractDataModel
implements Observer {
    private AbstractISA isa;
    private DataModel mainMemory;
    private DataModel pc;
    private Integer lastPC;
    private LabelMap labelMap;
    private Vector<Region> regions;
    private String loadedFile;
    private boolean unsavedChanges;
    private List<StateChangedListener> stateChangedListeners = new Vector<StateChangedListener>();
    private List<LengthChangedListener> lengthChangedListeners = new Vector<LengthChangedListener>();
    Vector<UndoableEditListener> undoListeners = new Vector();

    public Memory(AbstractISA anISA, DataModel aMainMemory, DataModel aPC) {
        this.isa = anISA;
        this.mainMemory = aMainMemory;
        this.pc = aPC;
        this.lastPC = null;
        this.labelMap = new LabelMap();
        this.regions = new Vector();
        this.loadedFile = null;
        this.unsavedChanges = false;
        this.mainMemory.addObserver(this);
        this.pc.addObserver(this);
        this.isa.setAddressToLabelMap(this.labelMap.addressToLabelMap);
        this.labelMap.addObserver(this);
    }

    public Memory(Memory fromMemory, DataModel aMainMemory, DataModel aPC) {
        this(fromMemory.isa, aMainMemory, aPC);
    }

    public boolean valueEquals(Memory aMemory) {
        boolean equalSoFar = this.regions.size() == aMemory.regions.size();
        for (int i = 0; equalSoFar && i < this.regions.size(); equalSoFar &= this.regions.get(i).valueEquals(aMemory.regions.get(i)), ++i) {
        }
        return equalSoFar;
    }

    public LabelMap getLabelMap() {
        return this.labelMap;
    }

    public boolean hasLoadedFile() {
        return this.loadedFile != null;
    }

    public String getLoadedFilename() {
        String[] path = this.loadedFile.split("[/\\\\:]");
        return path[path.length - 1];
    }

    public String getLoadedPathname() {
        return this.loadedFile;
    }

    public boolean hasUnsavedChanges() {
        return this.unsavedChanges;
    }

    public void setChanged(boolean isChanged) {
        final boolean oldValue = this.unsavedChanges;
        this.unsavedChanges = isChanged;
        for (StateChangedListener l : this.stateChangedListeners) {
            l.memoryStateChanged();
        }
        if (isChanged != oldValue) {
            this.addUndo(new Undo("", false){
                boolean value;
                {
                    super(x0, x1);
                    this.value = oldValue;
                }

                private void setValue() {
                    boolean v = Memory.this.unsavedChanges;
                    Memory.this.unsavedChanges = this.value;
                    this.value = v;
                    for (StateChangedListener l : Memory.this.stateChangedListeners) {
                        l.memoryStateChanged();
                    }
                }

                public void undo() {
                    super.undo();
                    this.setValue();
                }

                public void redo() {
                    super.redo();
                    this.setValue();
                }
            });
        }
    }

    public void addStateChangedListener(StateChangedListener l) {
        this.stateChangedListeners.add(l);
    }

    public void removeStateChangedListener(StateChangedListener l) {
        this.stateChangedListeners.remove(l);
    }

    public void addLengthChangedListener(LengthChangedListener l) {
        this.lengthChangedListeners.add(l);
    }

    public void fireInserted(int address, int length, int lastAddress) {
        for (LengthChangedListener l : this.lengthChangedListeners) {
            l.changed(address, length, lastAddress, LengthChangedListener.Type.INSERTED);
        }
    }

    public void fireDeleted(int address, int length, int lastAddress) {
        for (LengthChangedListener l : this.lengthChangedListeners) {
            l.changed(address, length, lastAddress, LengthChangedListener.Type.DELETED);
        }
    }

    public List<Region> getRegions() {
        return new Vector<Region>(this.regions);
    }

    public Region regionForAddress(int address) {
        for (Region r : this.regions) {
            if (address < r.getAddress() || address > r.getAddress() + r.byteLength() - 1) continue;
            return r;
        }
        return null;
    }

    Vector<Region> regionsForAddressRange(int address, int length) {
        Vector<Region> selectedRegions = new Vector<Region>();
        for (Region r : this.regions) {
            boolean startsAtOrBeforeRegionEnd;
            boolean endsAtOrAfterRegionStart = address + length - 1 >= r.getAddress();
            boolean bl = startsAtOrBeforeRegionEnd = address <= r.getAddress() + r.byteLength() - 1;
            if (!endsAtOrAfterRegionStart || !startsAtOrBeforeRegionEnd) continue;
            selectedRegions.add(r);
        }
        return selectedRegions;
    }

    public void addLabelOnly(MemoryCell cell) {
        this.labelMap.add(cell);
    }

    public void add(MemoryCell cell) {
        Region.Type type;
        if (cell instanceof Instruction) {
            type = Region.Type.INSTRUCTIONS;
        } else if (cell instanceof Datum) {
            type = Region.Type.DATA;
        } else {
            throw new AssertionError();
        }
        Vector<Region> neighbours = this.regionsForAddressRange(cell.getAddress() - 1, cell.length() + 2);
        assert (neighbours.size() <= 2);
        if (neighbours.size() == 2 && type == neighbours.get(0).getType() && type == neighbours.get(1).getType()) {
            neighbours.get(0).add(cell);
            neighbours.get(0).replace(null, neighbours.get((int)1).rows);
            this.regions.remove(neighbours.get(1));
        } else if (neighbours.size() == 2 && type == neighbours.get(1).getType()) {
            neighbours.get(1).add(cell);
        } else if (neighbours.size() >= 1 && type == neighbours.get(0).getType()) {
            neighbours.get(0).add(cell);
        } else {
            Region region;
            switch (type) {
                case INSTRUCTIONS: {
                    region = new InstructionRegion(this);
                    break;
                }
                case DATA: {
                    region = new DataRegion(this);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.regions.add(region);
            region.add(cell);
        }
    }

    public void clear() {
        this.regions.clear();
        this.labelMap.clear();
    }

    @Override
    public void update(Observable o, Object arg) {
        DataModelEvent event = (DataModelEvent)arg;
        if (o == this.pc) {
            int newPC = (Integer)this.pc.getValueAt(event.getCells().get((int)0).rowIndex, event.getCells().get((int)0).columnIndex);
            if (this.lastPC == null || this.lastPC != newPC) {
                DataModelEvent ce;
                Region region;
                if (this.lastPC != null && (region = this.regionForAddress(this.lastPC)) != null) {
                    ce = region.update(new DataModelEvent(DataModelEvent.Type.CURSOR_CLEAR, this.lastPC, 0));
                    this.tellObservers(ce);
                }
                this.lastPC = newPC;
                region = this.regionForAddress(this.lastPC);
                if (region != null) {
                    ce = region.update(new DataModelEvent(DataModelEvent.Type.CURSOR_SET, this.lastPC, 0));
                    this.tellObservers(ce);
                }
            }
        } else if (o == this.mainMemory) {
            int firstAddress = event.getCells().get((int)0).rowIndex;
            int lastAddress = event.getCells().get((int)(event.getCells().size() - 1)).rowIndex;
            Vector<Region> affectedRegions = this.regionsForAddressRange(firstAddress, lastAddress - firstAddress + 1);
            for (Region r : affectedRegions) {
                r.update(event);
            }
        } else if (o == this.labelMap) {
            block5: for (Region r : this.regions) {
                switch (LabelMapEventType.values()[event.getCells().get((int)0).columnIndex]) {
                    case ADDRESS_CHANGE: {
                        r.syncMemoryFromAsm();
                        continue block5;
                    }
                    case ADD_OR_REMOVE: {
                        r.syncAsmFromMemory();
                        continue block5;
                    }
                }
                throw new AssertionError();
            }
        } else {
            throw new ClassCastException();
        }
    }

    public int getAlignedInstructionAddress(int addr) {
        Region region = this.regionForAddress(addr);
        MemoryCell cell = region.getCellContainingAddress(addr);
        return cell.getAddress() == addr ? addr : cell.getAddress() + cell.length();
    }

    AbstractISA.InstructionDef getInstructionDefForOpCode(int opCode) {
        return this.isa.getDefForOpCode(opCode);
    }

    AbstractISA.InstructionDef getInstructionDefForValue(int address) {
        return this.isa.getDefForValue(new BitStream(this, address));
    }

    AbstractISA.InstructionDef getPlaceholderInstructionDef() {
        return this.isa.getPlaceholderInstructionDef();
    }

    BitString getPlaceholderInstructionValue() {
        return this.isa.getPlaceholderInstructionValue();
    }

    public String getIsaName() {
        return this.isa.getName();
    }

    public int normalizeEndianness(int num, int byteSize) {
        return this.isa.normalizeEndianness(num, byteSize);
    }

    void loadAssemblyLine(int address, String label, String statement, String comment) throws AbstractAssembler.AssemblyException {
        this.isa.assembleLine(address, label, statement, comment, this);
    }

    void checkAssemblyLineSyntax(int address, String label, String statement, String comment) throws AbstractAssembler.AssemblyException {
        this.isa.checkAssemblyLineSyntax(address, label, statement, comment, this);
    }

    void checkAssemblyLabelSyntax(String label) throws AbstractAssembler.AssemblyException {
        this.isa.checkAssemblyLabelSyntax(label, this);
    }

    public void checkpointData(boolean changesMemory) {
        for (Region r : this.regions) {
            if (r.getType() != Region.Type.DATA) continue;
            ((DataRegion)r).checkpoint();
        }
        if (changesMemory) {
            this.setChanged(true);
        }
    }

    public void restoreDataFromCheckpoint() {
        for (Region r : this.regions) {
            if (r.getType() != Region.Type.DATA) continue;
            ((DataRegion)r).restoreFromCheckpoint();
        }
    }

    public void saveToFile(String filename) throws FileNotFoundException {
        if (filename == null) {
            filename = this.loadedFile;
        }
        if (filename != null) {
            PrintStream ps = new PrintStream(filename);
            for (Region r : this.regions) {
                ps.print(String.format(".pos 0x%x\n", r.getAddress()));
                for (MemoryCell c : r.getSavableRows()) {
                    String label = c.getLabel();
                    String comment = c.getComment();
                    ps.print(String.format("%-16s %-24s %s\n", label != null && !label.equals("") ? label.concat(":") : "", c.toAsm(), comment != null && !comment.equals("") ? "# ".concat(comment) : ""));
                }
            }
            ps.close();
            this.setChanged(false);
        }
    }

    public void loadFile(String filename) throws InputFileSyntaxException, FileNotFoundException, IOException, FileTypeException {
        this.clear();
        if (filename.length() >= 3 && filename.substring(filename.length() - 2).equals(".s")) {
            this.loadAssemblyFile(filename);
            this.loadedFile = filename;
            this.setChanged(false);
        } else if (filename.length() >= 9 && filename.substring(filename.length() - 8).equals(".machine")) {
            this.loadMachineFile(filename);
            this.loadedFile = filename.substring(0, filename.length() - 7).concat("s");
            this.setChanged(true);
        } else {
            throw new FileTypeException();
        }
        for (StateChangedListener l : this.stateChangedListeners) {
            l.memoryStateChanged();
        }
        this.checkpointData(false);
    }

    private void loadAssemblyFile(String filename) throws InputFileSyntaxException, FileNotFoundException, IOException {
        try {
            this.isa.assembleFile(filename, this);
        }
        catch (AbstractAssembler.AssemblyException e) {
            throw new InputFileSyntaxException(e.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadMachineFile(String aFilename) throws InputFileSyntaxException, FileNotFoundException, IOException {
        if (aFilename == null) {
            throw new FileNotFoundException();
        }
        File aFile = new File(aFilename);
        int curLine = 0;
        Pattern linePattern = Pattern.compile("^\\s*(([0-9a-fA-F]{1,8}):)?\\s*((([0-9a-fA-F]{4})\\s*([0-9a-fA-F]{8})?)|(([0-9a-fA-F]{8}))|())\\s*(#.*)?$");
        BufferedReader exec = new BufferedReader(new InputStreamReader(new FileInputStream(aFile)));
        int startAddress = 0;
        int curAddress = 0;
        try {
            while (exec.ready()) {
                byte[] valBytesLo;
                byte[] valBytesHi;
                int val;
                int lineLength = 0;
                String aLine = exec.readLine();
                Matcher lineMatcher = linePattern.matcher(aLine);
                ++curLine;
                String comment = "";
                if (!lineMatcher.matches()) throw new InputFileSyntaxException("Invalid format in input file", curLine);
                if (lineMatcher.group(1) != null) {
                    curAddress = startAddress = Integer.parseInt(lineMatcher.group(2), 16);
                }
                if (lineMatcher.group(5) != null) {
                    val = Integer.parseInt(lineMatcher.group(5), 16);
                    byte[] valBytes = new byte[]{(byte)(val >> 8), (byte)val};
                    this.setValueAt(new Byte(valBytes[0]), curAddress + lineLength, 1);
                    this.setValueAt(new Byte(valBytes[1]), curAddress + lineLength + 1, 1);
                    lineLength = 2;
                }
                if (lineMatcher.group(6) != null) {
                    val = (int)Long.parseLong(lineMatcher.group(6), 16);
                    valBytesHi = new byte[]{(byte)(val >> 24), (byte)(val >> 16)};
                    valBytesLo = new byte[]{(byte)(val >> 8), (byte)val};
                    this.setValueAt(new Byte(valBytesHi[0]), curAddress + lineLength, 1);
                    this.setValueAt(new Byte(valBytesHi[1]), curAddress + lineLength + 1, 1);
                    this.setValueAt(new Byte(valBytesLo[0]), curAddress + lineLength + 2, 1);
                    this.setValueAt(new Byte(valBytesLo[1]), curAddress + lineLength + 3, 1);
                    lineLength = 6;
                }
                if (lineMatcher.group(8) != null) {
                    val = (int)Long.parseLong(lineMatcher.group(8), 16);
                    valBytesHi = new byte[]{(byte)(val >> 24), (byte)(val >> 16)};
                    valBytesLo = new byte[]{(byte)(val >> 8), (byte)val};
                    this.setValueAt(new Byte(valBytesHi[0]), curAddress + lineLength, 1);
                    this.setValueAt(new Byte(valBytesHi[1]), curAddress + lineLength + 1, 1);
                    this.setValueAt(new Byte(valBytesLo[0]), curAddress + lineLength + 2, 1);
                    this.setValueAt(new Byte(valBytesLo[1]), curAddress + lineLength + 3, 1);
                    lineLength = 4;
                }
                if (lineMatcher.group(10) != null) {
                    comment = lineMatcher.group(10).substring(1).trim();
                }
                if (lineLength == 2 || lineLength == 6) {
                    Instruction ins = Instruction.valueOfMemory(this, curAddress, "", comment);
                    if (ins == null) throw new InputFileSyntaxException("Invalid instruction in input file", curLine);
                    this.add(ins);
                } else if (lineLength == 4) {
                    this.add(Datum.valueOfMemory(this, curAddress, lineLength, "", comment));
                }
                curAddress += lineLength;
            }
            return;
        }
        catch (IndexOutOfBoundsException e) {
            throw new InputFileSyntaxException("Illegal address in input file", curLine);
        }
        finally {
            if (exec != null) {
                exec.close();
            }
        }
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener l) {
        this.undoListeners.add(l);
    }

    protected void addUndo(UndoableEdit e) {
        for (UndoableEditListener l : this.undoListeners) {
            l.undoableEditHappened(new UndoableEditEvent(this, e));
        }
    }

    @Override
    public void addObserver(Observer anObserver) {
        super.addObserver(anObserver);
        this.mainMemory.addObserver(anObserver);
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return this.mainMemory.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.mainMemory.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.mainMemory.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.mainMemory.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.mainMemory.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.mainMemory.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object[] aValue, int rowIndex, int columnIndex) {
        this.mainMemory.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.mainMemory.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public void setValueAtByUser(Object aValue, int rowIndex, int columnIndex) {
        this.mainMemory.setValueAtByUser(aValue, rowIndex, columnIndex);
    }

    @Override
    public void setValueAtByUser(Object[] aValue, int rowIndex, int columnIndex) {
        this.mainMemory.setValueAtByUser(aValue, rowIndex, columnIndex);
    }

    static class Undo
    extends AbstractUndoableEdit {
        String presentationName;
        boolean isSignificant;

        public Undo(String name, boolean sig) {
            this.presentationName = name;
            this.isSignificant = sig;
        }

        public String getPresentationName() {
            return this.presentationName;
        }

        public boolean isSignificant() {
            return this.isSignificant;
        }
    }

    public static class FileTypeException
    extends Exception {
    }

    public class InputFileSyntaxException
    extends Exception {
        String message;
        boolean knowLineNumber;
        int lineNumber;

        InputFileSyntaxException(String aMessage, boolean aKnowLineNumber, int aLineNumber) {
            this.lineNumber = aLineNumber;
            this.knowLineNumber = aKnowLineNumber;
            this.message = aMessage;
        }

        InputFileSyntaxException(String aMessage, int aLineNumber) {
            this(aMessage, true, aLineNumber);
        }

        InputFileSyntaxException(int aLineNumber) {
            this(null, true, aLineNumber);
        }

        InputFileSyntaxException(String aMessage) {
            this(aMessage, false, 0);
        }

        InputFileSyntaxException() {
            this(null, false, 0);
        }

        public String toString() {
            if (this.knowLineNumber) {
                return String.format("%s online %d.", this.message != null ? this.message : "", this.lineNumber);
            }
            return String.format("%s.", this.message != null ? this.message : "");
        }
    }

    public static interface LengthChangedListener {
        public void changed(int var1, int var2, int var3, Type var4);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            INSERTED,
            DELETED;

        }
    }

    public static interface StateChangedListener {
        public void memoryStateChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LabelMap
    extends Observable
    implements MapModel {
        private Map<Integer, String> addressToLabelMap = new HashMap<Integer, String>();
        private Map<String, Integer> labelToAddressMap = new HashMap<String, Integer>();

        public Integer getAddress(String label) {
            return this.labelToAddressMap.get(label);
        }

        public String getLabel(Integer address) {
            return this.addressToLabelMap.get(address);
        }

        public void changeAddresses(Vector<MemoryCell> cells) {
            if (cells.size() > 0) {
                String label;
                for (MemoryCell c : cells) {
                    label = c.getLabel();
                    if (label == null || label.trim().equals("")) continue;
                    this.addressToLabelMap.remove(this.labelToAddressMap.get(label));
                    this.labelToAddressMap.remove(label);
                }
                for (MemoryCell c : cells) {
                    label = c.getLabel();
                    Integer address = c.getAddress();
                    if (label == null || label.trim().equals("")) continue;
                    this.addressToLabelMap.put(address, label);
                    this.labelToAddressMap.put(label, address);
                }
                this.setChanged();
                this.notifyObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, cells.get(0).getAddress(), LabelMapEventType.ADDRESS_CHANGE.ordinal()));
            }
        }

        public void add(MemoryCell cell) {
            String label = cell.getLabel();
            int address = cell.getAddress();
            String curLabelForAddress = this.addressToLabelMap.get(address);
            if (curLabelForAddress == null || !curLabelForAddress.equals(label)) {
                LabelMapEventType changeType;
                Integer oldAddressForLabel;
                if (curLabelForAddress != null) {
                    this.addressToLabelMap.remove(address);
                    this.labelToAddressMap.remove(curLabelForAddress);
                }
                if ((oldAddressForLabel = this.labelToAddressMap.get(label)) != null) {
                    this.addressToLabelMap.remove(oldAddressForLabel);
                    this.labelToAddressMap.remove(label);
                    changeType = LabelMapEventType.ADDRESS_CHANGE;
                } else {
                    changeType = LabelMapEventType.ADD_OR_REMOVE;
                }
                boolean hasLabel = label != null & !label.trim().equals("");
                if (hasLabel) {
                    this.addressToLabelMap.put(address, label);
                    this.labelToAddressMap.put(label, address);
                }
                if (hasLabel || curLabelForAddress != null || oldAddressForLabel != null) {
                    this.setChanged();
                    this.notifyObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, address, changeType.ordinal()));
                }
            }
        }

        public void remove(MemoryCell cell) {
            Integer address;
            String label = cell.getLabel();
            if (label != null & !label.trim().equals("") && (address = this.labelToAddressMap.get(label)) != null) {
                this.addressToLabelMap.remove(address);
                this.labelToAddressMap.remove(label);
                this.setChanged();
                this.notifyObservers(new DataModelEvent(DataModelEvent.Type.WRITE_BY_USER, address, LabelMapEventType.ADD_OR_REMOVE.ordinal()));
            }
        }

        public void clear() {
            this.addressToLabelMap.clear();
            this.labelToAddressMap.clear();
        }

        @Override
        public Object get(Object key) {
            return this.addressToLabelMap.get((Integer)key);
        }

        @Override
        public Object reverseGet(Object key) {
            return this.labelToAddressMap.get((String)key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LabelMapEventType {
        ADD_OR_REMOVE,
        ADDRESS_CHANGE;

    }
}

