/*
 * Decompiled with CFR 0.152.
 */
package isa;

import isa.Datum;
import isa.Memory;
import isa.MemoryCell;
import isa.Region;

public class DataRegion
extends Region {
    public DataRegion(Memory aMemory) {
        super(aMemory, Region.Type.DATA);
    }

    MemoryCell newPlaceholderCell(int address) {
        return Datum.valueOf(this.memory, address, 0, "", "");
    }

    public void checkpoint() {
        for (MemoryCell c : this.rows) {
            c.checkpointValue();
        }
    }

    public void restoreFromCheckpoint() {
        for (MemoryCell c : this.rows) {
            c.restoreValueFromCheckpoint();
        }
    }

    void memorySyncChangedCellLength(MemoryCell cell, int oldLength) {
        assert (false);
    }

    public int getAsmColumn() {
        return 2;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        if (columnIndex == 1) {
            return Value.class;
        }
        if (columnIndex == 2) {
            return String.class;
        }
        if (columnIndex == 3) {
            return Region.LabelString.class;
        }
        if (columnIndex == 4) {
            return String.class;
        }
        throw new AssertionError();
    }

    public boolean isMemoryValueColumn(int columnIndex) {
        return columnIndex == 0 || columnIndex == 1 || columnIndex == 2;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Addr";
        }
        if (columnIndex == 1) {
            return "As Int";
        }
        if (columnIndex == 2) {
            return "As Ref";
        }
        if (columnIndex == 3) {
            return "Label";
        }
        if (columnIndex == 4) {
            return "Comment";
        }
        throw new AssertionError();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        MemoryCell cell = (MemoryCell)this.rows.get(rowIndex);
        if (columnIndex == 0) {
            return new Integer(cell.getAddress());
        }
        if (columnIndex == 1) {
            return new Value(this.memory.normalizeEndianness((int)cell.getValue().getValue(), cell.length()));
        }
        if (columnIndex == 2) {
            String label = ((Datum)cell).valueAsLabel();
            return label != null ? label : "";
        }
        if (columnIndex == 3) {
            return new Region.LabelString(this, cell.getAddress(), cell.getLabel());
        }
        if (columnIndex == 4) {
            return cell.getComment();
        }
        throw new AssertionError();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        if (columnIndex == 1) {
            return true;
        }
        if (columnIndex == 2) {
            return false;
        }
        if (columnIndex == 3) {
            return true;
        }
        if (columnIndex == 4) {
            return true;
        }
        throw new AssertionError();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.getRowCount()) {
            MemoryCell cell = (MemoryCell)this.rows.get(rowIndex);
            assert (cell != null);
            if (columnIndex == 1) {
                int v = this.memory.normalizeEndianness(((Value)aValue).toNumber(), cell.length());
                Object[] b = new Byte[cell.length()];
                for (int i = b.length - 1; i >= 0; --i) {
                    b[i] = (byte)v;
                    v >>= 8;
                }
                boolean changed = false;
                for (int i = 0; i < b.length; ++i) {
                    if ((Byte)this.memory.getValueAt(cell.getAddress() + i, 1) == b[i]) continue;
                    changed = true;
                    break;
                }
                if (changed) {
                    this.memory.addUndo(new Region.UndoChange(this, String.format("Value Change at 0x%x\n", cell.getAddress()), rowIndex, 0, Region.UndoChangeType.VALUE));
                    this.memory.setValueAtByUser(b, cell.getAddress(), 1);
                }
            } else if (columnIndex == 3) {
                String newValue = ((Region.LabelString)aValue).toString().trim();
                if (!newValue.equals(cell.getLabel())) {
                    this.memory.addUndo(new Region.UndoChange(this, String.format("Label Change at 0x%x\n", cell.getAddress()), rowIndex, 2, Region.UndoChangeType.LABEL));
                    cell.setLabel(newValue);
                    this.memory.setChanged(true);
                }
            } else if (columnIndex == 4) {
                String newValue = ((String)aValue).trim();
                if (!newValue.equals(cell.getComment())) {
                    this.memory.addUndo(new Region.UndoChange(this, String.format("Comment Change at 0x%x\n", cell.getAddress()), rowIndex, 3, Region.UndoChangeType.COMMENT));
                    cell.setComment(newValue);
                    this.memory.setChanged(true);
                }
            } else {
                throw new AssertionError();
            }
        }
    }

    public class Value {
        Integer value;

        Value(Integer aValue) {
            this.value = aValue;
        }

        public String toString() {
            return this.value.toString();
        }

        public Integer toNumber() {
            return this.value;
        }

        public void setValue(String text) {
            this.setValue(text, 10);
        }

        public void setValue(String text, int radix) {
            if (text.matches("\\s*-?[0-9]+\\s*")) {
                this.value = Integer.valueOf(text, radix);
            } else if (text.matches("\\s*-?0x[0-9,a-f,A-F]+\\s*")) {
                this.value = Integer.valueOf(text.split("0x", 2)[1], 16);
            } else {
                Integer v = (Integer)DataRegion.this.memory.getLabelMap().reverseGet(text);
                if (v != null) {
                    this.value = v;
                } else {
                    throw new NumberFormatException();
                }
            }
        }
    }
}

