/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.StringTokenizer;
import jline.Terminal;

public class UnixTerminal
extends Terminal {
    public static final short ARROW_START = 27;
    public static final short ARROW_PREFIX = 91;
    public static final short ARROW_LEFT = 68;
    public static final short ARROW_RIGHT = 67;
    public static final short ARROW_UP = 65;
    public static final short ARROW_DOWN = 66;
    public static final short O_PREFIX = 79;
    public static final short HOME_CODE = 72;
    public static final short END_CODE = 70;
    public static final short DEL_THIRD = 51;
    public static final short DEL_SECOND = 126;
    private Map terminfo;
    private boolean echoEnabled;
    private String ttyConfig;
    private boolean backspaceDeleteSwitched = false;
    private static String sttyCommand = System.getProperty("jline.sttyCommand", "stty");
    String encoding = System.getProperty("input.encoding", "UTF-8");
    ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(this.encoding);
    InputStreamReader replayReader;

    public UnixTerminal() {
        try {
            this.replayReader = new InputStreamReader((InputStream)this.replayStream, this.encoding);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void checkBackspace() {
        String[] ttyConfigSplit = this.ttyConfig.split(":|=");
        if (ttyConfigSplit.length < 7) {
            return;
        }
        if (ttyConfigSplit[6] == null) {
            return;
        }
        this.backspaceDeleteSwitched = ttyConfigSplit[6].equals("7f");
    }

    public void initializeTerminal() throws IOException, InterruptedException {
        this.ttyConfig = UnixTerminal.stty("-g");
        if (this.ttyConfig.length() == 0 || this.ttyConfig.indexOf("=") == -1 && this.ttyConfig.indexOf(":") == -1) {
            throw new IOException("Unrecognized stty code: " + this.ttyConfig);
        }
        this.checkBackspace();
        UnixTerminal.stty("-icanon min 1");
        UnixTerminal.stty("-echo");
        this.echoEnabled = false;
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void start() {
                    try {
                        UnixTerminal.this.restoreTerminal();
                    }
                    catch (Exception e2) {
                        UnixTerminal.this.consumeException(e2);
                    }
                }
            });
        }
        catch (AbstractMethodError ame) {
            this.consumeException(ame);
        }
    }

    public void restoreTerminal() throws Exception {
        if (this.ttyConfig != null) {
            UnixTerminal.stty(this.ttyConfig);
            this.ttyConfig = null;
        }
        UnixTerminal.resetTerminal();
    }

    public int readVirtualKey(InputStream in) throws IOException {
        int c2 = this.readCharacter(in);
        if (this.backspaceDeleteSwitched) {
            if (c2 == 127) {
                c2 = 8;
            } else if (c2 == 8) {
                c2 = 127;
            }
        }
        if (c2 == 27) {
            while (c2 == 27) {
                c2 = this.readCharacter(in);
            }
            if (c2 == 91 || c2 == 79) {
                c2 = this.readCharacter(in);
                if (c2 == 65) {
                    return 16;
                }
                if (c2 == 66) {
                    return 14;
                }
                if (c2 == 68) {
                    return 2;
                }
                if (c2 == 67) {
                    return 6;
                }
                if (c2 == 72) {
                    return 1;
                }
                if (c2 == 70) {
                    return 5;
                }
                if (c2 == 51) {
                    c2 = this.readCharacter(in);
                    return 127;
                }
            }
        }
        if (c2 > 128) {
            this.replayStream.setInput(c2, in);
            c2 = this.replayReader.read();
        }
        return c2;
    }

    private void consumeException(Throwable e2) {
    }

    public boolean isSupported() {
        return true;
    }

    public boolean getEcho() {
        return false;
    }

    public int getTerminalWidth() {
        int val = -1;
        try {
            val = UnixTerminal.getTerminalProperty("columns");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val == -1) {
            val = 80;
        }
        return val;
    }

    public int getTerminalHeight() {
        int val = -1;
        try {
            val = UnixTerminal.getTerminalProperty("rows");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val == -1) {
            val = 24;
        }
        return val;
    }

    private static int getTerminalProperty(String prop) throws IOException, InterruptedException {
        String props = UnixTerminal.stty("-a");
        StringTokenizer tok = new StringTokenizer(props, ";\n");
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken().trim();
            if (str.startsWith(prop)) {
                int index = str.lastIndexOf(" ");
                return Integer.parseInt(str.substring(index).trim());
            }
            if (!str.endsWith(prop)) continue;
            int index = str.indexOf(" ");
            return Integer.parseInt(str.substring(0, index).trim());
        }
        return -1;
    }

    private static String stty(String args) throws IOException, InterruptedException {
        return UnixTerminal.exec("stty " + args + " < /dev/tty").trim();
    }

    private static String exec(String cmd) throws IOException, InterruptedException {
        return UnixTerminal.exec(new String[]{"sh", "-c", cmd});
    }

    private static String exec(String[] cmd) throws IOException, InterruptedException {
        int c2;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Process p2 = Runtime.getRuntime().exec(cmd);
        InputStream in = p2.getInputStream();
        while ((c2 = in.read()) != -1) {
            bout.write(c2);
        }
        in = p2.getErrorStream();
        while ((c2 = in.read()) != -1) {
            bout.write(c2);
        }
        p2.waitFor();
        String result = new String(bout.toByteArray());
        return result;
    }

    public static void setSttyCommand(String cmd) {
        sttyCommand = cmd;
    }

    public static String getSttyCommand() {
        return sttyCommand;
    }

    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public synchronized void enableEcho() {
        try {
            UnixTerminal.stty("echo");
            this.echoEnabled = true;
        }
        catch (Exception e2) {
            this.consumeException(e2);
        }
    }

    public synchronized void disableEcho() {
        try {
            UnixTerminal.stty("-echo");
            this.echoEnabled = false;
        }
        catch (Exception e2) {
            this.consumeException(e2);
        }
    }

    static class ReplayPrefixOneCharInputStream
    extends InputStream {
        byte firstByte;
        int byteLength;
        InputStream wrappedStream;
        int byteRead;
        final String encoding;

        public ReplayPrefixOneCharInputStream(String encoding) {
            this.encoding = encoding;
        }

        public void setInput(int recorded, InputStream wrapped) throws IOException {
            this.byteRead = 0;
            this.firstByte = (byte)recorded;
            this.wrappedStream = wrapped;
            this.byteLength = 1;
            if (this.encoding.equalsIgnoreCase("UTF-8")) {
                this.setInputUTF8(recorded, wrapped);
            } else if (this.encoding.equalsIgnoreCase("UTF-16")) {
                this.byteLength = 2;
            } else if (this.encoding.equalsIgnoreCase("UTF-32")) {
                this.byteLength = 4;
            }
        }

        public void setInputUTF8(int recorded, InputStream wrapped) throws IOException {
            if ((this.firstByte & 0xFFFFFFE0) == -64) {
                this.byteLength = 2;
            } else if ((this.firstByte & 0xFFFFFFF0) == -32) {
                this.byteLength = 3;
            } else if ((this.firstByte & 0xFFFFFFF8) == -16) {
                this.byteLength = 4;
            } else {
                throw new IOException("invalid UTF-8 first byte: " + this.firstByte);
            }
        }

        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            ++this.byteRead;
            if (this.byteRead == 1) {
                return this.firstByte;
            }
            return this.wrappedStream.read();
        }

        public int available() {
            return this.byteLength - this.byteRead;
        }
    }
}

