/**
 * Pack finders help find information about a beast's pack. Every class
 * implementing IPackFinder should include a constructor that takes an
 * IBeastProvider. It should then find the pack from the universe of beasts
 * provided by the IBeastProvider.
 * 
 * @author CPSC 111 instructors
 */
public interface IPackFinder
{
    /**
	 * Get the pack of the provided beast.
	 * 
	 * @param beast
	 *            info about the beast whose pack we're constructing
	 * @return a non-null (but possibly empty) list of non-null BeastInfo
	 *         objects for the beasts in the given beast's pack. Note: the pack
	 *         may or may not contain the provided beast.
	 */
    BeastInfo[] getPack( BeastInfo beast );

    /**
     * Get the leader of the provided beast's pack (or null if no leader
     * exists). 
     * 
     * @param beast info about the beast whose pack leader we're finding
     * @return the leader of the given beast's pack, or null if no leader was
     *         found. Note: the leader may or may not be the provided beast.
     */
    BeastInfo getLeader( BeastInfo beast );
}
