/**
 * A dumb setup routine that just creates a couple of dumb beasts and a random
 * walker at random locations in random directions, with boring packs.
 * <p>
 * Create your OWN beast providers as setups to test your beasties and packs,
 * and make neat animations! Square dancing, synchronized swimming, marching
 * bands, crop circles?...
 * 
 * @author CPSC 111 instructors
 */
public class DumbSetup implements IBeastProvider {
	/**
	 * My sweet, dumb beasts.
	 */
	private Beast[] beasties;

	/**
	 * Create a dumb beast provider to set up a boring simulation.
	 * 
	 * @param width
	 *            the width of the simulation window
	 * @param height
	 *            the height of the simulation window
	 */
	public DumbSetup(int width, int height) {
		beasties = new Beast[3];
		beasties[0] = new Beast(new DumbBrain(), new AllBeastsPack(this));
		grooveBeastRandomly(beasties[0]);
		beasties[1] = new Beast(new DumbBrain(), new AllBeastsPack(this));
		grooveBeastRandomly(beasties[1]);
		beasties[2] = new Beast(new RandomWalkingBrain(), new AllBeastsPack(
				this));
		for (int i = 0; i < beasties.length; i++) {
			placeBeastRandomly(beasties[i], width, height);
		}
	}
	/**
	 * Set a beast's mood to random grooviness and maximum intensity.
	 * 
	 * @param beast The beast to emote
	 */
	private void grooveBeastRandomly(Beast beast) {
		double groove = Math.random()
				* (BeastMood.MAX_GROOVINESS - BeastMood.MIN_GROOVINESS)
				+ BeastMood.MIN_GROOVINESS;
		beast.setMood(new BeastMood(groove, BeastMood.MAX_INTENSITY));
	}

	/**
	 * Place a beast at a random location going a random direction
	 * 
	 * @param beast
	 *            The beast to place
	 * @param maxX
	 *            width range for location
	 * @param maxY
	 *            height range for location
	 */
	private void placeBeastRandomly(Beast beast, double maxX, double maxY) {
		double x, y, direction;

		x = Math.random() * maxX;
		y = Math.random() * maxY;
		direction = Math.random() * Direction.FULL_CIRCLE;

		beast.setLocation(x, y);
		beast.setDirection(direction);
	}

	/**
	 * Get the setup list of dumb beasts.
	 */
	public Beast[] getBeasts() {
		return beasties;
	}
}
