import acm.graphics.*;

/**
 * Manages a simulation group of beasts, handling their updating and providing
 * appropriate information to their pack finders.
 * 
 * @author CPSC 111 instructors
 */
public class BeastManager implements IBeastProvider
{
    /**
     * The graphical container in which the beasts' reside.
     */
    private GContainer beastContainer;

    /**
     * Create a new beast manager for the given container.
     * <p>
     * The container is used within BeastManager to store the set of beasts.
     * 
     * @param container a non-null container that's ready for a proliferation of
     *        beasts
     */
    public BeastManager( GContainer container )
    {
        this.beastContainer = container;
    }

    /**
     * Add the given beast to the set of managed beasts.
     * 
     * @param beast a non-null beast to add
     */
    public void addBeast( Beast beast )
    {
        this.beastContainer.add( beast );
    }

    /**
     * Remove the given beast from the set of managed beasts.
     * 
     * @param beast a non-null beast to remove
     */
    public void removeBeast( Beast beast )
    {
        this.beastContainer.remove( beast );
    }

    /**
     * Provide a list of the beasts managed.
     */
    public Beast[] getBeasts()
    {
        // Prepare space for the beasts.
        Beast[] beasts = new Beast[ this.beastContainer.getElementCount() ];
        int numBeasts = 0;

        // Find all the beasts.
        for( int i = 0; i < this.beastContainer.getElementCount(); i++ )
        {
            if( this.beastContainer.getElement( i ) instanceof Beast )
                beasts[ numBeasts++ ] = (Beast) this.beastContainer
                        .getElement( i );
        }

        // Copy into an array of the right size.
        if( numBeasts > beasts.length )
        {
            Beast[] tightBeastArray = new Beast[ numBeasts ];
            System.arraycopy( beasts, 0, tightBeastArray, 0, numBeasts );
            beasts = tightBeastArray;
        }

        return beasts;
    }

    /**
     * Update the state of all beasts in the simulation.
     */
    public void updateBeasts()
    {
        Beast[] beasts = this.getBeasts();

        for( int i = 0; i < beasts.length; i++ )
            beasts[ i ].update();
    }
}
