/**
 * A pack that just gives back all the beasts in the world.
 * 
 * @author CPSC 111 instructors
 */
public class AllBeastsPack implements IPackFinder {
	/**
	 * The provider that defines the "world" of beasts.
	 */
	private IBeastProvider beastProvider;
	
	/**
	 * Construct a new AllBeastsPack.
	 * 
	 * @param provider a non-null provider defining the world of beasts
	 *        available
	 */
	public AllBeastsPack(IBeastProvider provider) {
		this.beastProvider = provider;
	}
	
	/**
	 * Helper class that does all the work of fetching the beast info from the
	 * beasts.
	 * 
	 * @return a list of all the info for all the beasts in the world
	 */
	protected BeastInfo[] getAllInfo() {
		// Get the beast source
		Beast[] beasts = this.beastProvider.getBeasts();
		
		// The number of beast infos gathered so far.
		int numBeasts = 0;
		
		// An array to hold the selected beast infos.
		// For AllBeastsPack, ALL available BeastInfos will be used.
		// However, this code pattern works well for selecting just some of the BeastInfos.
		BeastInfo[] infos = new BeastInfo[beasts.length];
		
		for (int i = 0; i < beasts.length; i++) {
			infos[numBeasts++] = beasts[i].getInfo();
		}
		
		// Copy into an array of the right size, if necessary.
		if (numBeasts < infos.length) {
			BeastInfo[] newInfos = new BeastInfo[numBeasts];
			System.arraycopy(infos, 0, newInfos, 0, numBeasts);
			infos = newInfos;
		}
		
		return infos;
	}
	
	/**
	 * Return a pack of all the beasts in the world.
	 */
	public BeastInfo[] getPack(BeastInfo beast) {
		return this.getAllInfo();
	}
	
	/**
	 * Return the leader of the pack: whoever goes first. Note: this may be the
	 * same as the Beast requesting a pack. Returns null for an empty world.
	 */
	public BeastInfo getLeader(BeastInfo beast) {
		BeastInfo[] infos = this.getAllInfo();
		if (infos.length == 0)
			return null;
		
		return infos[0];
	}
}
