/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.HexInputStream;
import acm.util.JTFTools;
import acm.util.NullAudioClip;
import acm.util.SunAudioClip;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.StringTokenizer;

public class MediaTools {
    public static final String DEFAULT_IMAGE_PATH = ".:images";
    public static final String DEFAULT_AUDIO_PATH = ".:sounds";
    private static HashMap imageTable = new HashMap();
    private static HashMap audioClipTable = new HashMap();
    private static final Class RESOURCE_CLASS = new MediaTools().getClass();

    private MediaTools() {
    }

    public static Image loadImage(String string) {
        return MediaTools.loadImage(string, DEFAULT_IMAGE_PATH);
    }

    public static Image loadImage(String string, String string2) {
        Image image = (Image)imageTable.get(string);
        if (image != null) {
            return image;
        }
        if (string.endsWith(".gif")) {
            try {
                Class<?> clazz = Class.forName("images." + string.substring(0, string.length() - 4));
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("getImage", new Class[0]);
                return (Image)method.invoke(obj, new Object[0]);
            }
            catch (Exception exception) {}
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        while (image == null && stringTokenizer.hasMoreTokens()) {
            Object object;
            Object object2;
            String string3 = stringTokenizer.nextToken();
            string3 = string3.equals(".") ? "" : String.valueOf(string3) + "/";
            URL uRL = null;
            try {
                uRL = RESOURCE_CLASS.getResource("/" + string3 + string);
            }
            catch (Exception exception) {}
            if (uRL == null && (object2 = JTFTools.getApplet()) != null && (object = ((Applet)object2).getCodeBase()) != null) {
                try {
                    uRL = new URL((URL)object, String.valueOf(string3) + string);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (uRL == null) {
                try {
                    if (!new File(String.valueOf(string3) + string).canRead()) continue;
                    image = toolkit.getImage(String.valueOf(string3) + string);
                }
                catch (SecurityException securityException) {}
                continue;
            }
            try {
                object2 = uRL.openConnection();
                if (((URLConnection)object2).getContentLength() <= 0) continue;
                object = ((URLConnection)object2).getContent();
                if (object instanceof ImageProducer) {
                    image = toolkit.createImage((ImageProducer)object);
                    continue;
                }
                if (object == null) continue;
                image = toolkit.getImage(uRL);
            }
            catch (IOException iOException) {}
        }
        if (image == null) {
            throw new ErrorException("Cannot find an image named " + string);
        }
        MediaTools.loadImage(image);
        imageTable.put(string, image);
        return image;
    }

    public static Image loadImage(Image image) {
        MediaTracker mediaTracker = new MediaTracker(JTFTools.createEmptyContainer());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            throw new ErrorException("Image loading process interrupted");
        }
        return image;
    }

    public static void defineImage(String string, Image image) {
        imageTable.put(string, image);
    }

    public static void flushImage(String string) {
        imageTable.remove(string);
    }

    public static Image createImage(int[] nArray, int n, int n2) {
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }

    public static Image createImage(InputStream inputStream) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = inputStream.read();
            while (n != -1) {
                byteArrayOutputStream.write(n);
                n = inputStream.read();
            }
            return Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new ErrorException("Exception: " + exception);
        }
    }

    public static Image createImage(String[] stringArray) {
        return MediaTools.createImage(new HexInputStream(stringArray));
    }

    public static Component getImageObserver() {
        return JTFTools.createEmptyContainer();
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static AudioClip loadAudioClip(String string) {
        return MediaTools.loadAudioClip(string, DEFAULT_AUDIO_PATH);
    }

    public static AudioClip loadAudioClip(String string, String string2) {
        AudioClip audioClip = (AudioClip)audioClipTable.get(string);
        if (audioClip != null) {
            return audioClip;
        }
        if (string.endsWith(".au")) {
            try {
                Class<?> clazz = Class.forName("sounds." + string.substring(0, string.length() - 3));
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("getAudioClip", new Class[0]);
                return (AudioClip)method.invoke(obj, new Object[0]);
            }
            catch (Exception exception) {}
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        while (audioClip == null && stringTokenizer.hasMoreTokens()) {
            Object object;
            Object object2;
            String string3 = stringTokenizer.nextToken();
            string3 = string3.equals(".") ? "" : String.valueOf(string3) + "/";
            URL uRL = null;
            try {
                uRL = RESOURCE_CLASS.getResource("/" + string3 + string);
            }
            catch (Exception exception) {}
            if (uRL == null && (object2 = JTFTools.getApplet()) != null && (object = ((Applet)object2).getCodeBase()) != null) {
                try {
                    uRL = new URL((URL)object, String.valueOf(string3) + string);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (uRL == null) {
                try {
                    object2 = new File(String.valueOf(string3) + string);
                    if (!((File)object2).canRead()) continue;
                    audioClip = MediaTools.createAudioClip(new FileInputStream((File)object2));
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                object2 = uRL.openConnection();
                if (((URLConnection)object2).getContentLength() <= 0) continue;
                object = ((URLConnection)object2).getContent();
                if (object instanceof AudioClip) {
                    audioClip = (AudioClip)object;
                    continue;
                }
                if (!(object instanceof InputStream)) continue;
                audioClip = MediaTools.createAudioClip((InputStream)object);
            }
            catch (IOException iOException) {}
        }
        if (audioClip == null) {
            throw new ErrorException("Cannot find an audio clip named " + string);
        }
        audioClipTable.put(string, audioClip);
        return audioClip;
    }

    public static void defineAudioClip(String string, AudioClip audioClip) {
        audioClipTable.put(string, audioClip);
    }

    public static void flushAudioClip(String string) {
        audioClipTable.remove(string);
    }

    public static AudioClip createAudioClip(InputStream inputStream) {
        try {
            return new SunAudioClip(inputStream);
        }
        catch (Exception exception) {
            return new NullAudioClip();
        }
    }

    public static AudioClip createAudioClip(String[] stringArray) {
        return MediaTools.createAudioClip(new HexInputStream(stringArray));
    }

    public static InputStream getHexInputStream(String[] stringArray) {
        return new HexInputStream(stringArray);
    }
}

