/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.gui.TableLayout;
import acm.io.IOConsole;
import acm.io.IODialog;
import acm.io.IOModel;
import acm.program.DOSCommandLine;
import acm.program.ProgramAppletStub;
import acm.program.ProgramFrame;
import acm.program.ProgramMenuBar;
import acm.program.ProgramStartupListener;
import acm.program.ProgramWindowListener;
import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.Platform;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public abstract class Program
extends JApplet
implements IOModel,
Runnable,
MouseListener,
MouseMotionListener,
ActionListener {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    private static final int STARTUP_DELAY = 1000;
    private static final int STARTUP_CYCLE = 300;
    private static final int THREAD_BUFFER = 10;
    private static final int DEFAULT_X = 16;
    private static final int DEFAULT_Y = 40;
    private static final int DEFAULT_WIDTH = 754;
    private static final int DEFAULT_HEIGHT = 492;
    private Frame programFrame;
    private HashMap optionTable;
    private AppletStub appletStub;
    private String myTitle;
    private ProgramMenuBar myMenuBar;
    private HashMap parameterTable;
    private Component northBorder;
    private Component southBorder;
    private Component eastBorder;
    private Component westBorder;
    private JPanel northPanel;
    private JPanel southPanel;
    private JPanel eastPanel;
    private JPanel westPanel;
    private JPanel centerPanel;
    private IOConsole myConsole;
    private IODialog myDialog;
    private Object startupObject;
    private Thread mainThread;
    private Rectangle programBounds;
    private boolean started;
    private boolean shown;
    private boolean isAppletMode;
    private boolean macMenuBarFlag;

    protected Program() {
        JTFTools.registerApplet(this);
        this.shown = false;
        this.parameterTable = null;
        this.isAppletMode = false;
        this.macMenuBarFlag = true;
        this.myTitle = this.getClass().getName();
        this.myTitle = this.myTitle.substring(this.myTitle.lastIndexOf(".") + 1);
        this.appletStub = new ProgramAppletStub(this);
        this.setAppletStub(this.appletStub);
        Container container = this.getContentPane();
        this.initContentPane(container);
        this.setVisible(false);
        this.setConsole(this.createConsole());
        this.myDialog = this.createDialogIO();
        this.myDialog.setAssociatedConsole(this.myConsole);
        this.myMenuBar = this.createMenuBar();
    }

    public void run() {
    }

    public void init() {
    }

    public void print(String string) {
        this.getOutputModel().print(string);
    }

    public final void print(boolean bl) {
        this.print(String.valueOf(bl));
    }

    public final void print(char c) {
        this.print(String.valueOf(c));
    }

    public final void print(double d) {
        this.print(String.valueOf(d));
    }

    public final void print(float f) {
        this.print(String.valueOf(f));
    }

    public final void print(int n) {
        this.print(String.valueOf(n));
    }

    public final void print(long l) {
        this.print(String.valueOf(l));
    }

    public final void print(Object object) {
        this.print(String.valueOf(String.valueOf(object)));
    }

    public void println() {
        this.getOutputModel().println();
    }

    public void println(String string) {
        this.getOutputModel().println(string);
    }

    public final void println(boolean bl) {
        this.println(String.valueOf(bl));
    }

    public final void println(char c) {
        this.println(String.valueOf(c));
    }

    public final void println(double d) {
        this.println(String.valueOf(d));
    }

    public final void println(float f) {
        this.println(String.valueOf(f));
    }

    public final void println(int n) {
        this.println(String.valueOf(n));
    }

    public final void println(long l) {
        this.println(String.valueOf(l));
    }

    public final void println(Object object) {
        this.println(String.valueOf(String.valueOf(object)));
    }

    public void showErrorMessage(String string) {
        this.getDialog().showErrorMessage(string);
    }

    public final String readLine() {
        return this.readLine(null);
    }

    public String readLine(String string) {
        return this.getInputModel().readLine(string);
    }

    public final int readInt() {
        return this.readInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public final int readInt(int n, int n2) {
        return this.readInt(null, n, n2);
    }

    public final int readInt(String string) {
        return this.readInt(string, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int readInt(String string, int n, int n2) {
        return this.getInputModel().readInt(string, n, n2);
    }

    public final double readDouble() {
        return this.readDouble(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public final double readDouble(double d, double d2) {
        return this.readDouble(null, d, d2);
    }

    public final double readDouble(String string) {
        return this.readDouble(string, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public double readDouble(String string, double d, double d2) {
        return this.getInputModel().readDouble(string, d, d2);
    }

    public final boolean readBoolean() {
        return this.readBoolean(null);
    }

    public final boolean readBoolean(String string) {
        return this.readBoolean(string, "true", "false");
    }

    public boolean readBoolean(String string, String string2, String string3) {
        return this.getInputModel().readBoolean(string, string2, string3);
    }

    public boolean isAppletMode() {
        if (!this.started) {
            throw new ErrorException("You can't call isAppletMode from the constructor");
        }
        return this.isAppletMode;
    }

    public void setConsole(IOConsole iOConsole) {
        this.myConsole = iOConsole;
    }

    public IOConsole getConsole() {
        return this.myConsole;
    }

    public IODialog getDialog() {
        return this.myDialog;
    }

    public IOModel getInputModel() {
        return this.getConsole();
    }

    public IOModel getOutputModel() {
        return this.getConsole();
    }

    public BufferedReader getReader() {
        return this.getConsole().getReader();
    }

    public PrintWriter getWriter() {
        return this.getConsole().getWriter();
    }

    public JPanel getRegionPanel(String string) {
        if (string.equals(NORTH)) {
            return this.northPanel;
        }
        if (string.equals(SOUTH)) {
            return this.southPanel;
        }
        if (string.equals(WEST)) {
            return this.westPanel;
        }
        if (string.equals(EAST)) {
            return this.eastPanel;
        }
        if (string.equals(CENTER)) {
            return this.centerPanel;
        }
        throw new ErrorException("getRegionPanel: Illegal region " + string);
    }

    public void add(Component component, String string, Object object) {
        if (string.equals(NORTH)) {
            this.northPanel.add(component, object);
        } else if (string.equals(SOUTH)) {
            this.southPanel.add(component, object);
        } else if (string.equals(WEST)) {
            this.westPanel.add(component, object);
        } else if (string.equals(EAST)) {
            this.eastPanel.add(component, object);
        } else if (string.equals(CENTER)) {
            this.centerPanel.add(component, object);
        } else {
            throw new ErrorException("add: Illegal region " + string);
        }
    }

    public void addActionListeners() {
        this.addActionListeners(this.getContentPane());
    }

    public void setTitle(String string) {
        this.myTitle = string;
        if (this.programFrame != null) {
            this.programFrame.setTitle(string);
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    public ProgramMenuBar getMenuBar() {
        return this.myMenuBar;
    }

    public void start(String[] stringArray) {
        if (this.parameterTable == null) {
            this.parameterTable = Program.createParameterTable(stringArray);
        }
        if (this.getParent() == null) {
            this.initApplicationFrame();
        }
        this.validate();
        this.setVisible(true);
        Container container = this.getContentPane();
        if (this.programFrame != null) {
            this.programFrame.validate();
            if (container.getComponentCount() != 0) {
                ((Component)this.programFrame).setVisible(true);
                this.shown = true;
            }
            if (Platform.isWindows()) {
                this.circumventFrameSizeBug(this.programFrame, this.programBounds.getSize());
            }
        }
        this.started = true;
        this.init();
        if (this.programFrame != null && this.myMenuBar != null) {
            this.installMenuBar(this.myMenuBar, this.programFrame);
            this.myMenuBar.update();
        }
        this.validate();
        this.startRun();
    }

    public void exit() {
        if (!this.isAppletMode) {
            System.exit(0);
        }
    }

    public void pause(double d) {
        JTFTools.pause(d);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected Frame createProgramFrame() {
        ProgramFrame programFrame = new ProgramFrame(this.getTitle());
        programFrame.setLayout(new BorderLayout());
        return programFrame;
    }

    protected IOConsole createConsole() {
        return IOConsole.SYSTEM_CONSOLE;
    }

    protected IODialog createDialogIO() {
        return new IODialog(this.getContentPane());
    }

    public ProgramMenuBar createMenuBar() {
        return new ProgramMenuBar(this);
    }

    public Dimension getPreferredSize() {
        return this.computeProgramBounds().getSize();
    }

    public Dimension getSize() {
        Container container = this.getContentPane();
        if (container == null) {
            return super.getSize();
        }
        return container.getSize();
    }

    public Rectangle getBounds() {
        Container container = this.getContentPane();
        if (container == null) {
            return super.getBounds();
        }
        return container.getBounds();
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public String getParameter(String string) {
        String string2 = null;
        if (this.parameterTable != null) {
            string2 = (String)this.parameterTable.get(string.toLowerCase());
        }
        if (string2 != null) {
            return string2;
        }
        return super.getParameter(string);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public LayoutManager getLayout() {
        if (this.isRootPaneCheckingEnabled()) {
            return this.centerPanel.getLayout();
        }
        return super.getLayout();
    }

    public void setBackground(Color color) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.setBackground(color);
        }
        super.setBackground(color);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            if (object == null) {
                this.centerPanel.add(component, n);
            } else if (object.equals(NORTH)) {
                this.northPanel.add(component, n);
            } else if (object.equals(SOUTH)) {
                this.southPanel.add(component, n);
            } else if (object.equals(WEST)) {
                this.westPanel.add(component, n);
            } else if (object.equals(EAST)) {
                this.eastPanel.add(component, n);
            } else if (object.equals(CENTER)) {
                this.centerPanel.add(component, n);
            } else {
                this.centerPanel.add(component, object, n);
            }
            if (!this.shown && this.programFrame != null) {
                ((Component)this.programFrame).setVisible(true);
                this.shown = true;
            }
        } else {
            super.addImpl(component, object, n);
        }
    }

    public void remove(int n) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.remove(n);
        } else {
            super.remove(n);
        }
    }

    public void remove(Component component) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.remove(component);
        } else {
            super.remove(component);
        }
    }

    public void removeAll() {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.removeAll();
        } else {
            super.removeAll();
        }
    }

    public void validate() {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().validate();
        }
        super.validate();
    }

    public void repaint() {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().repaint();
        }
        super.repaint();
    }

    public final void start() {
        boolean bl = this.isAppletMode = this.getParent() != null;
        if (this.isAppletMode) {
            if (!this.started) {
                this.started = true;
                this.validate();
                this.setVisible(true);
                this.installProgramMenu(this.myMenuBar.createProgramMenu());
                this.myMenuBar.update();
                this.mainThread = Thread.currentThread();
                this.startRun();
            }
        } else {
            this.start(null);
        }
    }

    public void destroy() {
        block2: {
            if (this.mainThread == null) break block2;
            try {
                Class<?> clazz = Class.forName("java.lang.Thread");
                Method method = clazz.getMethod("stop", new Class[0]);
                method.invoke((Object)this.mainThread, new Object[0]);
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] stringArray) {
        String string;
        HashMap hashMap = Program.createParameterTable(stringArray);
        String string2 = (String)hashMap.get("code");
        Class<?> clazz = null;
        Program program = null;
        if (string2 == null) {
            try {
                string2 = System.getProperty("java.main");
            }
            catch (Exception exception) {}
        }
        if (string2 == null) {
            string = Program.getCommandLine();
            string2 = Program.readMainClassFromCommandLine(string);
        }
        if (string2 != null) {
            if (string2.endsWith(".class")) {
                string2 = string2.substring(0, string2.length() - 6);
            }
            string2 = string2.replace('/', '.');
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz != null) {
            try {
                string = clazz.newInstance();
                if (string instanceof Program) {
                    program = (Program)((Object)string);
                    program.setStartupObject(null);
                } else {
                    string2 = (String)hashMap.get("program");
                    if (string2 == null) {
                        throw new ErrorException("Main class does not specify a program");
                    }
                    program = (Program)Class.forName(string2).newInstance();
                    program.setStartupObject(string);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (program == null) {
            throw new ErrorException("Cannot determine the main class.");
        }
        program.setParameterTable(hashMap);
        program.start();
    }

    public void menuAction(String string) {
        IOConsole iOConsole = this.myConsole;
        if (this.myMenuBar != null && (iOConsole = this.myMenuBar.getConsole()) == null) {
            iOConsole = this.myConsole;
        }
        if (iOConsole == null) {
            return;
        }
        if (string.equals("Quit")) {
            this.exit();
        } else if (string.equals("Print")) {
            Frame frame = JTFTools.getEnclosingFrame(this);
            if (frame == null) {
                return;
            }
            PrintJob printJob = frame.getToolkit().getPrintJob(frame, this.myTitle, null);
            if (printJob == null) {
                return;
            }
            frame.printAll(printJob.getGraphics());
            printJob.end();
        } else if (string.equals("Cut")) {
            iOConsole.cut();
        } else if (string.equals("Copy")) {
            iOConsole.copy();
        } else if (string.equals("Paste")) {
            iOConsole.paste();
        } else if (string.equals("Select All")) {
            iOConsole.selectAll();
        } else if (string.equals("Save")) {
            iOConsole.save();
        } else if (string.equals("Save As")) {
            iOConsole.saveAs();
        } else if (string.equals("Script")) {
            iOConsole.script();
        } else if (string.equals("Print Console")) {
            iOConsole.printConsole();
        }
    }

    public boolean updateMenuItem(JMenuItem jMenuItem) {
        IOConsole iOConsole = this.myConsole;
        if (this.myMenuBar != null && (iOConsole = this.myMenuBar.getConsole()) == null) {
            iOConsole = this.myConsole;
        }
        if (iOConsole != null && iOConsole.updateMenuItem(jMenuItem)) {
            return true;
        }
        String string = jMenuItem.getActionCommand();
        if (string == null) {
            return false;
        }
        if (string.equals("Quit")) {
            jMenuItem.setEnabled(true);
            return true;
        }
        if (string.equals("Print")) {
            jMenuItem.setEnabled(this.getContentPane().getComponentCount() > 0);
            return true;
        }
        return false;
    }

    protected void setMacMenuBarFlag(boolean bl) {
        this.macMenuBarFlag = bl;
    }

    protected boolean getMacMenuBarFlag() {
        return this.macMenuBarFlag;
    }

    protected Component getBorder(String string) {
        if (string.equals(NORTH)) {
            return this.northBorder;
        }
        if (string.equals(SOUTH)) {
            return this.southBorder;
        }
        if (string.equals(EAST)) {
            return this.eastBorder;
        }
        if (string.equals(WEST)) {
            return this.westBorder;
        }
        throw new ErrorException("Illegal border specification - " + string);
    }

    protected String[] getArgumentArray() {
        return this.parameterTable == null ? null : (String[])this.parameterTable.get("ARGS");
    }

    protected boolean isStarted() {
        IOConsole iOConsole = this.getConsole();
        if (iOConsole == null) {
            return false;
        }
        if (iOConsole.getParent() == null) {
            return true;
        }
        Dimension dimension = iOConsole.getSize();
        return iOConsole.isShowing() && dimension.width != 0 && dimension.height != 0;
    }

    protected void startHook() {
    }

    protected void endHook() {
    }

    protected void setAppletStub(AppletStub appletStub) {
        this.appletStub = appletStub;
        this.setStub(appletStub);
    }

    protected AppletStub getAppletStub() {
        return this.appletStub;
    }

    protected void setParameterTable(HashMap hashMap) {
        this.parameterTable = hashMap;
    }

    protected HashMap getParameterTable() {
        return this.parameterTable;
    }

    protected void setStartupObject(Object object) {
        this.startupObject = object;
    }

    protected Object getStartupObject() {
        return this.startupObject;
    }

    protected static String getCommandLine() {
        switch (Platform.getPlatform()) {
            case 1: 
            case 2: {
                return Program.getShellCommandLine();
            }
            case 3: {
                return DOSCommandLine.getCommandLine();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startRun() {
        Object object;
        ProgramStartupListener programStartupListener = new ProgramStartupListener();
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane.isShowing()) {
            jRootPane.addComponentListener(programStartupListener);
            ((Component)jRootPane).validate();
            JTFTools.pause(1000.0);
            object = programStartupListener;
            synchronized (object) {
                while (!this.isStarted()) {
                    try {
                        programStartupListener.wait(300L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            ((Component)jRootPane).update(((Component)jRootPane).getGraphics());
        }
        jRootPane.setCursor(Cursor.getDefaultCursor());
        this.startHook();
        this.runHook();
        this.endHook();
        object = this.getContentPane();
        if (jRootPane.isShowing() && ((Container)object).getComponentCount() == 0) {
            this.exit();
        }
    }

    protected void runHook() {
        this.run();
    }

    protected static HashMap createParameterTable(String[] stringArray) {
        int n;
        Object object;
        if (stringArray == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < stringArray.length) {
            object = stringArray[n2];
            n = ((String)object).indexOf(61);
            if (n > 0) {
                String string = ((String)object).substring(0, n).toLowerCase();
                String string2 = ((String)object).substring(n + 1);
                hashMap.put(string, string2);
            } else {
                arrayList.add(object);
            }
            ++n2;
        }
        object = new String[arrayList.size()];
        n = 0;
        while (n < arrayList.size()) {
            object[n] = (String)arrayList.get(n);
            ++n;
        }
        hashMap.put("ARGS", object);
        return hashMap;
    }

    protected static String readMainClassFromCommandLine(String string) {
        if (string == null) {
            return null;
        }
        boolean bl = false;
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(33, 255);
            streamTokenizer.quoteChar(34);
            streamTokenizer.quoteChar(39);
            streamTokenizer.whitespaceChars(32, 32);
            streamTokenizer.whitespaceChars(9, 9);
            boolean bl2 = false;
            while (true) {
                int n = streamTokenizer.nextToken();
                String string2 = streamTokenizer.sval;
                switch (n) {
                    case -1: {
                        return null;
                    }
                    default: {
                        return null;
                    }
                    case -3: 
                    case 34: 
                    case 39: 
                }
                if (bl2) {
                    if (string2.startsWith("-")) {
                        if (string2.equals("-jar")) {
                            bl = true;
                            continue;
                        }
                        if (!string2.equals("-cp") && !string2.equals("-classpath")) continue;
                        streamTokenizer.nextToken();
                        continue;
                    }
                    if (bl) {
                        return Program.readMainClassFromManifest(string2);
                    }
                    return string2;
                }
                bl2 = true;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void initContentPane(Container container) {
        container.setLayout(new BorderLayout());
        this.northPanel = new JPanel();
        this.southPanel = new JPanel();
        this.eastPanel = new JPanel();
        this.westPanel = new JPanel();
        this.centerPanel = new JPanel();
        this.northPanel.setLayout(new TableLayout(1, 0, 5, 5));
        this.southPanel.setLayout(new TableLayout(1, 0, 5, 5));
        this.westPanel.setLayout(new TableLayout(0, 1, 5, 5));
        this.eastPanel.setLayout(new TableLayout(0, 1, 5, 5));
        this.centerPanel.setLayout(new GridLayout(1, 0));
        container.add((Component)this.northPanel, NORTH);
        container.add((Component)this.southPanel, SOUTH);
        container.add((Component)this.eastPanel, EAST);
        container.add((Component)this.westPanel, WEST);
        container.add((Component)this.centerPanel, CENTER);
    }

    private void addActionListeners(Component component) {
        if (this.isButton(component)) {
            if (!this.hasActionListener(component)) {
                try {
                    Class[] classArray = new Class[]{Class.forName("java.awt.event.ActionListener")};
                    Object[] objectArray = new Object[]{this};
                    Method method = component.getClass().getMethod("addActionListener", classArray);
                    method.invoke((Object)component, objectArray);
                }
                catch (Exception exception) {
                    throw new ErrorException(exception);
                }
            }
        } else if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this.addActionListeners(container.getComponent(n2));
                ++n2;
            }
        }
    }

    private boolean isButton(Component component) {
        if (component instanceof Button || component instanceof JButton) {
            return true;
        }
        try {
            return Class.forName("ButtonLike").isInstance(component);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean hasActionListener(Component component) {
        try {
            Class[] classArray = new Class[]{Class.forName("java.lang.Class")};
            Object[] objectArray = new Object[]{Class.forName("java.awt.event.ActionListener")};
            Method method = component.getClass().getMethod("getListeners", classArray);
            EventListener[] eventListenerArray = (EventListener[])method.invoke((Object)component, objectArray);
            return eventListenerArray.length > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void initApplicationFrame() {
        this.programFrame = this.createProgramFrame();
        ((ProgramAppletStub)this.appletStub).setFrame(this.programFrame);
        this.programFrame.add((Component)this, CENTER);
        this.programFrame.addWindowListener(new ProgramWindowListener());
        this.programBounds = this.computeProgramBounds();
        Insets insets = this.programFrame.getInsets();
        int n = this.programBounds.width + insets.left + insets.right;
        int n2 = this.programBounds.height + insets.top + insets.bottom;
        ((Component)this.programFrame).setBounds(this.programBounds.x, this.programBounds.y, n, n2);
    }

    private void installMenuBar(ProgramMenuBar programMenuBar, Frame frame) {
        if (Platform.isMac() && this.macMenuBarFlag) {
            frame.setMenuBar(programMenuBar.createMacMenuBar());
        } else {
            try {
                Class<?> clazz = frame.getClass();
                Class[] classArray = new Class[]{programMenuBar.getClass()};
                Object[] objectArray = new Object[]{programMenuBar};
                Method method = clazz.getMethod("setJMenuBar", classArray);
                method.invoke((Object)frame, objectArray);
            }
            catch (Exception exception) {
                frame.setMenuBar(programMenuBar.createMacMenuBar());
                frame.pack();
            }
        }
    }

    private void installProgramMenu(Menu menu) {
        Frame frame = JTFTools.getEnclosingFrame(this);
        MenuBar menuBar = new MenuBar();
        menuBar.add(menu);
        frame.setMenuBar(menuBar);
        frame.pack();
    }

    private int decodeSizeParameter(String string, int n, int n2) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            try {
                Class<?> clazz = this.getClass();
                Field field = clazz.getField("APPLICATION_" + string);
                Object object = field.get(null);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
                if (!(object instanceof String)) {
                    return n;
                }
                string2 = (String)object;
            }
            catch (Exception exception) {
                return n;
            }
        }
        if (string2.equals("*")) {
            string2 = "100%";
        }
        if (string2.endsWith("%")) {
            int n3 = Integer.parseInt(string2.substring(0, string2.length() - 1));
            return (int)Math.round((double)n3 / 100.0 * (double)n2);
        }
        return Integer.parseInt(string2);
    }

    private Rectangle computeProgramBounds() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.decodeSizeParameter("WIDTH", 754, dimension.width);
        int n2 = this.decodeSizeParameter("HEIGHT", 492, dimension.height);
        int n3 = this.decodeSizeParameter("X", n >= dimension.width ? 0 : 16, dimension.width);
        int n4 = this.decodeSizeParameter("Y", n2 >= dimension.height ? 0 : 40, dimension.height);
        return new Rectangle(n3, n4, n, n2);
    }

    private void circumventFrameSizeBug(Frame frame, Dimension dimension) {
        Container container = this.getContentPane();
        Dimension dimension2 = container.getSize();
        if (dimension.equals(dimension2)) {
            return;
        }
        Dimension dimension3 = frame.getSize();
        dimension3.width += dimension.width - dimension2.width;
        dimension3.height += dimension.height - dimension2.height;
        ((Component)frame).setSize(dimension3.width, dimension3.height);
        frame.validate();
    }

    private static String readMainClassFromManifest(String string) {
        try {
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry)));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.startsWith("Main-Class:")) {
                    return string2.substring("Main-Class:".length()).trim();
                }
                string2 = bufferedReader.readLine();
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String getShellCommandLine() {
        try {
            String string = Platform.isMac() ? "command" : "args";
            String[] stringArray = new String[]{"bash", "-c", "ps -p $PPID -o " + string};
            Process process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
            if (process.getErrorStream().read() != -1) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            bufferedReader.readLine();
            return bufferedReader.readLine();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

