/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.graphics.GCanvas;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.program.GObjectProgram;
import acm.program.GProgramListener;
import acm.program.Program;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;

public abstract class GraphicsProgram
extends Program {
    private static final int BORDER_PIXELS = 4;
    private GCanvas gc;
    private GProgramListener listener = new GProgramListener(this);

    protected GraphicsProgram() {
        this.gc = this.createGCanvas();
        this.gc.addMouseListener(this.listener);
        this.add((Component)this.gc, "Center");
        this.validate();
    }

    public void run() {
    }

    public void init() {
    }

    public GCanvas getGCanvas() {
        return this.gc;
    }

    public int getWidth() {
        return this.gc.getWidth();
    }

    public int getHeight() {
        return this.gc.getHeight();
    }

    public void add(GObject gObject) {
        this.gc.add(gObject);
    }

    public final void add(GObject gObject, double d, double d2) {
        this.add(gObject);
        gObject.setLocation(d, d2);
    }

    public final void add(GObject gObject, GPoint gPoint) {
        this.add(gObject);
        gObject.setLocation(gPoint);
    }

    public void remove(GObject gObject) {
        this.gc.remove(gObject);
    }

    public void removeAll() {
        this.gc.removeAll();
    }

    public int getElementCount() {
        return this.gc.getElementCount();
    }

    public GObject getElement(int n) {
        return this.gc.getElement(n);
    }

    public GObject getElementAt(double d, double d2) {
        return this.gc.getElementAt(d, d2);
    }

    public final GObject getElementAt(GPoint gPoint) {
        return this.getElementAt(gPoint.getX(), gPoint.getY());
    }

    public Iterator iterator() {
        return this.gc.iterator();
    }

    public Iterator iterator(int n) {
        return this.gc.iterator(n);
    }

    public void addMouseListeners() {
        this.gc.addMouseListener(this);
        this.gc.addMouseMotionListener(this);
    }

    public void waitForClick() {
        GraphicsProgram graphicsProgram = this;
        synchronized (graphicsProgram) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void repaint() {
        this.gc.repaint();
        super.repaint();
    }

    public void removeAllComponents() {
        super.removeAll();
    }

    public static void startGraphicsProgram(GObject gObject, String[] stringArray) {
        GObjectProgram gObjectProgram = new GObjectProgram();
        gObjectProgram.setStartupObject(gObject);
        gObjectProgram.start(stringArray);
    }

    protected GCanvas createGCanvas() {
        return new GCanvas();
    }

    protected void startHook() {
    }

    protected void endHook() {
        this.gc.repaint();
    }

    protected boolean isStarted() {
        if (this.gc == null || !super.isStarted()) {
            return false;
        }
        Dimension dimension = this.gc.getSize();
        return dimension != null && dimension.width != 0 && dimension.height != 0;
    }
}

