/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.io.IODialog;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.JTextField;

public class IntField
extends JTextField {
    private static final int PREFERRED_WIDTH = 60;
    private boolean exceptionOnError;
    private int minValue;
    private int maxValue;
    private String formatString;
    private DecimalFormat formatter;
    private IODialog dialog;

    public IntField() {
        this("", Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntField(int n) {
        this(String.valueOf(n), Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntField(int n, int n2) {
        this("", n, n2);
    }

    public IntField(int n, int n2, int n3) {
        this(String.valueOf(n), n2, n3);
    }

    private IntField(String string, int n, int n2) {
        this.setBackground(Color.white);
        this.setHorizontalAlignment(4);
        this.minValue = n;
        this.maxValue = n2;
        this.setText(string);
        this.exceptionOnError = false;
    }

    public int getValue() {
        int n;
        block7: {
            String string = this.getText();
            String string2 = null;
            n = 0;
            try {
                n = Integer.parseInt(string.trim());
                if (n >= this.minValue && n <= this.maxValue) break block7;
                string2 = "Value is outside the specified range";
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "Illegal integer format";
            }
            if (this.exceptionOnError) {
                throw new ErrorException(string2);
            }
            String string3 = "Enter an integer";
            if (this.minValue != Integer.MIN_VALUE) {
                string3 = this.maxValue != Integer.MAX_VALUE ? String.valueOf(string3) + " between " + this.minValue + " and " + this.maxValue : String.valueOf(string3) + " greater than " + this.minValue;
            } else if (this.maxValue != Integer.MAX_VALUE) {
                string3 = String.valueOf(string3) + " less than " + this.maxValue;
            }
            if (this.dialog == null) {
                this.dialog = new IODialog(this);
            }
            n = this.dialog.readInt(string3, this.minValue, this.maxValue);
        }
        this.setValue(n);
        return n;
    }

    public void setValue(int n) {
        String string = String.valueOf(n);
        if (this.formatter != null) {
            string = this.formatter.format(n);
        }
        this.setText(string);
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setFormat(String string) {
        this.formatString = string;
        this.formatter = string == null ? null : new DecimalFormat(string);
        try {
            this.setValue(Integer.parseInt(this.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setExceptionOnError(boolean bl) {
        this.exceptionOnError = bl;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public Dimension getPreferredSize() {
        return new Dimension(60, super.getPreferredSize().height);
    }
}

