function [] = prettyPlot(xData,yData,options)
% prettyPlot(xData,yData,options)
%
% available options: 
% - legendStr
% - plotTitle
% - xlabel
% - ylabel
% - lineWidth
% - colors
% - lineStyles
% - markers
% - logScale
% - legendLoc
% - useLines
% - fillFace

if nargin < 3
    options = [];
end

[legendStr,plotTitle,plotXlabel,plotYlabel,lineWidth,colors,lineStyles,markers,logScale,legendLoc,errors,useLines,fillFace] = ...
    myProcessOptions(options,'legendStr',[],'plotTitle',[],'xlabel',[],'ylabel',[],...
    'lineWidth',3,'colors',[],'lineStyles',{'-','-','-','-','-','-','-','-','-','-'},...
    'markers',[],'logScale',0,'legendLoc','Best','errors',[],'useLines',1,'fillFace',1);

if logScale == 1
    plotFunc = @semilogx;
elseif logScale == 2
    plotFunc = @semilogy;
else
    plotFunc = @plot;
end

if useLines == 0
    defaultStyle = 'b.';
else
    defaultStyle = 'b';
end

if isempty(xData)
    for i = 1:length(yData)
        h(i) = plotFunc(1:length(yData{i}),yData{i},defaultStyle);

        applyStyle(h(i),i,colors,lineStyles,markers,lineWidth,useLines,fillFace);
        hold on;
    end
elseif iscell(xData)
    for i = 1:length(yData)
        h(i) = plotFunc(xData{i}-xData{i}(1),yData{i},defaultStyle);

        applyStyle(h(i),i,colors,lineStyles,markers,lineWidth,useLines,fillFace)
        hold on;
    end
elseif iscell(yData)
    for i = 1:length(yData)
        if length(yData{i}) >= length(xData)
            h(i) = plotFunc(xData,yData{i}(1:length(xData)),defaultStyle);
        else
            if isscalar(yData{i})
                h(i) = hline(yData{i},'b.');
            else
                h(i) = plotFunc(xData(1:length(yData{i})),yData{i},defaultStyle);
            end
        end
        applyStyle(h(i),i,colors,lineStyles,markers,lineWidth,useLines,fillFace)
        hold on;
    end
else
    for i = 1:size(yData,2)
        h(i) = plotFunc(xData,yData(:,i),defaultStyle);

        applyStyle(h(i),i,colors,lineStyles,markers,lineWidth,useLines,fillFace)
        hold on;
    end
end

set(gca,'FontName','AvantGarde','FontWeight','normal','FontSize',12);

if ~isempty(legendStr)
    h = legend(h,legendStr);
    set(h,'FontSize',10,'FontWeight','normal');
    set(h,'Location','Best');
    set(h,'Location',legendLoc);
end

if ~isempty(errors)
    errorColors = min(1,colors+.75);
    errorMarkers = [];
    errorStyles = lineStyles;
    errorWidth = 1;
    for i = 1:length(yData)
        h(i) = plotFunc(xData,yData{i}(1:length(xData))+errors{i}(1:length(xData)),defaultStyle);
        applyStyle(h(i),i,errorColors,errorStyles,errorMarkers,errorWidth,useLines,fillFace);
        h(i) = plotFunc(xData,yData{i}(1:length(xData))-errors{i}(1:length(xData)),defaultStyle);
        applyStyle(h(i),i,errorColors,errorStyles,errorMarkers,errorWidth,useLines,fillFace);
    end
end

if ~isempty(plotTitle)
h = title(plotTitle);
set(h,'FontName','AvantGarde','FontSize',10,'FontWeight','bold');
end

if ~isempty(plotXlabel) || ~isempty(plotYlabel)
h1 = xlabel(plotXlabel);
h2 = ylabel(plotYlabel);
set([h1 h2],'FontName','AvantGarde','FontSize',14,'FontWeight','normal');
end

set(gca, ...
    'Box'         , 'on'     , ...
    'TickDir'     , 'out'     , ...
    'TickLength'  , [.02 .02] , ...
    'XMinorTick'  , 'off'      , ...
    'YMinorTick'  , 'off'      , ...
    'LineWidth'   , 1         );
%    'YGrid'       , 'on'      , ...
%     'XColor'      , [.3 .3 .3], ...
%     'YColor'      , [.3 .3 .3], ...

set(gcf, 'PaperPositionMode', 'auto');

end

function [] = applyStyle(h,i,colors,lineStyles,markers,lineWidth,useLines,fillFace)
if ~isempty(colors)
    if iscell(colors)
        set(h,'Color',colors{i},'LineWidth',lineWidth);
    else
        set(h,'Color',colors(i,:),'LineWidth',lineWidth);
    end
end
if ~isempty(lineStyles) && useLines
    if ~isempty(lineStyles{i})
        set(h,'LineStyle',lineStyles{i});
    end
end
if ~isempty(markers)
    set(h,'Marker',markers{i});
    set(h,'MarkerSize',12);
    %set(h,'MarkerSize',10);

    if fillFace
    if ~isempty(lineStyles)
        if ~isempty(lineStyles{i})
            set(h,'MarkerFaceColor',[1 1 .9]);
        end
    else
        set(h,'MarkerFaceColor',[1 1 .9]);
    end
    end
else
    set(h,'MarkerSize',2);
end
end