function [adj] = graphLearn_DAG(Y,options)
% [adj] = graphLearn_optDAG(Y,options)

if nargin < 2
    options = [];
end

[nInstances,nNodes] = size(Y);

[likelihood,select,nStates,clamped,CPDoptions] = myProcessOptions(options,...
    'likelihood','Gaussian','select','AIC','nStates',[],'clamped',[],'CPDoptions',[]);

scoreMatrix = inf(nNodes,2^nNodes);

potentialParents = zeros(nNodes,1); % Set of potential parents
i = 1;
while 1
    if mod(i,10) == 0
       fprintf('Evaluating Parent Configuration %d of %d\n',i,2^nNodes);
    end
    
    for n = 1:nNodes
        if potentialParents(n) == 0 % Compute score if n is not in the parent set
            parents = find(potentialParents==1);
            scoreMatrix(n,i) = graphLearn_fitCPD(Y,n,parents,likelihood,select,nStates,clamped,CPDoptions);
        end
    end

    % Go to next configuration
    for n = 1:nNodes
        if potentialParents(n) == 0
            potentialParents(n) = 1;
            break;
        else
            potentialParents(n) = 0;
        end
    end

    if all(potentialParents==0)
        break;
    end
    i = i + 1;
end

adj = computeOptimalDag(-scoreMatrix);
