function [f,g] = UGM_conditionLoss(wv,Xnode,Xedge,y,edgeStruct,infoStruct,clamped,inferFunc,varargin)
% Computes loss and gradient when we observe the values of 'y'
% that correspond to 1's in the indicator matrix 'clamped'
%
% Code assumes:
%   - the model is an MRF (X and Xedge only contain a bias)
%   - only 1 node set by intervention per training example

[nInstances,nNodeFeatures,nNodes] = size(Xnode);
edgeEnds = edgeStruct.edgeEnds;
nEdges = size(edgeEnds,1);
tieNodes = infoStruct.tieNodes;
tieEdges = infoStruct.tieEdges;
ising = infoStruct.ising;
nStates = edgeStruct.nStates;

interventions = unique(clamped,'rows');
nInterventions = size(interventions,1);

[w,v] = UGM_splitWeights(wv,infoStruct);

nodePot = UGM_makeCRFNodePotentials(Xnode(1,:,:),w,edgeStruct,infoStruct);
edgePot = UGM_makeCRFEdgePotentials(Xedge(1,:,:),v,edgeStruct,infoStruct);

f = 0;
if nargout > 1
    gw = zeros(size(w));
    gv = zeros(size(v));
    g = [gw(:);gv(:)];
end

for interv = 1:nInterventions
    if all(interventions(interv,:)==0)
        % Case of no intervention
        %fprintf('No intervention\n');

        intervNdx = find(all(clamped==zeros(nInstances,nNodes),2));
        if nargout > 1
            [fSub,g] = UGM_MRFLoss(wv,y(intervNdx,:),edgeStruct,infoStruct,@UGM_Infer_Exact);
            f = f + fSub;
        else
            f = f + UGM_MRFLoss(wv,y(intervNdx,:),edgeStruct,infoStruct,@UGM_Infer_Exact);
        end
    else
        target = find(interventions(interv,:)==1);
        %fprintf('Intervention on %d\n',target);
        intervValues = unique(y(clamped(:,target)==1,target));
        for t = 1:length(intervValues)
            %fprintf('Processing Target = %d\n',intervValues(t));

            cond = zeros(nNodes,1);
            cond(target) = intervValues(t);
            intervNdx = find(clamped(:,target)==1 & y(:,target)==intervValues(t));
            %f = f + UGM_Loss(wv,Xnode(intervNdx,:,:),Xedge(intervNdx,:,:),y(intervNdx,:),edgeStruct,infoStruct,@UGM_Infer_Conditional,cond,@UGM_Infer_Exact);

            % Compute
            [nodePotC,edgePotC,edgeStructC] = UGM_makeClampedPotentials(nodePot, edgePot, edgeStruct, cond);
            [nodeBelC,edgeBelC,logZC] = UGM_Infer_Conditional(nodePot,edgePot,edgeStruct,cond,@UGM_Infer_Exact);

            % Update objective
            for i = intervNdx'
                logPotC = UGM_LogConfigurationPotential(y(i,[1:target-1 target+1:end]),nodePotC,edgePotC,edgeStructC.edgeEnds);
                %logPotC = UGM_LogConfigurationPotential(y(i,:),nodePotC,edgePotC,edgeStructC.edgeEnds);
                f = f - logPotC + logZC;

                if nargout > 1
                    % Update gw and gv in-place
                    UGM_updateGradientC(gw,gv,Xnode(i,:,:),Xedge(i,:,:),y(i,:),nodeBelC,edgeBelC,int32(nStates),int32(tieNodes),int32(tieEdges),int32(ising),int32(edgeEnds));

                end
            end
        end
    end
end

if nargout > 1
    gw = gw(infoStruct.wLinInd);
    gv = gv(infoStruct.vLinInd);
    g = g+[gw(:);gv(:)];
drawnow;
end

