function [] = DCG_exp(dataName,nSamples,nNodes,nStates,seed,doDAG)

nFolds = 1;
lambdaValues = 2.^[8:-1:-8];

if nargin < 6
    doDAG = 0;
end
doUGM = 1;
doDCG = 1;

%% Get data

[y,clamped] = DCG_getData(dataName,nSamples,nNodes,nStates,seed);
clampedMatrix = clamped;
clampedMatrix(clamped~=0) = y(clamped~=0);

%%

% Split samples into training and testing
perm = randperm(nSamples);
ndx1 = perm(1:floor(2*nSamples/3));
ndx2 = perm(floor(2*nSamples/3)+1:end);

if doDAG % DAG model
    dagOptions.likelihood = 'Softmax';
    dagOptions.nStates = repmat(nStates,[nNodes 1]);
    dagOptions.clamped = clamped(ndx1,:);
    dagOptions.select = 'RegObj'; % Regularized Objective Function
    
    for i = 1:length(lambdaValues)
        lambda = lambdaValues(i)
        
        CPDoptions.lambdaGL1 = lambda;
        dagOptions.CPDoptions = CPDoptions;
        
        adjDAG = graphLearn_DAGoptimal(y(ndx1,:),dagOptions);
        
        for n = 1:nNodes
            [score,model] = graphLearn_fitCPD(y(ndx1,:),n,find(adjDAG(:,n)),'Softmax','Train',repmat(nStates,[nNodes 1]),clamped(ndx1,:),CPDoptions);
            NLL(n) = model.testNLL(model,y(ndx2,:),n,find(adjDAG(:,n)),repmat(nStates,[nNodes 1]),clamped(ndx2,:));
        end
        DAGTestNLL(i,1) = sum(NLL)
    end
end

if doUGM % UG-observe and UG-condition models
    
    % Set up training and testing objectives
    adj = setdiag(ones(nNodes),0);
    edgeStruct = UGM_makeEdgeStruct(adj,nStates,1,250);
    nEdges = edgeStruct.nEdges;
    Xnode = ones(nSamples,1,nNodes);
    Xedge = ones(nSamples,1,nEdges);
    infoStruct = UGM_makeMRFInfoStruct(edgeStruct,0,0);
    [w,v] = UGM_initWeights(infoStruct,@zeros);
    funObj = @(wv)UGM_MRFLoss(wv,y(ndx1,:),edgeStruct,infoStruct,@UGM_Infer_Exact);
    funObjTest = @(wv)UGM_conditionLoss(wv,Xnode(ndx2,:,:),Xedge(ndx2,:,:),y(ndx2,:),edgeStruct,infoStruct,clamped(ndx2,:),@UGM_Infer_Exact);
    
    % Make groups for group-L1
    nodeGroups = zeros(size(w));
    edgeGroups = zeros(size(v));
    for e = 1:nEdges
        edgeGroups(:,:,e) = e;
    end
    groups = [nodeGroups(:);edgeGroups(:)];
    
    % Add 'small' L2-regularization to make solution unique
    wrapFunObj = @(w)penalizedL2(w,funObj,1e-4);
    
    % Solve problem for various values of the regularization parameter (using PQN)
    options.mode = 'pqn';
    options.optTol = 1e-3;
    options.progTol = 1e-6;
    options.SPGiters = 100;
    wv = [w(:);v(:)];
    for i = 1:length(lambdaValues)
        lambda = lambdaValues(i)
        
        wv = L1groupMinConF(wrapFunObj,wv,groups,lambda,options);
        UGobserveTestNLL(i,1) = funObjTest(wv)
    end
    
    wv = [w(:);v(:)];
    for i = 1:length(lambdaValues)
        lambda = lambdaValues(i)
        
        funObj_cond = @(wv)UGM_conditionLoss(wv,Xnode(ndx1,:,:),Xedge(ndx1,:,:),y(ndx1,:),edgeStruct,infoStruct,clamped(ndx1,:),@UGM_Infer_Exact);
        wrapFunObj = @(w)penalizedL2(w,funObj_cond,1e-4);
        wv2 = L1groupMinConF(wrapFunObj,wv,groups,lambda,options);
        UGconditionTestNLL(i,1) = funObjTest(wv2)
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%

if doDCG % DCG model
    
    adj = setdiag(ones(nNodes),0);
    edgeEnds = DCG_makeEdgeEnds(adj);
    nEdges = size(edgeEnds,1);
    
    [bias,weights] = DCG_initWeights(nNodes,edgeEnds,nStates);
    
    nodeGroups = zeros(size(bias));
    edgeGroups = zeros(size(weights));
    for e = 1:nEdges
        edgeGroups(:,:,e) = e;
    end
    groups = [nodeGroups(:);edgeGroups(:)];
    
    funObj = @(w)DCG_nll(y(ndx1,:),nNodes,edgeEnds,nStates,w,1);
    funObjTest = @(w)DCG_intervNLL2(clampedMatrix(ndx2,:),y(ndx2,:),nNodes,edgeEnds,nStates,w,1);
    
    options.mode = 'pqn';
    options.optTol = 1e-3;
    options.progTol = 1e-6;
    options.SPGiters = 100;
    w = [bias(:);weights(:)];
    for i = 1:length(lambdaValues)
        lambda = lambdaValues(i)
        
        funObjInterv = @(w)DCG_intervNLL2(clampedMatrix(ndx1,:),y(ndx1,:),nNodes,edgeEnds,nStates,w,1);
        wrapFunObj = @(w)penalizedL2(w,funObjInterv,1e-4);
        w = L1groupMinConF(wrapFunObj,w,groups,lambda,options);
        DCGTestNLL(i,1) = funObjTest(w)
    end
end
options.logScale = 1;
    options.xlabel = 'regularization parameter (\lambda)';
    options.ylabel = 'test set negative log-likelihood';
    options.lineWidth = 3;
    options.fillFace = 1;
    options.legendLoc = 'NorthWest';
if doDAG
    [DCGTestNLL UGconditionTestNLL UGobserveTestNLL DAGTestNLL]
    
    options.legendStr = {'DCG','UG-Condition','UG-Observe','DAG'};
    options.colors = .5*[1 0 0
        0 1 0
        0 0 1 
        0 1 1];
    options.markers = {'o','s','d','v'};
    prettyPlot3(lambdaValues,[DCGTestNLL UGconditionTestNLL UGobserveTestNLL DAGTestNLL],options);
else
    [DCGTestNLL UGconditionTestNLL UGobserveTestNLL]
    
    options.legendStr = {'DCG','UG-Condition','UG-Observe'};
    options.colors = .5*[1 0 0
        0 1 0
        0 0 1];
    options.markers = {'o','s','d'};
    prettyPlot3(lambdaValues,[DCGTestNLL UGconditionTestNLL UGobserveTestNLL],options);
end
    xlim([min(lambdaValues)-eps max(lambdaValues)+eps]);
end
