function samples = DCG_sample(nNodes,edgeEnds,nStates,bias,weights,nSamples,Z)

if nargin < 7
Z = DCG_computeZ(nNodes,edgeEnds,nStates,bias,weights);
end

samples = zeros(nSamples,nNodes);
for s = 1:nSamples
   u = rand;
   
   y = ones(1,nNodes);
   z = 0;
   while 1
       logPot = DCG_logPotential(nNodes,edgeEnds,nStates,y,bias,weights);
       z = z + exp(logPot);
       
       if z/Z > u
           samples(s,:) = y;
           break;
       end
       
       for n = 1:nNodes
           if y(n) < nStates
               y(n) = y(n)+1;
               break;
           else
               y(n) = 1;
           end
       end
       if all(y==1)
           error('No sample generated');
       end
   end
end