function [f,g] = DCG_nll(samples,nNodes,edgeEnds,nStates,w,useMex)

nSamples = size(samples,1);
nEdges = size(edgeEnds,1);

% Form weights
bias = reshape(w(1:nNodes*nStates),nNodes,nStates);
weights = reshape(w(nNodes*nStates+1:end),nStates,nStates,nEdges);

if ~useMex
    logZ = log(DCG_computeZ(nNodes,edgeEnds,nStates,bias,weights));
end

if useMex || nargout > 1
    % Compute derivative n*logZ
    if useMex
        [nodeBel,edgeBel,logZ] = DCG_inferC(int32(nNodes),int32(edgeEnds),int32(nStates),bias,weights);
    else
        Z = DCG_computeZ(nNodes,edgeEnds,nStates,bias,weights);
        [nodeBel,edgeBel] = DCG_infer(nNodes,edgeEnds,nStates,bias,weights,Z);
        logZ = log(Z);
    end
    gBias = nSamples*nodeBel;
    gWeights = nSamples*edgeBel;
end
f = nSamples*logZ;

for i = 1:nSamples
    logPot = DCG_logPotential(nNodes,edgeEnds,nStates,samples(i,:),bias,weights);
    f = f - logPot;

    if nargout > 1
        % Derivative of -logPot
        for n = 1:nNodes
            gBias(n,samples(i,n)) = gBias(n,samples(i,n)) - 1;
        end
        for e = 1:nEdges
            n1 = edgeEnds(e,1);
            n2 = edgeEnds(e,2);
            gWeights(samples(i,n1),samples(i,n2),e) = gWeights(samples(i,n1),samples(i,n2),e)-1;
        end
    end
end

if nargout > 1
    g = [gBias(:);gWeights(:)];
end