function samples = DCG_intervSample(clamped,nNodes,edgeEnds,nStates,bias,weights,nSamples,Z)

if nargin < 8
Z = DCG_intervComputeZ(clamped,nNodes,edgeEnds,nStates,bias,weights);
end

regulVars = find(clamped==0);

samples = zeros(nSamples,nNodes);
for s = 1:nSamples
   u = rand;
   
   y = ones(1,nNodes);
   y(clamped~=0) = clamped(clamped~=0);
   z = 0;
   while 1
       logPot = DCG_intervLogPotential(clamped,nNodes,edgeEnds,nStates,y,bias,weights);
       z = z + exp(logPot);
       
       if z/Z > u
           samples(s,:) = y;
           break;
       end
       
       for n = regulVars(:)'
           if y(n) < nStates
               y(n) = y(n)+1;
               break;
           else
               y(n) = 1;
           end
       end
       if all(y(regulVars)==1)
           error('No sample generated');
       end
   end
end