function [f,g] = DCG_nll(clampedMatrix,samples,nNodes,edgeEnds,nStates,w,useMex)
% This version allows a different intervention on each sample

nSamples = size(samples,1);

interventions = unique(clampedMatrix,'rows');
nInterventions = size(interventions,1);

f = 0;
if nargout > 1
    g = zeros(size(w));
end
for interv = 1:nInterventions
    clamped = interventions(interv,:);

    if all(clamped==0)
        intervNdx = find(sum(clampedMatrix,2) == 0);
    else
        intervNdx = zeros(0,1);
        for s = 1:nSamples
            if all(clamped(clamped~=0) == clampedMatrix(s,clamped~=0))
                intervNdx(end+1,1) = s;
            end
        end
    end

    if nargout > 1
        [fSub,gSub] = DCG_intervNLL(clamped,samples(intervNdx,:),nNodes,edgeEnds,nStates,w,useMex);
        f = f + fSub;
        g = g + gSub;
    else
        f = f + DCG_intervNLL(clamped,samples(intervNdx,:),nNodes,edgeEnds,nStates,w,useMex);
    end
end