function [nodeBel,edgeBel] = DCG_Infer(clamped,nNodes,edgeEnds,nStates,bias,weights,Z)

if nargin < 7
    Z = DCG_intervComputeZ(clamped,nNodes,edgeEnds,nStates,bias,weights);
end

regulVars = find(clamped==0);

nEdges = size(edgeEnds,1);
y = ones(nNodes,1);
y(clamped~=0) = clamped(clamped~=0);
nodeBel = zeros(nNodes,nStates);

if nargout > 1
    edgeBel = zeros(nStates,nStates,nEdges);
end

while 1
    logPot = DCG_intervLogPotential(clamped,nNodes,edgeEnds,nStates,y,bias,weights);

    for n = 1:nNodes
            nodeBel(n,y(n)) = nodeBel(n,y(n)) + exp(logPot);
    end

    if nargout > 1
        for e = 1:nEdges
            if ~clamped(edgeEnds(e,2))
                edgeBel(y(edgeEnds(e,1)),y(edgeEnds(e,2)),e) = edgeBel(y(edgeEnds(e,1)),y(edgeEnds(e,2)),e) + exp(logPot);
            end
        end
    end

    for n = regulVars(:)'
        if y(n) < nStates
            y(n) = y(n)+1;
            break;
        else
            y(n) = 1;
        end
    end
    if all(y(regulVars)==1)
        break;
    end
end

nodeBel = nodeBel/Z;
if nargout > 1
     edgeBel = edgeBel/Z;
end
