function [nodeBel,edgeBel] = DCG_Infer(nNodes,edgeEnds,nStates,bias,weights,Z)

if nargin < 6
    Z = DCG_computeZ(nNodes,edgeEnds,nStates,bias,weights);
end

nEdges = size(edgeEnds,1);
y = ones(nNodes,1);
nodeBel = zeros(nNodes,nStates);
if nargout > 1
    edgeBel = zeros(nStates,nStates,nEdges);
end
while 1
    logPot = DCG_logPotential(nNodes,edgeEnds,nStates,y,bias,weights);
    
    for n = 1:nNodes
       nodeBel(n,y(n)) = nodeBel(n,y(n)) + exp(logPot); 
    end
    
    if nargout > 1
        for e = 1:nEdges
        edgeBel(y(edgeEnds(e,1)),y(edgeEnds(e,2)),e) = edgeBel(y(edgeEnds(e,1)),y(edgeEnds(e,2)),e) + exp(logPot);
        end
    end
    
    for n = 1:nNodes
        if y(n) < nStates
            y(n) = y(n)+1;
            break;
        else
            y(n) = 1;
        end
    end
    if all(y==1)
        break;
    end
end

nodeBel = nodeBel/Z;
if nargout > 1
    edgeBel = edgeBel/Z;
end