function [y,clamped] = DCG_getData(dataName,nSamples,nNodes,nStates,seed)

adjProp = .5;

rand('state',seed);
randn('state',seed);
if strcmp(dataName,'DAG')
    % DAG w/ interventions
    fprintf('DAG data\n');
    options.likelihood = 'Softmax';
    options.probInt = nNodes/(nNodes+1);
    options.nStates = repmat(nStates,[nNodes 1]);
    [y,adjTrue,clamped] = DAG_sample(nSamples,nNodes,adjProp,options);
elseif strcmp(dataName,'hDAG')
    % DAG w/ hidden variables and interventions
    nHidden = nNodes;
    perm = randperm(nNodes+nHidden);
    visible = perm(1:nNodes);
    hidden = perm(nNodes+1:end);
    
    options.likelihood = 'Softmax';
    options.probInt = nNodes/(nNodes+1);
    options.nStates = repmat(nStates,[nNodes+nHidden 1]);
    options.intNodes = visible;
    
    [y,adjTrue,clamped] = DAG_sample(nSamples,nNodes+nHidden,adjProp,options);
    y = y(:,visible);
    clamped = clamped(:,visible);
    elseif strcmp(dataName,'hDAG2')
    % DAG w/ hidden variables and interventions
    nHidden = nNodes*2;
    perm = randperm(nNodes+nHidden);
    visible = perm(1:nNodes);
    hidden = perm(nNodes+1:end);
    
    options.likelihood = 'Softmax';
    options.probInt = nNodes/(nNodes+1);
    options.nStates = repmat(nStates,[nNodes+nHidden 1]);
    options.intNodes = visible;
    
    [y,adjTrue,clamped] = DAG_sample(nSamples,nNodes+nHidden,adjProp,options);
    y = y(:,visible);
    clamped = clamped(:,visible);
elseif strcmp(dataName,'UGM')
    % Pairwise UGM
    fprintf('UGM data\n');
    options.nStates = repmat(nStates,[nNodes 1]);
    options.ising = 0;

    [y,adjTrue] = UGM_sample(nSamples,nNodes,adjProp,options);
    clamped = zeros(size(y));
elseif strcmp(dataName,'DCG')
    fprintf('Generating DCG data...\n');
    adjTrue = rand(nNodes) > .5;
    adjTrue = double(setdiag(adjTrue,0));
    edgeEnds = DCG_makeEdgeEnds(adjTrue);
    [bias,weights] = DCG_initWeights(nNodes,edgeEnds,nStates,1);
    [y,clampedMatrix] = DCG_intervSample2(nNodes,edgeEnds,nStates,bias,weights,nSamples);
    clamped = sign(clampedMatrix);
elseif strcmp(dataName,'Sachs')
    fprintf('Sachs data\n');
    load sachsDiscretizedData;

    y = data';
    clamped = clamped';

    perm = randperm(5400);
    perm2= randperm(11);
    y = y(perm(1:nSamples),perm2(1:nNodes));
    clamped = clamped(perm(1:nSamples),perm2(1:nNodes));

    [nSamples,nNodes] = size(y);
    nStates = 3;
end