/*
 From: Mark Wing (markwing@pobox.com)
 Subject: Re: Help needed with Windows NT Registry... 
 Newsgroups: microsoft.public.vc.mfc
 Date: 1999/07/13 
*/
#include <windows.h>
// -----------------------------------------------------------------------------
// Create default security attributes.
// -----------------------------------------------------------------------------
BOOL GetSecurityAttributes(SECURITY_ATTRIBUTES *pSA)
{
   PSECURITY_DESCRIPTOR    pSD;

   // Clear passed structure first.
   ZeroMemory(pSA, sizeof(SECURITY_ATTRIBUTES));

   pSD = (PSECURITY_DESCRIPTOR)LocalAlloc(LPTR, SECURITY_DESCRIPTOR_MIN_LENGTH);

   // Validate pointer.
   if (pSD == NULL)
      return FALSE;

   if (!InitializeSecurityDescriptor(pSD, SECURITY_DESCRIPTOR_REVISION))
   {
      LocalFree((HLOCAL)pSD);
      return FALSE;
   }

   // Add a NULL desc. ACL to the security descriptor.
   if (!SetSecurityDescriptorDacl(pSD, TRUE, (PACL)NULL, FALSE))
   {
      LocalFree((HLOCAL)pSD);
      return FALSE;
   }

   // Set length of attributes.
   pSA->nLength = sizeof(SECURITY_ATTRIBUTES);

   // Set pointer to the descriptor.
   pSA->lpSecurityDescriptor = pSD;

   // Set the inheritance.
   pSA->bInheritHandle = FALSE;

   return TRUE;
}
// -----------------------------------------------------------------------------
// Free memory allocated creating security descriptor.
// -----------------------------------------------------------------------------
void ReleaseSecurityAttributes(SECURITY_ATTRIBUTES *pSA)
{
   if (pSA->lpSecurityDescriptor != NULL)
   {
	  LocalFree((HLOCAL)pSA->lpSecurityDescriptor);
   }
}
// -----------------------------------------------------------------------------
// Read a key from the registry
// -----------------------------------------------------------------------------
BOOL ReadRegValue(HKEY root, LPCTSTR strKey, LPCTSTR pszValName,
				  LPBYTE &lpData)
{
	HKEY hKey;
	DWORD dwSize = 0;

	lpData = NULL;
	if (RegOpenKeyEx(root,strKey,0,KEY_READ,&hKey) != ERROR_SUCCESS)
		return FALSE;
	// else
	if (RegQueryValueEx(hKey, pszValName, 0, NULL, NULL, &dwSize) !=
		ERROR_SUCCESS)
	{
		RegCloseKey(hKey);
		return FALSE;
	}
	// else
	lpData = new BYTE[dwSize];
	if (RegQueryValueEx(hKey, pszValName, 0, NULL, lpData, &dwSize) !=
		ERROR_SUCCESS)
	{
		RegCloseKey(hKey);
		delete [] lpData;
		lpData = NULL;
		return FALSE;
	}
	// else
	RegCloseKey(hKey);
	return TRUE;
}
// -----------------------------------------------------------------------------
// Write a key to the registry (as a string)
// -----------------------------------------------------------------------------
BOOL WriteRegValue(HKEY root, LPCTSTR strKey, LPCTSTR pszValName,
				   LPBYTE lpData)
{
	HKEY hKey;
	DWORD dwDispo;
	SECURITY_ATTRIBUTES sa;

	if (!GetSecurityAttributes(&sa))	return FALSE;

	if (RegCreateKeyEx(root, strKey, 0, NULL, REG_OPTION_NON_VOLATILE,
					   KEY_WRITE, &sa, &hKey, &dwDispo) == ERROR_SUCCESS)
	{
		if (RegSetValueEx(hKey, pszValName, NULL, REG_SZ, lpData,
						  strlen((char *)lpData)+1) == ERROR_SUCCESS)
		{
			RegCloseKey(hKey);
			ReleaseSecurityAttributes(&sa);
			return TRUE;
		}
		RegCloseKey(hKey);
	}
	ReleaseSecurityAttributes(&sa);
	return FALSE;
}

