//---------------------------------------------------------------------------
/*
	RunIEAs - Switches some registry settings to those of another user
	before running IE, then switches back when IE closes.
	For Win95/98/ME only (not NT/2000).

	by Rik Blok, 2002
	http://RikBlok.cjb.net

	Revisions
	v1.1b	May 10, 2002
		- fixed: menuorder registry key was being merged between users instead
		  of being replaced
	v1.1	June 18, 2001
		- if IE already running then just opens specified web page in
		current instance and immediately exits
	v1.0c	June 10, 2001
		- fixed: Favorites menu order was being lost
	v1.0b	June 5, 2001
		- fixed problem with extra command-line parameters
*/
//---------------------------------------------------------------------------
#include <dos.h>			// for _argc, _argv
#include <windows.h>
#pragma hdrstop
#include "reg.h"			// for ReadRegValue()
#include "EnumProc.h"		// for FindProcess()

#define USEUNIT(u)			// null definition for BCB project
USEUNIT("\My Documents\CBuilder\Library\reg.cpp");
USEUNIT("\My Documents\CBuilder\Library\EnumProc.cpp");
//---------------------------------------------------------------------------
#define mainFile	"main.reg"
#define mainKey 	"Software\\microsoft\\Internet Explorer\\Main"
#define foldersFile	"folders.reg"
#define foldersKey	"Software\\microsoft\\Windows\\CurrentVersion\\Explorer\\User Shell Folders"
#define menuOrderKey  "Software\\microsoft\\Windows\\CurrentVersion\\Explorer\\MenuOrder\\Favorites"
#define menuOrderFile "menuOrder.reg"

#define VERSION 1.1b			// May 10, 2002
//---------------------------------------------------------------------------
/*
HDDEDATA CALLBACK DdeCallback(UINT wType, UINT wFmt, HCONV hConv, HSZ hsz1,
							  HSZ hsz2, HDDEDATA hData, UINT dwData1,
							  UINT dwData2)
//	Used by (DDE version of) ShowURL().
{
	switch (wType)
	{
		case XTYP_ADVDATA:
			return (HDDEDATA) DDE_FACK;
		default:
			return (HDDEDATA) NULL;
	}
}
*/
//---------------------------------------------------------------------------
BOOL ShowURL (LPCTSTR pszURL)
/*
	Try to pass url to currently running instance of IE.
	Returns TRUE on success (IE found), else FALSE.

	Revisions:
	v1.1	June 18, 2001
		- new
*/
{
	// debugging
	// return FALSE;

	if (!FindProcess("iexplore.exe"))	return FALSE;
	// assume IE is default association for URLs
	ShellExecute(GetDesktopWindow(), "open", pszURL, NULL, NULL, SW_SHOWNORMAL);
	return TRUE;
/*
	// DDE attempt.  Had problem with DdeConnect() hanging sometimes.

	DWORD        dwDDEInst = 0;
	PFNCALLBACK pfnDdeCallback = (PFNCALLBACK)MakeProcInstance((FARPROC)DdeCallback, hInstance);
	UINT uiRC = DdeInitialize (&dwDDEInst, pfnDdeCallback, APPCMD_CLIENTONLY,
							   NULL);
	if (uiRC != DMLERR_NO_ERROR)	return FALSE;
	HSZ hszSvrAppName   = DdeCreateStringHandle (dwDDEInst, "iexplore",CP_WINANSI);
	HSZ hszSvrTopicName = DdeCreateStringHandle (dwDDEInst,"WWW_OpenURL" ,CP_WINANSI);
	HCONV hConv = DdeConnect(dwDDEInst, hszSvrAppName, hszSvrTopicName,
							 (PCONVCONTEXT)NULL);
	DdeFreeStringHandle(dwDDEInst, hszSvrTopicName);
	DdeFreeStringHandle(dwDDEInst, hszSvrAppName);
	if (hConv) {
		TCHAR sItem[MAX_PATH];
		strcpy(sItem,"\"");
		strcat(sItem,pszURL);
		strcat(sItem,"\",,-1,,,,");
		if (strlen(sItem)> 10) {	// ie. strlen(pszURL) > 0
			HSZ hszSvrItemName = DdeCreateStringHandle(dwDDEInst,sItem,CP_WINANSI);
			DdeClientTransaction(NULL, 0, hConv, hszSvrItemName, CF_TEXT,
								 XTYP_REQUEST, 2000, NULL);
			DdeFreeStringHandle(dwDDEInst, hszSvrItemName);
		}
			DdeDisconnect(hConv);
	}
	DdeUninitialize(dwDDEInst);
	return (hConv!=NULL);
*/
}
//---------------------------------------------------------------------------
LPTSTR GetUserNameX(void)
/*
	Returns the current user name.  It is the responsibility of the calling
	function to free the allocated space (eg. delete [] buff; ).
*/
{
	LPTSTR buff;
	DWORD size=0;
	// first get required size of string
	GetUserName(NULL,&size);
	// then build string and put user name in it
	buff = new TCHAR[size];
	if (!GetUserName(buff,&size)) {
		delete [] buff;
		return NULL;
	}
	return buff;
}
//---------------------------------------------------------------------------
void ShellExecuteWait(LPCTSTR lpFile, LPCTSTR lpParameters,
					  LPCTSTR lpDirectory, INT nShowCmd)
/*
	Run lpFile and wait for exit.
*/
{
	SHELLEXECUTEINFO si;
	ZeroMemory(&si, sizeof(SHELLEXECUTEINFO));
	si.cbSize = sizeof(SHELLEXECUTEINFO);
	si.fMask = SEE_MASK_NOCLOSEPROCESS;
	si.hwnd = NULL;
	si.lpFile = lpFile;
	si.lpParameters = lpParameters;
	si.lpDirectory = lpDirectory;
	si.nShow = nShowCmd;

	if (!ShellExecuteEx(&si))	return;

	// NT requires SYNCHRONIZE access in order to wait on the process handle
	OSVERSIONINFO osvi;
	HANDLE hHandle = si.hProcess;
	GetVersionEx(&osvi);
	if(osvi.dwPlatformId == VER_PLATFORM_WIN32_NT)
		hHandle = OpenProcess(SYNCHRONIZE, FALSE, (DWORD) hHandle);

	WaitForSingleObject(hHandle, INFINITE);
	CloseHandle(hHandle);
}
//---------------------------------------------------------------------------
LPTSTR GetWindowsDirectoryX(void)
/*
	Returns the Windows root folder.  Appends "\" to folder name if
	necessary.  It is the responsibility of the calling function to free
	the allocated space (eg. delete [] buff; ).
*/
{
	LPTSTR buff;
	UINT size;
	// first get required size of string
	size = GetWindowsDirectory(NULL,0);
	// then build string and put path in it
	buff = new TCHAR[size+1];
	GetWindowsDirectory(buff,size+1);
	// append "\" if necessary
	if (buff[size-2]!='\\') {
		buff[size-1]='\\';
		buff[size]='\0';	// note: sizeof(buff)==size+1
	}
	return buff;
}
//---------------------------------------------------------------------------
LPTSTR GetProfilesDirectory(void)
/*
	Returns the Windows Profiles folder with a trailing "\".
	It is the responsibility of the calling function to free
	the allocated space (eg. delete [] buff; ).

	Assumes the profiles directory is %WINDIR%\Profiles\.
*/
{
	TCHAR profiles[] = "Profiles\\";
	LPTSTR buff = new TCHAR[MAX_PATH];
	LPTSTR windir = GetWindowsDirectoryX();
	strcpy(buff,windir);
	delete [] windir;
	strcat(buff, profiles);
	return buff;
}
//---------------------------------------------------------------------------
LPTSTR GetUserProfileDirectory(LPTSTR name)
/*
	Searches registry for user profile directory.  If not found, assumes
	it is at %WINDIR%\Profiles\<name>.  (Does not include trailing "\".)
	It is the user's responsibility to free the returned string when done.

	Checks:
	HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\ProfileList
*/
{
	LPTSTR profdir;

	// set key
	const TCHAR proflist[] = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\ProfileList\\";
	LPTSTR key = new TCHAR[strlen(proflist)+strlen(name)];
	strcpy(key,proflist);
	strcat(key,name);

	// check in registry
	if (!ReadRegValue(HKEY_LOCAL_MACHINE, key, "ProfileImagePath", (LPBYTE)profdir)) {
		// nope, not found, so just make one up
		LPTSTR windir = GetWindowsDirectoryX();
		TCHAR profiles[] = "Profiles";
		profdir = new TCHAR[MAX_PATH];
		strcpy(profdir,windir);
		delete [] windir;
		strcat(profdir, profiles);
		CreateDirectory(profdir,NULL);	// eg. "C:\Windows\Profiles"
		strcat(profdir,"\\");
		strcat(profdir,name);
		CreateDirectory(profdir,NULL);	// eg. "C:\Windows\Profiles\User"
	}
	return profdir;
}
//---------------------------------------------------------------------------
BOOL exportFile(LPTSTR file, LPTSTR key)
/*
	Tries to export registry settings from key to file.  Always
	returns TRUE (future versions may incorporate error checking).
	The key is assumed to be relative to HKEY_CURRENT_USER

	Revisions:
	v1.1	July 15, 2001
		- newly spawned from export()
*/
{
	TCHAR params[MAX_PATH];		// regedit parameters
	strcpy(params,"/e ");
	strcat(params,file);
	strcat(params," \"");
	strcat(params,"HKEY_CURRENT_USER\\");
	strcat(params,key);
	strcat(params,"\"");
	ShellExecuteWait("regedit.exe", params, "", SW_SHOWNORMAL);
	return TRUE;
}
//---------------------------------------------------------------------------
BOOL importFile(LPTSTR file)
/*
	Tries to import registry settings from file.  Returns TRUE if
	file exists (assumes regedit is successful) else FALSE.

	Revisions:
	v1.1	July 15, 2001
		- newly spawned from import()
*/
{
	if (GetFileAttributes(file)==0xFFFFFFFF)	// file not found
		return FALSE;

	TCHAR params[MAX_PATH];		// regedit parameters
	strcpy(params,"/s ");
	strcat(params,file);
	ShellExecuteWait("regedit.exe", params, "", SW_SHOWNORMAL);
	return TRUE;
}
//---------------------------------------------------------------------------
void export(LPTSTR name)
/*
	Export registry settings to mainFile and foldersFile in user 'name's
	profile folder.  Only export folders settings if exportFolders
	is true.

	I don't use RegSaveKey() because RegRestoreKey() doesn't work
	under Win95.

	Revisions:
	v1.0c	June 10, 2001
		- menu order
*/
{
	// error trap
	if (!name)			return;
	if (!strlen(name))	return;

	// switch to user profile folder (create if necessary)
	LPTSTR profdir = GetUserProfileDirectory(name);
	SetCurrentDirectory(profdir);

	// export settings
	exportFile(mainFile,mainKey);
	exportFile(foldersFile,foldersKey);
	exportFile(menuOrderFile,menuOrderKey);

	delete [] profdir;
	return;
}
//---------------------------------------------------------------------------
void import(LPTSTR name)
/*
	Import registry settings from mainFile and foldersFile in user 'name's
	profile folder.

	RegRestoreKey() doesn't work under Win95.

	Revisions:
	v1.1b	May 10, 2002
		- clears current user's menu order before importing new one
	v1.0c	June 10, 2001
		- menu order
*/
{
	// error trap
	if (!name)			return;
	if (!strlen(name))	return;

	LPTSTR profdir = GetUserProfileDirectory(name);
	SetCurrentDirectory(profdir);

	// import regsistry files
	importFile(mainFile);
	if (!importFile(foldersFile)) {
		// file does not exist, so hack registry
		TCHAR data[MAX_PATH];
		// set Favorites, Cookies, and History folder in registry
		strcpy(data,profdir);	strcat(data,"\\Favorites");
		CreateDirectory(data,NULL);
		WriteRegValue(HKEY_CURRENT_USER,foldersKey,"Favorites",(LPBYTE)data);
		strcpy(data,profdir);	strcat(data,"\\Cookies");
		CreateDirectory(data,NULL);
		WriteRegValue(HKEY_CURRENT_USER,foldersKey,"Cookies",(LPBYTE)data);
		strcpy(data,profdir);	strcat(data,"\\History");
		CreateDirectory(data,NULL);
		WriteRegValue(HKEY_CURRENT_USER,foldersKey,"History",(LPBYTE)data);
	}
	RegDeleteKey (HKEY_CURRENT_USER,menuOrderKey);	// v1.1b
	importFile(menuOrderFile);

	delete [] profdir;
	return;
}
//---------------------------------------------------------------------------
LPTSTR GetCurrentDirectoryX(void)
/*
	Allocates space for folder name and returns pointer to current folder.
	It is the responsibility of the calling function to free the array.
*/
{
	DWORD nBufferLength = GetCurrentDirectory(0, NULL);
	if (!nBufferLength)	return NULL;
	LPTSTR lpBuffer = new TCHAR[nBufferLength];
	if (!lpBuffer)	return NULL;
	if (nBufferLength > GetCurrentDirectory(nBufferLength, lpBuffer))
		return lpBuffer;
	delete [] lpBuffer;
	return NULL;
}
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE handle, HINSTANCE, LPSTR lpCmdLine, int)
{
	LPTSTR dir = GetCurrentDirectoryX();

	// get usernames
	LPTSTR oldUser = GetUserNameX();
	TCHAR *newUser = _argv[1];	// _argv[1] should be <user>

	// strip newUser (with possible quotes) from command-line
	if (newUser) {
		lpCmdLine = strstr(lpCmdLine,newUser);
		lpCmdLine += strlen(newUser);
		if (lpCmdLine[0]=='\"')	lpCmdLine++;
		while (lpCmdLine[0]==' ')	lpCmdLine++;
	}

	// if lpCmdLine found first try to connect to current instance of IE
	if (!ShowURL(lpCmdLine)) {
		// if newUser not specified then just export current settings and exit
		export(oldUser);
		if (newUser) {
			import(newUser);
			ShellExecuteWait("iexplore.exe", lpCmdLine, dir, SW_SHOWNORMAL);
			export(newUser);
			import(oldUser);
		}
	}

	delete [] oldUser;
	delete [] dir;
	return 0;
}
//---------------------------------------------------------------------------
