/////////////////////////////////////////////////
/* a class to store an array of ones and zeros */
/* in the current implementation, can only hold 65,535 bits. */
/////////////////////////////////////////////////

#ifndef VECTOR_H
#define VECTOR_H

#include <limits.h>
#include "defines.h"

// automatic defines
//#ifdef INT_64
//#ifdef _WIN32
//typedef unsigned __int64 VECTOR_DATA_TYPE;
//#else
//typedef unsigned long long VECTOR_DATA_TYPE;
//#endif
//#define INT_BITS (64)
//#define INT_BYTES (8)
//#else
//typedef unsigned long int VECTOR_DATA_TYPE;
//#define INT_BITS	(32)
//#define INT_BYTES	(4)
//#endif
#if (MAX_SUBBINS < UCHAR_MAX)
typedef unsigned char VECTOR_DATA_TYPE;
#else 
#if (MAX_SUBBINS < USHRT_MAX)
typedef unsigned short int VECTOR_DATA_TYPE;
#else
typedef unsigned long int VECTOR_DATA_TYPE;
#endif
#endif

// BitvectorCountingType
#if (MAX_NUM_BIDS <= SCHAR_MAX)
typedef signed char VECTOR_COUNTING_TYPE;
#else
#if (MAX_NUM_BIDS <= SHRT_MAX)
typedef signed short int VECTOR_COUNTING_TYPE;
#else
typedef signed long int VECTOR_COUNTING_TYPE;
#endif
#endif

// assume that vectors are disjunct, so num_set doesn't always have to be recalculated
#define BV_ASSUME_DISJUNCT

class Vector
{
public:
	/* intersection and union */
	void unionWith (Vector *list2);
	void intersectWith(Vector *input);
	void intersectWithNot(Vector *input);
	Vector *unionWith(Vector *new_array, Vector *list2);

	/* access functions */
	VECTOR_COUNTING_TYPE getNumSet();
	VECTOR_COUNTING_TYPE getIntNum();
	VECTOR_DATA_TYPE *getArray();
	
	/* multi-bit functions */
	bool disjunctFrom(Vector *list2, int start_at=0);
	bool notDisjunctFrom(Vector *input, int start_at=0);
	int lowOrderMissing(int start_at=0);
	int lowOrderPresent(int start_at=0);
	bool equalTo(Vector *input);
	bool equalTo(VECTOR_DATA_TYPE *array);
	bool subsetequalof(Vector *vec2);

	/* single-bit functions */
	VECTOR_DATA_TYPE readArray(int index);
	void set(int index, VECTOR_DATA_TYPE num);
	void add(int index, VECTOR_DATA_TYPE num);
	void subtract(int index, VECTOR_DATA_TYPE num);
	unsigned remaining(VECTOR_COUNTING_TYPE index);
	unsigned maxUnits(VECTOR_COUNTING_TYPE index);

	/* hashing */
	unsigned hash();
	unsigned hash(unsigned key);
	
	/* management functions */
	void countNumSet();
	Vector *duplicate();
	void copyTo(Vector *input);
	void reset();
	void printVector(void);
	
	/* constructor/destructor */
	Vector(unsigned n, VECTOR_DATA_TYPE *max, bool copymem);
	~Vector();
	
private:
	/* variables */
	VECTOR_COUNTING_TYPE num;			// the number of elements in the vector
	VECTOR_COUNTING_TYPE num_set;		// the number of true bits in the vector
	VECTOR_DATA_TYPE *array;
	VECTOR_DATA_TYPE *max;
};

#ifdef INLINING_ON
#include "vector2.cpp"
#endif

#endif  // VECTOR_H
