


// Stats2.cpp

#ifndef STATS2
#define STATS2

#include "defines.h"
#include "stats.h"
#include "stopwatch.h"

extern Stopwatch sw;

// keep track of anytime statistics
INLINE void Stats::updateAnytimeStats(int best_amount)
{
	// gather anytime stats
	#ifdef GATHER_ANYTIME_STATS  // keep track of the anytime history
		#ifdef _DEBUG
			if (BEST_HISTORY_MAX <= best_history_index) printf ("Exceeded best_history_index--increase BEST_HISTORY_MAX\n");
		#endif
		best_history_amount[best_history_index] = best_amount;
		best_history_time[best_history_index++] = (double)sw.Lap();
	#endif
	return;
}

// increment the number of complete allocations examined
INLINE void Stats::incrementNumExamined()
{
	#ifdef GATHER_STATS
		num_examined++;
	#endif
;
}

// cache hit
INLINE void Stats::incrementCacheHit() 
{
	#ifdef GATHER_STATS
		num_cache++;
	#endif
;
}

// prune hit
INLINE void Stats::incrementPruneHit()
{
	#ifdef GATHER_STATS
		if (num_prune >= 1000000000)
		{
			num_prune -= 1000000000;
			num_prune_billions += 1;
		}
		num_prune++;
		#ifdef GATHER_PRUNING_STATS
			prune_bin[binset->currentBin()->binNumber()]++;
			prune_hits[main_path->num]++;
		#endif
	#endif
}

// recursive calls
INLINE void Stats::incrementRecursiveCalls()
{
	// this one isn't just a stat--it's for caching too
	num_recursive_calls++;
}

// propagation
INLINE void Stats::incrementNumPropagated()
{
#ifdef GATHER_STATS
	num_propagated++;
#endif
}

#endif
