// $Id: param.h,v 1.14 1999/01/11 19:23:59 fujisima Exp $

#ifndef PARAM_H
#define PARAM_H

#include <stdio.h>
#include "inputfile.h"

class
Param {
public:
	enum EDist {D_EXP = 1, D_LINE = 2, D_BINOM = 3, D_RANDOM = 4, D_UNIFORM = 5, D_DECAY = 6};
	Param(const char* const* argv);
	int NumAuc() const;
	int NumBid() const;
	int NumGood() const;
	int AvePrice() const;
	int DevPrice() const;
	int CacheSize() const;
	int MakeBids() const;
	int MakeCPLEX() const;
	int RndSeed() const;
	int uniformPrice() const;
	int scaledPrice() const;
	EDist Dist() const;
	double DistParam() const;
	char *FileName();
	char *OutputFileName();
	int ForceCreate() const;
	int Append() const;
	int Err() const;
	void Usage() const;
	int NoAppend() const;
	int DecisionCutoff() const;
	double TimeLimit() const;
	bool LogFileNameSameAsInput() const;
public:
	void Output(FILE *fp, InputFile &infile) const;
private:
	int mMakeBids;
	int mMakeCPLEX;
	int mCacheSize;
	int mNumAuc;
	int mNumBid;
	int mNumGood;
	int mAvePrice;
	int mDevPrice;
	int mRndSeed;
	int mPricing;
	char *mFileName;
	char *mOutputFileName;
	EDist mDist;
	double mDistParam;
	int mForceCreate;
	int mAppend;
	int mNoAppend;
	int mErr;
	int decision_cutoff;
	double timeLimit;
	bool log_file_name_same_as_input;
};

//////// Inline Functions ////////

inline
int
Param::NumAuc() const {
	return mNumAuc;
}

inline
double
Param::TimeLimit() const {
	return timeLimit;
}

inline
int
Param::DecisionCutoff() const {
	return decision_cutoff;
}

inline
int
Param::NumBid() const {
	return mNumBid;
}

inline
int
Param::NumGood() const {
	return mNumGood;
}

inline
int
Param::AvePrice() const {
	return mAvePrice;
}

inline
int
Param::DevPrice() const {
	return mDevPrice;
}

inline
int
Param::CacheSize() const {
	return mCacheSize;
}

inline
int
Param::MakeBids() const {
	return mMakeBids;
}

inline
int
Param::MakeCPLEX() const {
	return mMakeCPLEX;
}

inline
int
Param::NoAppend() const {
	return mNoAppend;
}

inline
int
Param::RndSeed() const {
	return mRndSeed;
}

inline
int
Param::uniformPrice() const {
	return (mPricing==2?1:0);
}

inline
int
Param::scaledPrice() const {
	return (mPricing==3?1:0);
}

inline
char *
Param::FileName() {
	return mFileName;
}

inline
char *
Param::OutputFileName() {
	return mOutputFileName;
}

inline
Param::EDist
Param::Dist() const {
	return mDist;
}

inline
double
Param::DistParam() const {
	return mDistParam;
}

inline
int
Param::ForceCreate() const {
	return mForceCreate;
}

inline
int
Param::Append() const {
	return mAppend;
}

inline
int
Param::Err() const {
	return mErr;
}

inline bool Param::LogFileNameSameAsInput() const {
	return log_file_name_same_as_input;
}

#endif // !INCLUDE_PARAM_H
