// $Id: param.cpp,v 1.18 1999/01/12 00:07:19 fujisima Exp $

#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "param.h"
#include "defines.h"

static const int NUM_AUC = 1;
static const int NUM_BID = 1000;
static const int NUM_GOOD = 40;
static const int AVE_PRICE = 1000;
static const int DEV_PRICE = 50;
static const Param::EDist DISTRIB = Param::D_EXP;
static const double DIST_PARAM = 5.0;
#define DEFAULT_FILENAME "data"
static char* FILE_NAME = DEFAULT_FILENAME;
static const int RND_SEED = 1234567890;
static const int USE_MAKEBIDS = 1;
//default cache size set in defines.h

Param::Param(const char* const* argv) :
mNumAuc(NUM_AUC), mNumBid(NUM_BID), mNumGood(NUM_GOOD),
mAvePrice(AVE_PRICE), mDevPrice(DEV_PRICE),
mFileName(FILE_NAME),mOutputFileName(OUTPUT_FILENAME), mDistParam(DIST_PARAM),
mDist(DISTRIB), mForceCreate(1), mAppend(0),
mCacheSize(CACHE_SIZE),mMakeBids(0),mMakeCPLEX(0),
//mRndSeed((unsigned long)time(0)), 
mRndSeed(RND_SEED),mNoAppend(0),
mErr(0), mPricing(1), log_file_name_same_as_input(false) 
{
	if (!argv[1]) mErr = 1;
	decision_cutoff=0;
	timeLimit = 0;
	while (*++argv) 
	{
		if ((*argv)[0] == '-' || (*argv)[0] == '/') 
		{
			int* ip = 0;
			double* dp = 0;
			int fn = 0, fn2 = 0;
			switch (tolower((*argv)[1])) 
			{
			case 'l':
				log_file_name_same_as_input = true;
				break;
			case 't':
				dp = &timeLimit;
				break;
			case 'k':
				ip = &decision_cutoff;
				break;
			case 'u':
				ip = &mPricing;
				break;
			case 'n':
				ip = &mNumAuc;
				break;
			case 'b':
				ip = &mNumBid;
				break;
			case 'g':
				ip = &mNumGood;
				break;
			case 'a':
				ip = &mAvePrice;
				break;
			case 'd':
				ip = &mDevPrice;
				break;
			case 'i':
				fn = 1;
				break;		
			case 'o':
				fn2 = 1;
				break;
			case 'p':
				dp = &mDistParam;
				break;
			case 's':
				ip = &mRndSeed;
				break;
			case 'f':
				ip = (int*)&mDist;
				break;
			case '!':
				mForceCreate = 1;
				break;
			case '@':
				mAppend = 1;
				break;
			case 'm':
				mMakeBids = 1;
				break;
			case 'c':
				ip = &mCacheSize;
				break;
			case 'x':
				mMakeCPLEX = 1;
				break;
			case 'z':
				mNoAppend = 1;
				break;
			default:
				mErr = 1;
				return;
				break;
			}
			if (fn || fn2 || ip || dp) {
				if (*++argv == 0) {
					mErr = 1;
					return;
				}
			}
			if (fn) 
			{
				mFileName = new char[strlen(*argv)+2];
				strcpy(mFileName,*argv);
			} 
			else if (fn2)
			{
				mOutputFileName = new char[strlen(*argv)+2];
				strcpy(mOutputFileName,*argv);
			}
			else if (ip) 
			{
				*ip = atoi(*argv);
			} else if (dp) {
				*dp = atof(*argv);
			}
			if (mDevPrice < 1 || mDevPrice > 99) {
				printf("Out of range: deviation_of_price\n");
				mErr = 1;
				return;
			}
		} else {
			mErr = 1;
			printf ("Did not understand input %s\n", argv[0]);
			return;
		}
	}
}

void
Param::Usage() const 
//          12345678901234567890123456789012345678901234567890123456789012345678901234567890 - 80 columns
{
	printf("Usage: cass [parameters]\n");
	printf("\nGeneral Parameters:\n");
	printf(" -n number of auctions\t\t\t(default %d)\n",NUM_AUC);
	printf(" -i input file name (.txt is appended)\t(default \"%s\")\n",DEFAULT_FILENAME);
	printf(" -z do not append anything to the input file name\n");
	printf(" -c cache size (bytes)\t\t\t(default %d)\n",CACHE_SIZE);
	printf(" -k decision problem cutoff (otherwise optimization is done)\n");
	printf(" -t time limit (give best solution after t seconds)\n");
	printf("\nBid Generation Parameters:\n");
	printf(" -m use MakeBids to generate data files - file must be in the same dir as CASS.\n");
	printf("    If this flag is absent, CASS reads data from the specified input file\n");
	printf("    and all bid generation flags are ignored.\n");
	printf(" -x generate CPLEX data file from the input file and exit\n");
	printf(" -g number of goods\t\t\t(default %d)\n",NUM_GOOD);
	printf(" -b number of bids\t\t\t(default %d)\n",NUM_BID);
	printf(" -f distribution (1:Exponential 2:Linear 3:Binomial 4: Sandholm Random,\n");
	printf("    5: Sand. Uniform, 6: Sand. Decay)\t(default %d)\n",1);
	printf(" -p distribution parameter\t\t(default %f)\n",DIST_PARAM);
	printf(" -s random seed\t\t\t\t(default %d)\n",RND_SEED);
	printf(" -a average of prices\t\t\t(default %d)\n",AVE_PRICE);
	printf(" -d deviation of prices\t\t\t(default %d)\n",DEV_PRICE);
	printf("\nLog File Parameters:\n");
	printf(" -! force creating log file\t\t(default %s)\n","present");
	printf(" -@ append to log file\t\t\t(default %s)\n","absent");
	printf(" -l create log file with same name as input file and .log extension\n");
}

//default cac
void
Param::Output(FILE *fp, InputFile &infile) const 
{
	time_t t;
	time(&t);
	char* ts = ctime(&t);
	ts[24] = '\0'; // remove '\n'

	fprintf (fp,"NUM_GOOD,NUM_BID,DISTRIB,DIST_PARAM,AVE_PRICE,DEV_PRICE,TIME_CNT,TIME_INT,QUALITY,SSA_ROUND,RND_SEED,METHOD,NUM_AUC,DATE\n");
	fprintf (fp,"%d,%d,%d,%lf,%d,%d,%d,%d,%d,%d,%d,%d,%d,%s\n", 
		infile.num_items, infile.num_bids, *(int*)&mDist, mDistParam, mAvePrice, mDevPrice, 0, 0, 0, 0, mRndSeed, 0, mNumAuc, ts);
}
