// MULTIBINSET2.CPP

#ifndef MULTIBINSET2
#define MULTIBINSET2

#include "defines.h"

#ifdef MULTI_UNIT

#include "multibinset.h"

// accessor for the current bin
INLINE MultiBin * MultiBinSet::currentBin()
{
	return bin[current_bin];
}

// call multiBin->bidSearched()
INLINE void MultiBinSet::currentBidSearched()
{
	currentBin()->bidSearched(currentBin()->currentBid());
}

// get the next bin
INLINE bool MultiBinSet::nextBin(Allocation *allocation, int best_amount, BidHistory *history)
{
	int temp = currentBin()->currentBid()->nextBin();  // read the value stored in the bid
	
	//allocation->vec->printVector();
	
	if (temp != current_bin)
	{
		binstack[++binstack_pointer] = current_bin;
		current_bin = temp;
	}
	
	//printf ("Temp: %d, currentbin %d \n", temp, current_bin);

#ifdef _DEBUG
//	if (current_bin < 1)
//	{
//		printf ("MultiBinSet::nextBin() error:  ");
//		allocation->vec->printVector();
//		exit(1);
//	}
#endif
	
	// construct the new bin
	bin[current_bin]->constructNewBin(allocation,best_amount);	
	return (bin[current_bin]->getNum() != 0);  // return "is a non-empty bin"
}

// go to the last bin that was current
INLINE void MultiBinSet::prevBin()
{
	// previous bin is a subbin of the current bin
	if (bin[current_bin]->currentSubbin() > 1) // not on the first subbin
		bin[current_bin]->prevSubbin();
	
	// previous bin is a real bin
	else if (binstack_pointer != -1)
	{
		bin[current_bin]->prevSubbin();
		current_bin = binstack[binstack_pointer--];
	}

	// something went wrong
	else
		printf ("Binstack failure\n");
}

// calculate the pruning value, given the bin number
INLINE unsigned MultiBinSet::pruneVal(Vector *vec, int bin_num)
{
	return bin[bin_num]->pruneVal(vec);
}

// calculate the pruning value
INLINE unsigned MultiBinSet::pruneVal(Vector *vec)
{
	return bin[vec->lowOrderMissing(0)]->pruneVal(vec);
}

// if desired, report progress of search (percentage of the way through bin zero)
INLINE void MultiBinSet::displayProgress()
{
	#ifdef DISPLAY_PROGRESS
		if ( ((currentBin()->binNumber() == 0 && currentBin()->currentSubbin() == 0) || currentBin()->progress == 101) 
			&& (bin[0]->percentDone() != currentBin()->progress))
		{
			currentBin()->progress = bin[0]->percentDone();
			printf ("%3d%%\b\b\b\b\b\b\b\b",currentBin()->progress);
		}
	#endif
}

INLINE bool MultiBinSet::nextBid()
{
	displayProgress();
	
	return bin[current_bin]->nextBid();
}

#endif // multi_unit
#endif
