// multibinset.h: interface for the MultiBinSet class.
//
//////////////////////////////////////////////////////////////////////

#ifndef MULTIBINSET_H
#define MULTIBINSET_H

#include "defines.h"

#ifdef MULTI_UNIT

#include "allocation.h"
#include "multibin.h"
#include "vector.h"
#include "inputfile.h"

class MultiBinSet
{
public:
	void printSingletonArrays();
	// functions
	MultiBin *currentBin();
	bool nextBin(Allocation *allocation, int best_amount,BidHistory *history);
	void prevBin();
	void displayProgress();
	unsigned pruneVal(Vector *vec, int bin_num);
	unsigned pruneVal(Vector *vec);
	bool nextBid();  // displays progress and calls bin::nextBid()
	void currentBidSearched();

	// setup
	void sortBins();
	void constructPruningTables();
	void gatherPruningStats();
	void populateBins(InputFile& infile);
	void makeFirstBin(Allocation *allocation, int best_amount);
	
	// constructor/destructor
	MultiBinSet(int numBins);
	~MultiBinSet();

	unsigned *singleton;
	int current_bin, num_bids;

	MultiBin **bin; // this should be private *******************************************************
private:
	Bid *makeBid(InputFile &infile, InputBid *inbid);

	// variables
	int num_bins, temp, prev_bin;
	int *binstack;
	int binstack_pointer;
};

#ifdef INLINING_ON
#include "multibinset2.cpp"
#endif

#endif // multi_unit
#endif // MULTIBINSET_H
