// $Id: main.cpp,v 1.13 1999/01/11 19:23:59 fujisima Exp $

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "param.h"
#include "cass.h"
#include "stats.h"
#ifdef CHECK_WITH_DABL
#include "dabl.h"
#endif

extern Stats *stats;

FILE *openOutputFile(char *filename)
{
	FILE *fp = fopen(filename, "at");
	if (!fp) 
	{
		printf ("Could not open output file %s\n", filename);
		exit(1);
	}
	return fp;
}

/* program starts here */
int main(int argc, char *argv[], char *envp[]) 
{
	int i,len;
	float *runningTime;
	unsigned *bestRevenue;
	FILE *fp;
	Cass *cass;

	// public release message
#ifdef PUBLIC_RELEASE
	printf ("*******************************************************************************\n");
	printf ("* CASS Public Release v%s (c) 1999 Kevin Leyton-Brown, Stanford University  *\n",PUBLIC_RELEASE_VER);
	printf ("* --------------------------------------------------------------------------- *\n");
	printf ("* This version of CASS is for academic research purposes only.                *\n");
	printf ("* In particular, commercial use is prohibited without express permission.     *\n");
	printf ("*                                                                             *\n");
	printf ("* Please send any feedback or bug reports to kevinlb@robotics.stanford.edu    *\n");
	printf ("*******************************************************************************\n");
#endif

	// make sure I don't leave inlining off by mistake!
#ifndef INLINING_ON
	printf ("WARNING: inlining is disabled!\n");
#endif

	// parse parameters
	Param param((const char* const*)argv);
	if (param.Err()) 
	{
		param.Usage();
		return 1;
	}
	
	//fp = openOutputFile(param.OutputFileName());

	// once for each auction...
	runningTime = new float[param.NumAuc()];
	bestRevenue = new unsigned [param.NumAuc()];
	for (i = 0; i < param.NumAuc(); i++) 
	{
		printf ("\n==== Auction started ====\n");

		// if necessary, generate bids on the fly
		if (param.MakeBids())
		{
			char buffer[255], num;
			sprintf(buffer,"%smakebids -n %d -t %d -o %s ", MAKEBIDS_PATH, i+1, i, param.FileName());
			for (num=1;num < argc;num++)
			{
				if (!stricmp(argv[num],"-n"))  // num auctions
					num++;
				else if (!stricmp(argv[num],"-i"))  // input file
					num++;
				else if (!stricmp(argv[num],"-c"))  // cache size
					num++;
				else if (!stricmp(argv[num],"-m"))  // makebids
					;  // nothing to skip here
				else if (!stricmp(argv[num],"-x"))  // CPLEX
					;
				else if (!stricmp(argv[num],"-z"))  // literal input file
					;
				else
				{
					strcat(buffer,argv[num]);
					strcat(buffer," ");
				}
			}
			system(buffer);
		}
		int filenum = i+1;
		
		/* read in the input file */
		InputFile infile;
		char filename[255];
		if (param.NoAppend())
			strcpy(filename,param.FileName());
		else
			sprintf(filename,"%s%0*d.txt",param.FileName(),(int)ceil(log10(i+1))+1,filenum);
		if (!infile.parse(filename))
			exit (1);  // file could not be opened, error message has been displayed

		// output
		printf ("Goods: %d, Dummy: %d, Bids: %d, Trial: %d of %d\n",infile.num_items-infile.num_dummy_items,infile.num_dummy_items, infile.num_bids,i+1,param.NumAuc());
//		if (i==0)
//		{
			// output parameter settings
//			param.Output(fp,infile);
//			fprintf (fp,"\n");
//			fclose(fp);
//		}

		// CPLEX
		if (param.MakeCPLEX())
		{
			char filename2[255];
			int counter;
			for (counter=0;filename[counter] != '.';counter++)
				filename2[counter] = filename[counter];
			filename2[counter++] = '.'; filename2[counter++] = 'l'; filename2[counter++] = 'p'; filename2[counter++] = 0;
			printf ("Writing CPLEX file %s...",filename2);
			infile.writeCPLEXFile(filename2);
			printf ("done.\n");
			#ifdef BREAK_AFTER_MAKING_CPLEX_FILE
				continue;
			#endif
		}
		
		// run the auction
		cass = new Cass(&infile,param.CacheSize());
#ifdef DECISION_PROBLEM
		cass->decision_cutoff = param.DecisionCutoff();
#endif
#ifdef TIME_LIMIT
		cass->timeLimit = param.TimeLimit();
#endif

		#ifdef MULTI_UNIT
			printf ("---- CAMUS started ----\n");
		#else
			printf ("---- CASS started ----\n");
		#endif
		cass->run(infile);
		
		// output winning bids
		len = strlen(filename);
		char *filename3 = new char[len+3];
		strcpy(filename3,filename);
		filename3[len-3]='w'; filename3[len-2]='i'; filename3[len-1]='n'; filename3[len] = 0; // this assumes files have a 3-letter suffix: wrong
		cass->outputResults(filename3);
		delete filename3;
		runningTime[i] = (float)stats->time;
		bestRevenue[i] = cass->best->amount;

		// output log file
		if (param.LogFileNameSameAsInput())
		{
			len = strlen(filename);
			char *filename3 = new char[len+3];
			strcpy(filename3,filename);
			filename3[len-3]='c'; filename3[len-2]='s'; filename3[len-1]='v'; filename3[len] = 0; // this assumes files have a 3-letter suffix: wrong
			fp = openOutputFile(filename3);
			delete filename3;
		}
		else fp = openOutputFile(param.OutputFileName());

		#ifdef COUNT_MIS
			fprintf (fp,"%d,%d,%f,%d,%d,%d,%d,%d,%lld,",
				infile.num_items-infile.num_dummy_items,
				infile.num_bids,
				stats->time,
				cass->best->amount,
				stats->num_recursive_calls + stats->num_examined,
				stats->num_recursive_calls + stats->num_cache,
				stats->mis_max,stats->mis_min,stats->mis_num);
			fprintf(fp,"%lf,%lf,%d,\"%s\"\n",
				_64to2(stats->mis_sum)/_64to2(stats->mis_num),
			sqrt(_64to2(stats->mis_sum_sq) / _64to2(stats->mis_num) - _64to2(stats->mis_sum)/_64to2(stats->mis_num) * _64to2(stats->mis_sum)/_64to2(stats->mis_num)),
				param.DecisionCutoff(),filename);
		#else
			if (stats->num_prune_billions)
			{
				fprintf (fp,"%d,%d,%f,%d,%d,%d,%d%09d,%d,\"%s\"\n",infile.num_items-infile.num_dummy_items,infile.num_bids,stats->time,
					cass->best->amount,stats->num_recursive_calls + stats->num_examined,stats->num_recursive_calls + stats->num_cache,stats->num_prune_billions,stats->num_prune,
					param.DecisionCutoff(),filename);
			}
			else
			{
				fprintf (fp,"%d,%d,%f,%d,%d,%d,%d,%d,\"%s\"\n",infile.num_items-infile.num_dummy_items,infile.num_bids,stats->time,
					cass->best->amount,stats->num_recursive_calls + stats->num_examined,stats->num_recursive_calls + stats->num_cache,stats->num_prune,
					param.DecisionCutoff(),filename);
			}
		#endif
		
		fclose(fp);
		
		// run DABL to confirm that CASS was correct
		#ifdef CHECK_WITH_DABL
			Dabl dabl;
			printf ("\n---- DABL started ----\n");
			dabl.DescAvgBidRev(infile,0,0);
			if((unsigned) dabl.nBestRevenue == cass->best->amount)
				printf ("DABL and CASS report the same revenue, %d\n",cass->best->amount);
			else 
			{
				printf("DABL and CASS have different revenues--exiting\n");
				exit(1);
			}
		#endif

		// free memory between iterations: particularly the cache
		delete cass;
	}

	// running times
	if (param.NumAuc() > 1)
	{
		float temp=0.0;
		printf ("\n========================\n\nSummary:\n--------------\n\n # \tAmount\tTime\n");
		for (i=0;i<param.NumAuc();i++)
		{
			printf ("%2d:\t%d\t%f\n",i+1,bestRevenue[i],runningTime[i]);
			temp+=runningTime[i];
		}
		printf ("\nAverage Time: %f\n\n",temp/param.NumAuc());
	}
	delete[] runningTime;
	delete[] bestRevenue;
	
	// close the file
	//fp = openOutputFile(param.OutputFileName());
	//fprintf(fp,"\n\n\n////////\n\n");
	//fclose(fp);

	return 0; 
}

double randNeg()
{
	return ((double)rand() / (double)RAND_MAX) * 2.0 - 1.0;
}

double randFactor(double variance)
{
	return 1 + (((double)rand() / (double)RAND_MAX) * 2.0 - 1.0) * variance;
}

