// LinkedList2.cpp

#ifndef LINKEDLIST2
#define LINKEDLIST2

#include "defines.h"
#include "linkedlist.h"
#include "assert.h"

// add something to the beginning of the list 
INLINE void LinkedList::addFirst(LinkedListItem *ptr)
{
	LinkedListItem *temp;
	temp = first;
	first = ptr;
	first->next = temp;
	first->prev = NULL;
	if (temp == NULL)
		last = first;
	else 
		temp->prev = first;
}

// delete the last thing in the list 
INLINE void *LinkedList::deleteLast()
{
	void *temp;
	
	if (!last) return NULL;
	
	LinkedListItem *temp2 = last;
	
	if (last)
	{
		last = last->prev;
		if (!last)
			first = NULL;
		else
			last->next = NULL;
	}

	// member data is not deleted, but it is returned so that it may be deleted by the calling function
	temp = temp2->bid;
	delete temp2;
	return temp;
}

// duplicate an existing list and append it to this list 
INLINE void LinkedList::copyFrom(LinkedList *input)
{
	LinkedListItem *ptr=input->first, *new_item;
	
	// append the given list to this list
	while (ptr)
	{
		new_item = new LinkedListItem(ptr->bid);
		addLast(new_item);
		ptr = ptr->next;
	}
}

// add a node to the end of the list 
INLINE void LinkedList::addLast(LinkedListItem *ptr)
{
	ptr->prev = last;
	ptr->next = NULL;
	if (last) 
		last->next = ptr;
	last = ptr;
	if (first == NULL) first = ptr;
}


// add a bid to the list 
INLINE void LinkedList::addBid(Bid *input)
{
	LinkedListItem *ptr, *new_item;
	int count=0;
	
	assert(input->vec->lowOrderPresent(0) >= bin_num);
	
	ptr = first;
	new_item = new LinkedListItem(input);

	if (ptr == NULL || ptr->bid->average <= input->average)
	{
		addFirst(new_item);
	}
	else
	{
		while (ptr->next && ptr->next->bid->average > input->average)
		{
			if (count++ > PRUNE_MAX_TRIES+2)
				return;  // this bid will never be examined
			ptr = ptr->next;
		}
		addAfter(ptr,new_item);
	}
}

// add an item after ptr 
INLINE void LinkedList::addAfter(LinkedListItem *ptr, LinkedListItem *new_item)
{
	new_item->next = ptr->next;
	new_item->prev = ptr;
	if (ptr->next)
		ptr->next->prev = new_item;
	ptr->next = new_item;
}

// find the most average revenue attainable from a bid 
INLINE int LinkedList::maxAvgRevenue()
{
	return first->bid->average;
}


// find the least revenue attainable from a bid 
//INLINE unsigned LinkedList::minAvgRevenue()
//{
//	return last->bid->average;
//}


// find the most average revenue attainable from a bid that doesn't conflict with vec 
// this is basically the implementation of pruning for [MU]CASS
INLINE int LinkedList::maxAvgRevenue(VECTOR *vec, int index)
{
#ifdef MULTI_UNIT
	// Vector version
	int sum=0;
	int total = vec->maxUnits(index);
	int remaining = vec->remaining(index);
	
	// the real function
	ptr = first;
	while (ptr && ptr->next && remaining > 0)
	{
		while (ptr->next && vec->notDisjunctFrom(ptr->bid->vec,bin_num))
			ptr = ptr->next;

		// if I want, put in a test here to check if a previously-added bid is being used

		// we only test the second condition when we're at the end of the list
		if (ptr->next || vec->disjunctFrom(ptr->bid->vec,bin_num))
		{
			// add the bid that we just found
			// however, add only units for the good in question, to make this an overestimate instead of greedy search
			int temp = ptr->bid->vec->readArray(index);
			assert(temp);
			sum += min(remaining,temp) * ptr->bid->average;
			remaining -= temp;
		}
		// now keep searching until we fill up all the units
	}
	
	if (remaining < 0) remaining = 0;

	// return everything
	if (ptr) return sum + remaining*ptr->bid->average;  // got to the end of the list without filling everything up yet
	else return sum;
#else
	return 0;
#endif
}

// find the most average revenue attainable from a bid that doesn't conflict with vec 
// this is basically the implementation of pruning for [MU]CASS
INLINE int LinkedList::maxAvgRevenue(VECTOR *vec)
{
	// BitVector version
	ptr = first;
	while (ptr && ptr->next && vec->notDisjunctFrom(ptr->bid->vec,0))  // kkk--does "bin_num" work here?
		ptr = ptr->next;
	if (ptr) return ptr->bid->average;
	else return 0;
}

#endif
