/* INPUT FILE FORMAT:
   ==================

% comments follow percentage symbols
% blank lines are ignored
% files are not case-sensitive
% [CR]'s are optional, all whitespace is ignored

goods 15
dummy 10
bids 800

% bidnum, price, goodnum, goodnum, ..., goodnum, #

0	20.75	2	6	8	#
1	30		1	2	5	7	13	#
2	5.20	4	#
  .
  .
  .

% implicitly, all goods numbered 15 or above (in this example) are dummies
% note that all counting starts from zero
% bidnum's do not need to be sequential between 0..799.  They just need to be unique.
*/

#include <stdio.h>
#include <string.h>

#include "inputbid.h"

#ifndef INPUTFILE_H
#define INPUTFILE_H

class InputFile
{
public:
	bool reorderedGoods();
//	int getbidcount(int index);
	int mapBack(int index);
	int map(int index);
	int getNumBids(int index);
	void refine(bool dom_check=true);
	void orderGoods();
	void randomlyOrderGoods();

	// this one is actually all you need
	bool parse (char *filename);

	// functions
	bool open (char *filename);
	void close();
	void parse();
	void print(int maxrec=-1);
	bool writeCPLEXFile(char *filename);

	// constructor/destructor
	InputFile();
	~InputFile();

	// variables
	unsigned int num_items, num_dummy_items, num_bids;
	InputBid **bid;

private:

	// functions
	void appendDominatedBid(int master, int slave);
	void createSingletonBid(int index);
	void removeBid(int index);
	void skipComments();
	void fileRead (unsigned int *int_input);
	void fileRead (float *float_input);
	void fileRead (VECTOR_DATA_TYPE &vdt_input);
	void fileRead (const char *label, unsigned int *int_input);
	signed int fileReadGood (unsigned bidnum);
	bool isAllWhitespace(char *input,int len);
	void scramble(unsigned int *input, int size);
	static int scrambleCompare(const void *in1, const void *in2);
	bool removeSingletonDummyGoods();
	int deleteDominatedBids(unsigned t,bool singleton_cleared);

	
	// variables
	FILE *fp;
	int num_killed;
	char *filename, buffer[1000];
	bool reordered_goods;
	VECTOR_DATA_TYPE *subbin_max;
	unsigned int *listMap, *listMapBack, *bidcount, *bidcount_temp, *bidlength_temp;
	int first_good;
};

#endif