#include "defines.h"

#ifndef MULTI_UNIT

#include "dabl.h"
#include "stopwatch.h"


// globals to be used for comp; identical
// to similarly-named class var.
int *cnpPrices;
BitVector **cbvppBids;

// constructor
Dabl::Dabl()
{
	npPrices=NULL;
	bvppBids=NULL;
	nGoods = 0;
	nBids = 0;
	npBestAlloc = NULL; 
	nBestRevenue = 0;
	nNumBestRevenueBids = 0;
	npSortArray = NULL;
	npTakenBids = NULL;
	nSoldGoods = 0;
	numreversed = 0;
	// percentages of optimal
	dpPercentiles[0] = .8;
	dpPercentiles[1] = .84;
	dpPercentiles[2] = .86;
	dpPercentiles[3] = .88;
	dpPercentiles[4] = .90;	
	dpPercentiles[5] = .93;
	dpPercentiles[6] = .95;
	dpPercentiles[7] = .98;
	dpPercentiles[8] = 1.0;
	// highest percent of optimal we've reached
	nBinReached = 0;
	fp_dabOutput = fopen("DABoutput.csv", "a");
	fp_2output = fopen("DABoutput2.csv", "a");
	fp_3output = fopen("DABoutput3.csv", "a");
	backtrack = 0;
}

// destructor
Dabl::~Dabl()
{

}

int comp(const void *a, const void *b)
{
	/* sorting sortArray according to avg price
	(e.g., a bid of $10 for 5 objects would have
	an avg price of $2) */

	int l = *(int *)(a), r = *(int *)(b);

	/* want in descending order */
	if (cnpPrices[l]/(cbvppBids[l])->getNumSet() > 
		cnpPrices[r]/(cbvppBids[r])->getNumSet()) return -1;
	if (cnpPrices[l]/(cbvppBids[l])->getNumSet() < 
		cnpPrices[r]/(cbvppBids[r])->getNumSet()) return 1;
	return 0;

}

void Dabl::DescAvgBidRev(const InputFile& infile, int ssarev, double ssatime, double timelimit, int runOnce)
{
	int i;
	int revenue = 0;
	double sw_time;

	nSSArev = ssarev;
	dSSAtime = ssatime;
	this->timelimit = timelimit;
	this->runOnce = runOnce;
	pfsw = new Stopwatch();
	
	pfsw->Start();

	nBids = infile.num_bids;
	nGoods = infile.num_items;
	npPrices = (int *)malloc(nBids * sizeof(int));
	cnpPrices = (int *)malloc(nBids * sizeof(int));
	npSortArray = (int *)malloc(nBids * sizeof(int));
	bvppBids = (BitVector **)malloc(nBids * sizeof(*bvppBids));
	cbvppBids = (BitVector **)malloc(nBids * sizeof(*bvppBids));
	bvppSoldGoods = (BitVector **)malloc(nBids * sizeof(*bvppBids));

	// Print header of output file, and tops of columns
	fprintf(fp_dabOutput, "\"Bin(.2)%d Goods, %d Bids, %d Bid Decision Flips\"\n\n",
		nGoods, nBids, MAXREVERSE);

	fprintf(fp_dabOutput, "CASS Revenue, time\n");
	fprintf(fp_dabOutput, "%d, %f\n\n",
		ssarev, ssatime);

	fprintf(fp_2output, "\"Bin(.2)%d Goods, %d Bids, %d Bid Decision Flips\"\n\n",
		nGoods, nBids, MAXREVERSE);

	fprintf(fp_2output, "CASS Revenue, time\n");
	fprintf(fp_2output, "%d, %f\n\n",
		ssarev, ssatime);


	for (i = 0; i < NUM_PERCENTILES - 1; i++)
		fprintf(fp_dabOutput, "%f, ", dpPercentiles[i]);
	fprintf(fp_dabOutput, "%f\n", dpPercentiles[NUM_PERCENTILES - 1]);

	// intermediate: the number of taken bids
	// gets passed around
	npTakenBids = (int *)malloc(nGoods * sizeof(int));

	// The set of bids in the best allocation ever 
	// (keeps getting updated)
	npBestAlloc = (int *)malloc(nBids * sizeof(int));

	// The sum of prices of bids in npBestAlloc
	// i.e., the best revenue ever
	nBestRevenue = 0;

	// The number of bids in the best revenue
	nNumBestRevenueBids = 0;
	
	/* extract bids from the input parameter */
	for (i = 0; i < nBids; i++) 
	{
		bvppBids[i] = infile.bid[i]->vec->duplicate();
		cbvppBids[i] = infile.bid[i]->vec->duplicate();
		bvppSoldGoods[i] = new BitVector(nGoods, NULL, 1);

		npPrices[i] = infile.bid[i]->amount;
		cnpPrices[i] = infile.bid[i]->amount;
	}

	for (i = 0; i < nBids; i++) {
		npSortArray[i] = i;
	}

	for (i = 0; i < nGoods; i++) 
		npTakenBids[i] = 0;


	/* sort SortArray according to size of bid div by
	number of items */
	qsort((void *)npSortArray, nBids, sizeof(int), &comp);

	// intermediate: set of goods we've sold, so far
	// the 1 in this fn call means fill clear 
	// i.e., init it to an empty vector.
	bvpSoldGoods = new BitVector(nGoods, NULL, 1);


	findBest(0, 0, 0); // starting with the first bid & none
					   // taken so far

	revenue = 0;
	for (i = 0; i < nNumBestRevenueBids; i++) {
		printf("%d, ",npBestAlloc[i]);
		revenue += npPrices[npBestAlloc[i]];
//		(bvppBids[npBestAlloc[i]])->printVector();
	}

	printf("Revenue: %d\n",revenue);
	sw_time = pfsw->Lap();
	printf("Time: %lf\n",sw_time);
	fprintf(fp_dabOutput, "DAB Total Time,  %f\n", sw_time); 
	fprintf(fp_2output, "%d, %f\n", revenue, sw_time); 
	fprintf(fp_3output, "%d, %d, %d, %f\n",
		nGoods, nBids, revenue, sw_time );
	fclose(fp_dabOutput);
	fclose(fp_2output);
	fclose(fp_3output);
}


/*
void Dabl::findBest(int nNumTakenSoFar, int pos)
{
	int rev = 0, i = 0;

	// go to next admissible bid; 
	while (pos < nBids && 
		   bvpSoldGoods->num_set != bvpSoldGoods->num &&
		   incompatible(pos))
		pos++;

	if (pos >= nBids || bvpSoldGoods->num_set == nGoods) {
	// there were no more admissible bids, so allocation is maximal;
	// see if this allocation beats the best known
		rev = 0;
		for (i = 0; i < nNumTakenSoFar; i++)
			rev += npPrices[npTakenBids[i]];
		if (rev > nBestRevenue) {
			cout << "revenue: " << rev << " # bids: " 
				<< nNumTakenSoFar << 
				", time: " << pfsw->Lap() << endl;
			nBestRevenue = rev;
			for (i = 0; i < nNumTakenSoFar; i++)
				 npBestAlloc[i] = npTakenBids[i];
			for ( ; i < nGoods; i++)
				 npBestAlloc[i] = 0;
			nNumBestRevenueBids = nNumTakenSoFar;  
		}
		return;				   	
	}

	else {
#ifdef _DEBUG
		assert(pos < nBids);
#endif
	// we're at an addable bid

	// add it:
		npTakenBids[nNumTakenSoFar] = npSortArray[pos];
		updateBitVector(pos);	
		nNumTakenSoFar++;
		
		
	// best allocation *with* the bid just added
		findBest(nNumTakenSoFar, pos + 1);		
		unUpdateBitVector(pos);
		nNumTakenSoFar--;
		
		if (numreversed < MAXREVERSE) {
			numreversed++;

			findBest(nNumTakenSoFar, pos + 1);

			numreversed--;
		}

	}
		
}


void Dabl::updateBitVector(int p)
{
	assert(bvpSoldGoods->
		disjunctFrom(bvppBids[npSortArray[p]], 0));
	bvpSoldGoods = bvpSoldGoods->
		unionWith(bvpSoldGoods, bvppBids[npSortArray[p]]);
}


void Dabl::unUpdateBitVector(int p)
{
	int i;

	for (i = 0; i < nGoods; i++)
		if ((bvppBids[npSortArray[p]])->readArray(i))
			bvpSoldGoods->clearBit(i);
}

int Dabl::incompatible(int p)
{
	if (bvpSoldGoods->disjunctFrom(bvppBids[npSortArray[p]], 0))
		return 0;
	else return 1;
}


*/

#endif // MULTI_UNIT
