// CASS2.CPP - inline functions from Cass.cpp

#ifndef CASS2
#define CASS2

#include <string.h>
#include <stdio.h>

#include "defines.h"
#include "cass.h"
#include "cache.h"
#include "stopwatch.h"
#include "stats.h"

extern Stopwatch sw;

// TODO:
// - constructNewBin: make sure it is correct
// - MU bin ordering, sorting
// loop bound in constructNewBin
// indexing problems with singletons?
// inconsistencies with MultiBin::num_subbins?

// this is the main function where everything goes down! 

INLINE_RECURSIVE int Cass::allocate (Allocation *allocation)
{
  // these are the variables that need to have different values on
  // each recursive step
    Allocation *new_allocation;
  unsigned int best_revenue = 0;
  stats->incrementRecursiveCalls();
  unsigned temp_amount;
  aborted_subtree_search = false;
  
#ifdef DECISION_PROBLEM
  if ((decision_cutoff!=0) && (best->amount > decision_cutoff))
	  return best->amount;
#endif

#ifdef TIME_LIMIT
  if((timeLimit != 0) && (sw.Lap() >= timeLimit))  {
		usedTimeLimit = true;
		return best->amount;
  }
#endif

  // caching 
#ifdef CACHING_ENABLED
  int cache_index=-1;
  bool cache_match=false;
  unsigned long initial_recursive_calls;

  // check out the cache function for this bin
  cache_index = cache->getCacheItem(allocation->vec);
  cache_match = cache->foundMatch();
 
  // a cache table entry exists for this partial allocation
  if (cache_index != -1)
    {
      if (!cache->isEmptyEntry(cache_index) && cache_match)
	{
				// check for a cache hit
	  if (best->amount >= allocation->amount + cache->getAmount(cache_index))
	    {
	      // gather stats
	      stats->incrementCacheHit();
	      
	      
	      // no value in this subtree can contain an allocation better than 'best'
	      return cache->getAmount(cache_index);  // because best_revenue must be zero here
	    }
	}
      
      // cache miss -- but we may store something better here if alloc->amount is lower than before
#ifdef GATHER_CACHE_USAGE_STATS
      
      CACHE_STAT(cache->cache_store,binset->currentBin()->binNumber(),allocation->vec->getNumSet() - binset->currentBin()->binNumber())++;
#endif
      
      initial_recursive_calls = stats->num_recursive_calls;
      cache->lock(cache_index);		// prevent another item later on from hashing to the same point
    }
#endif // CACHING_ENABLED

	// avoid allocating memory all the time
	new_allocation = binset->currentBin()->tempAllocation();

	// consider the next element of bin i
	while (binset->nextBid())
	{
#ifdef DECISION_PROBLEM
  if ((decision_cutoff!=0) && (best->amount > decision_cutoff))
	  return best->amount;
#endif

		// pruning - done before, but best may have increased.  Pruneval doesn't have to be recomputed, but check again.
#ifdef PRUNING_ENABLED
	  if (binset->currentBin()->currentBid()->pruneVal() + allocation->amount <= best->amount)
	    {
	      stats->incrementPruneHit();
				//kkk - I don't know why the following doesn't work.  But try with srand(17), 65g, 1500b
	      binset->currentBin()->bidSearched(binset->currentBin()->currentBid());
	      best_revenue = max(best_revenue,
				 binset->currentBin()->currentBid()->pruneVal());
	      continue;
	    }
#endif
	  
	  // construct new allocation
	  temp_amount = binset->currentBin()->currentBid()->amount;
	  
	  
	  new_allocation->amount = allocation->amount + temp_amount;
	  allocation->vec->unionWith(new_allocation->vec,binset->currentBin()->currentBid()->vec);
	  
	  main_path->append(binset->currentBin()->currentBid());
	  
	  BIN *parent_bin = binset->currentBin();
	  Bid *this_bid = parent_bin->currentBid();
	  unsigned bid_num = this_bid->bid_num;
	  
	  // add more goods
#ifndef MULTI_UNIT
	  if (/*(unsigned) new_allocation->vec->getNumSet() < NUM_UNITS &&*/
		  (unsigned) new_allocation->vec->lowOrderMissing(binset->currentBin()->binNumber()) <
		  (unsigned) (NUM_UNITS - NUM_DUMMY_ITEMS))
#else
	  if ((unsigned) new_allocation->vec->getNumSet() < NUM_UNITS)
#endif
	    {
	      // set new bin
	      if (binset->nextBin(new_allocation,best->amount,main_path))
		{
		  
		  best_revenue = max(best_revenue, temp_amount + binset->currentBin()->max_prune_val);
		  // abort if we exceed our allowed limit
				#ifdef RANDOMIZE
					if (parent_bin->binNumber() == 0)
					{
						stats->search_count = 0;
						aborted_subtree_search = false;  // new subtree
						
						// check to see if this item has been searched before
						#ifdef RANDOMIZE_FIRST_BIN_CONSTANT
							for (unsigned ctr = 0; ctr < already_searched_ctr; ctr++)
							{
								if (already_searched[ctr] == bid_num)
								{
									binset->prevBin();
									parent_bin->bidSearched(this_bid);
									main_path->remove();
									goto already_searched_exit;  // jump back to top of while loop
								}    
							}
						#endif
					}

					if (aborted_subtree_search && parent_bin->binNumber() != 0)
						return -1; // backtrack on aborted subtree search: why search deeper?
				#endif

				// recursively call allocate() 
				int returned_rev = allocate (new_allocation);
				
				// abort if we exceed our allowed limit
				#ifdef RANDOMIZE
					stats->search_count++;
					if (stats->search_count > abort_time)
					{
						aborted_during_search = true;
						aborted_subtree_search = true;
						if (parent_bin->binNumber() != 0)
							return -1;
					}
					#ifdef RANDOMIZE_FIRST_BIN_CONSTANT
						if (parent_bin->binNumber() == 0)
							already_searched[already_searched_ctr++] = bid_num;
					#endif
				#endif

				binset->prevBin();
				if (!aborted_subtree_search)
				{
					parent_bin->bidSearched(this_bid);
					best_revenue = max(best_revenue,
							   temp_amount +
							   returned_rev);
				}

			}
		
			// the new bin was empty (why does this ever happen - note to self 3/31/00)
			else
			{
				best_revenue = max(best_revenue,
						   temp_amount +
						   binset->currentBin()->max_prune_val);
				binset->prevBin();
				parent_bin->bidSearched(this_bid);
			}
		}
			
		// new_allocation names all the goods
		else 
		{
			// update variables
			stats->incrementNumExamined();

			// update MIS variables
			#ifdef COUNT_MIS
				stats->mis_num++;
				stats->mis_min = min(stats->mis_min, new_allocation->amount);
				stats->mis_max = max(stats->mis_max, new_allocation->amount);
				stats->mis_sum = stats->mis_sum + new_allocation->amount;
				stats->mis_sum_sq = stats->mis_sum_sq + new_allocation->amount * new_allocation->amount;
			#endif

			parent_bin->bidSearched(this_bid);
			best_revenue = max (best_revenue, temp_amount);  //new_allocation->amount);
	
			// this is the best allocation seen so far
			
			if (new_allocation->amount > best->amount)
			{
				best->amount = new_allocation->amount;
				main_path->copyTo(best->path);
				
				// output if this is the best allocation
				#ifdef PRINTOUT_BEST_ALLOCS
					printf (" New best:  $ %d   (%lf)\n",best->amount,sw.Lap());
//					reportWinningBids("dummy");
					stats->search_count = (stats->search_count * 2) / 3;
					fflush (stdout);
					binset->currentBin()->progress = 101; // make the percentage print out again
					stats->updateAnytimeStats(best->amount);
				#endif
			}
		} // if
		
	  // pop an item from the main path
	  main_path->remove();
		
#ifdef RANDOMIZE_FIRST_BIN_CONSTANT
already_searched_exit: ;
#endif
	} // while

	// no more items in binset->currentBin()
#ifdef CACHING_ENABLED
	// unlock
	if (cache_index != -1)
		cache->unlock(cache_index);

	// unlock
	if (cache_index != -1)
		cache->unlock(cache_index);
	
	// if there is a current cache entry, and this entry required at least CACHE_MIN_RECURSIVE_CALLS work
	if (cache_index != -1 && stats->num_recursive_calls - initial_recursive_calls >= CACHE_MIN_RECURSIVE_CALLS)
	  {
	    
		// new cache entry -- note: add only actually adds if recursive_calls is greater than what was there before
		if (cache->isEmptyEntry(cache_index) || !cache_match)
			cache->addCacheItem(cache_index, allocation->vec,best_revenue,stats->num_recursive_calls);
		
		// cache entry already exists
		else if (cache->getAmount(cache_index) > best_revenue)
		{
		  // store the new value in the cache table -- it is
		  // better than what was there before
		  //nv
		  cache->setAmount(cache_index,best_revenue);
		  
			#ifdef PROPAGATE_AMOUNTS
				// construct array of all unallocated spaces, and count allocated spaces
				unsigned index=0;
				for (unsigned t=binset->currentBin()->binNumber()+1; t<NUM_ITEMS; t++)
				{
					if (!allocation->vec->readArray(t))
						propagate_unallocated[index++] = t;
				}

				propagate_amount = best_revenue;
				propagate_last = index;

				// propagate values through the cache
				if (propagate_last)  // at least one empty space was found
				{
					propagateAmounts(0,allocation->vec,0);
				}
			#endif
		}
	}
#endif

	// return value
	return best_revenue;
	
}

// propagate the amount for this allocation throughout the cache 
#ifdef PROPAGATE_AMOUNTS
INLINE_RECURSIVE void Cass::propagateAmounts(int first, VECTOR *vec, int iteration)
{
	static int cache_index;
	// these last three used to be members of the class -- put them back if there's a problem
	static unsigned propagate_amount;
	static int *propagate_unallocated;
	static int propagate_last;

	// now try adding each bit in turn
	for (int t=first;t<propagate_last && cache->add_counter>0;t++)
	{
		// allocate each of the free goods in turn, and record which one in the stack
		vec->setBit(propagate_unallocated[t]);
		
		// subtract the value of the singleton goods to the price, in order to reduce the estimate
		// any lower bound may be used here, but the singletons are super-easy to compute
		propagate_amount -= binset->singleton[propagate_unallocated[t]];

		// lookup this cache entry.
		cache_index = cache->getCacheItem(vec);
		
		// cache entry doesn't yet exist
		if (cache_index != -1 && cache->isEmptyEntry(cache_index) && 
			propagate_amount < binset->pruneVal(vec))
		{
			cache->addCacheItem(cache_index,vec,propagate_amount,0);
			stats->incrementNumPropagated();

			// propagate on 
			if (iteration+1 < PROPAGATE_MAX_DEPTH)
				propagateAmounts(t+1, vec,iteration+1);
		}

		// the current cache entry value is greater -- we don't have to compare to pruning amount
		else if (cache_index != -1 && !cache->isEmptyEntry(cache_index) && cache->getAmount(cache_index) > propagate_amount)
		{
			cache->setAmount(cache_index, propagate_amount);
			stats->incrementNumPropagated();

			// propagate on 
			if (iteration+1 < PROPAGATE_MAX_DEPTH)
				propagateAmounts(t+1, vec,iteration+1);
		}

		// deallocate the good that was allocated before
		vec->clearBit(propagate_unallocated[t]);
		propagate_amount += binset->singleton[propagate_unallocated[t]];  // add the lower bound back to prepare for the next iteration
	}
}
#endif // propagate_amounts

#endif //CASS2
