//////////////////////////////////////
/* The class that does all the work */
//////////////////////////////////////

#ifndef CASS
#define CASS

#include "defines.h"
#include "allocation.h"
#include "linkedlist.h"
#include "stopwatch.h"
#include "param.h"
#include "inputfile.h"
#include "binset.h"
#include "multibinset.h"
#include "cacheitem.h"
#include "cache.h"
#include "stats.h"

extern Stats *stats;

class Cass
{
public:
	// functions
	int run (InputFile& infile);
	int allocate (Allocation *a);
	void outputResults(char *filename);
	void reportWinningBids(char *filename);

	// constructor/destructor
	Cass(InputFile *infile,int cache_size);
	~Cass();
	
	// variables
	Allocation *best;
	BidHistory *main_path;
	BINSET *binset;
	unsigned abort_time,decision_cutoff;
	double timeLimit;
	bool usedTimeLimit;

	bool aborted_during_search, aborted_subtree_search;

	// cache
	#ifdef CACHING_ENABLED
		Cache *cache;
	#endif

private:
	// propagation
	#ifdef PROPAGATE_AMOUNTS
		void propagateAmounts(int first, VECTOR *vec, int iteration);
	#endif

	unsigned reportWinningBids(FILE *fp,BidHistory *history, VECTOR *vec,unsigned &bids_index,unsigned *bids);

	int progress;
	int estimate;
	unsigned *already_searched, already_searched_ctr;
};

#ifdef INLINING_ON
#ifdef INLINE_RECURSION_ON
#include "cass2.cpp"
#endif
#endif
#endif
