// cache2.cpp

#ifndef CACHE2
#define CACHE2

#include <assert.h>
#include "cacheitem.h"
#include "cache.h"

// look something up in the cache
INLINE int Cache::getCacheItem(VECTOR *input)
{
	lookup_counter = 0;
	match = false;

	// make sure caching is enabled
	if (large_prime)
	{
		// get the cache entry
		index = cacheLookup(input);
		//printf ("\ncache: getCacheIndex: index: %d", index);
//		do
//		{
			// the entry is empty
			if (cache[index] == -1)
			  {
			    //printf ("cache_index: empty ");
			    return index;
			  }
			// the entry is in use
			if (locked[index] == true)
			  {
			    //printf ("cache: locked: ");
			    return -1; // don't do anything with it
			  }
			// found the right value?
			match = input->equalTo(getTagItem(index));
			
			//printf ("cache: getcacheindex: match: %d", match);
			// either way, return the index
			return index;
						
			/*
			// counter
			lookup_counter++;
			index = (index + 1) % large_prime;
		} while (lookup_counter < MAX_CACHE_SKIPS); */
	}

	// too much work to rehash
	return -1;
}

// store something in the cache
INLINE void Cache::addCacheItem(int index, VECTOR *input, int prune_amount, int recursive_calls)
{
	// allows us to use 0 as a reserved value at the beginning
	recursive_calls++;  
	
	if (index < 0							// invalid index
		|| calls[index] >= recursive_calls	// existing item has more recursive calls
		|| locked[index])					// item is locked
		return;
	if (cache[index] == -1)
		add_counter++;
	cache[index] = prune_amount;
	memcpy(getTagItem(index),input->getArray(),ints_per_item*sizeof(VECTOR_DATA_TYPE));
	calls[index] = (recursive_calls > 255 ? 255 : recursive_calls);
}

// use the hash function to look up something in the cache
INLINE int Cache::cacheLookup(VECTOR *input)
{
	return input->hash() % large_prime;
}

// index the tag array
INLINE VECTOR_DATA_TYPE * Cache::getTagItem(int index)
{
	return &tag_array[index * ints_per_item];
}

// test if a cache entry is empty
INLINE bool Cache::isEmptyEntry(int index)
{
	return (cache[index] == -1);
}

// get an amount out of the cache
INLINE unsigned Cache::getAmount(int index)
{
	#ifdef _DEBUG
		assert (index != -1);
	#endif
	return cache[index];
}


// set cache amount
INLINE void Cache::setAmount(int index, int amount)
{
	#ifdef _DEBUG
		assert (index >=0);
	#endif
	cache[index] = amount;
}

// set cache amount
INLINE bool Cache::foundMatch()
{
	return match;
}

// lock cache item
INLINE void Cache::lock(int item)
{
	locked[item] = true;
}

// unlock cache item
INLINE void Cache::unlock(int item)
{
	locked[item] = false;
}

INLINE void Cache::setTagArray(int index, VECTOR *input)
{
  memcpy(getTagItem(index),input->getArray(),ints_per_item*sizeof(VECTOR_DATA_TYPE));
}


#endif
