// cache.h: interface for the Cache class.
//
//////////////////////////////////////////////////////////////////////

#ifndef CACHE_H
#define CACHE_H

#include "cacheitem.h"
#include "vector_include.h"

class Cache  
{
public:
	// functions
	void lock(int index);
	void unlock(int index);
	bool foundMatch();
	void addCacheItem(int index, VECTOR *input, int prune_amount, int recursive_calls);
	int getCacheItem(VECTOR *input);
	void gatherCacheStats();
	bool isEmptyEntry(int index);
	int getCacheUsage();
	unsigned getLargePrime();
	void setAmount(int index, int amount);
	void setTagArray(int index, VECTOR *input);
	unsigned getAmount(int index);
	void reset();

	// constructor/destructor
	Cache(int size, int ints_per_item);
	~Cache();

	// variables
	int *cache_store, *cache_hit,add_counter,lookup_counter;

private:
	int cacheLookup(VECTOR *input);
	VECTOR_DATA_TYPE * getTagItem(int index);
	
	// variables
	CacheItem *cache;
	VECTOR_DATA_TYPE *tag_array;
	unsigned char *calls;
	bool *locked;

	bool match;
	unsigned index, ints_per_item;
	unsigned long int large_prime,t;
};

#ifdef INLINING_ON
#include "cache2.cpp"
#endif

#endif 
