// cache.cpp: implementation of the Cache class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <math.h>
#include <string.h>

#include "cache.h"
#include "defines.h"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

void Cache::reset()
{
	memset(cache,-1,sizeof(CacheItem)*large_prime); // initialize all cache values to -1 -- marks them as unused
// tag array doesn't have to be reset: it's only checked when cache[i] != -1
//	memset(tag_array,-1,sizeof(VECTOR_DATA_TYPE)*large_prime*ints_per_item); // initialize all tag values to -1 -- marks them as unused
	memset(calls,0,large_prime*sizeof(unsigned char));
	memset(locked,0,large_prime*sizeof(bool));  // probably not legal C++
}	
	
Cache::Cache(int size, int ints_per_item)
{
	if (size == 0)
	{
		large_prime = 0;
		cache = NULL;
		tag_array = NULL;
	}
	else
	{
		this->ints_per_item = ints_per_item;
		this->large_prime = size/(sizeof(unsigned) + sizeof(VECTOR_DATA_TYPE)*ints_per_item * sizeof (unsigned char) * sizeof(bool));
		this->add_counter = 0;
		
		//#ifdef _DEBUG
		// verify that we have a prime number bigger than the cache size
		bool prime = false;
		for (;!prime;large_prime++)
		{
			prime = true;
			int limit=(int)sqrt(large_prime);
			for (int t=2;t<=limit;t++)
			{
				if (!(large_prime%t))
				{
					prime = false;
					break;
				}
			}
		}
		large_prime--;
		//#endif
		//large_prime = 15;
		// allocate cache
		cache = new CacheItem [large_prime];
		tag_array = new VECTOR_DATA_TYPE[ints_per_item * large_prime];
		calls = new unsigned char [large_prime];
		locked = new bool[large_prime];
		reset();

		// output
	
		#ifdef CACHING_OUTPUT
			printf ("Cache total %d bytes, %d items\n",large_prime*(sizeof(unsigned)+sizeof(VECTOR_DATA_TYPE)*ints_per_item), large_prime);
		#endif

		/* prepare to gather cache usage statistics */
		#ifdef GATHER_CACHE_USAGE_STATS
			cache_store = new int[NUM_ITEMS*NUM_ITEMS];
			cache_hit = new int[NUM_ITEMS*NUM_ITEMS];
			memset (cache_store,0,sizeof(int)*NUM_ITEMS*NUM_ITEMS);
			memset (cache_hit,0,sizeof(int)*NUM_ITEMS*NUM_ITEMS);
		#endif

		match = false;
	}
}

// destructor
Cache::~Cache()
{
	#ifdef GATHER_CACHE_USAGE_STATS
		delete[] cache_store;
		delete[] cache_hit;
	#endif

	if (tag_array) delete[] tag_array;
	if (cache) delete[] cache;
	if (calls) delete[] calls;
	if (locked) delete[] locked;
}

// output cache usage statistics
void Cache::gatherCacheStats()
{
// #ifdef GATHER_CACHE_USAGE_STATS
// 	FILE *fp = fopen ("cache_stats.csv","wt");
// 	if (!fp) printf ("error opening file");
// 	fprintf (fp,"\"Cache Stores:\"\n");
// 	for (i=0;i<NUM_ITEMS;i++)
// 	{
// 		fprintf (fp,"%d",i);
// 		for (j=0;j<=this->bin[i]->max_find;j++)
// 			fprintf(fp,", %d",CACHE_STAT(cache_store,i,j));
// 		fprintf (fp,"\n");
// 	}
// 	fprintf (fp,"\n\n");
// 	fprintf (fp,"\"Cache Hits:\"\n");
// 	for (i=0;i<NUM_ITEMS;i++)
// 	{
// 		fprintf (fp,"%d",i);
// 		for (j=0;j<=this->bin[i]->max_find;j++)
// 			fprintf(fp,", %d",CACHE_STAT(cache_hit,i,j));
// 		fprintf (fp,"\n");
// 	}
// 	fclose(fp);
// #endif
}




unsigned Cache::getLargePrime()
{
	return large_prime;
}

int Cache::getCacheUsage()
{
	return add_counter;
}
