// BINSET2.CPP

#ifndef BINSET2
#define BINSET2

#include "defines.h"

#ifndef MULTI_UNIT

#include <stdlib.h>
#include "binset.h"

// accessor for the current bin
INLINE Bin * BinSet::currentBin()
{
	return bin[current_bin];
}

// call bin->bidSearched()
INLINE void BinSet::currentBidSearched()
{
	printf ("Don't call this!\n");
	//	currentBin()->bidSearched(currentBin()->currentBid());
}

// get the next bin
INLINE bool BinSet::nextBin(Allocation *allocation, int best_amount, BidHistory *history)
{
	binstack[++binstack_pointer] = current_bin;
	current_bin = currentBin()->currentBid()->nextBin();  // lom number

#ifdef _DEBUG
	if (current_bin == -1 || current_bin == binstack[binstack_pointer])
	{
		printf ("BinSet::nextBin() error:  ");
		allocation->vec->printVector();
		exit(1);
	}
#endif
	
	// construct the new bin -- this is a bin "ahead" of where we are, since it is next.  So it won't conflict with anything else on the stack.
	bin[current_bin]->constructNewBin(allocation,best_amount);
	
	return (bin[current_bin]->dynNum() != 0);  // return "is a non-empty bin"
}

// go to the last bin that was current
INLINE void BinSet::prevBin()
{
#ifdef _DEBUG
	if (binstack_pointer == -1)
	{
		printf ("BinSet::prevBin() -- Binstack failure\n");
		exit(1);
	}
#endif
	current_bin = binstack[binstack_pointer--];
}

// calculate the pruning value, given the bin number
INLINE unsigned BinSet::pruneVal(BitVector *vec, int bin_num)
{
	return bin[bin_num]->pruneVal(vec);
}

// calculate the pruning value
INLINE unsigned BinSet::pruneVal(BitVector *vec)
{
	return bin[vec->lowOrderMissing(0)]->pruneVal(vec);
}

// if desired, report progress of search (percentage of the way through bin zero)
INLINE void BinSet::displayProgress()
{
	#ifdef DISPLAY_PROGRESS
		if ( (currentBin()->binNumber() == 0 || currentBin()->progress == 101) 
			&& (bin[0]->percentDone() != currentBin()->progress))
		{
			currentBin()->progress = bin[0]->percentDone();
			printf ("%3d%%\b\b\b\b\b\b\b\b",currentBin()->progress);
		}
	#endif
}

INLINE bool BinSet::nextBid()
{
	displayProgress();
	
	return bin[current_bin]->nextBid();
}

#endif // !multi_unit
#endif
